/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.converter;

import com.intersult.jpa.HibernateHelper;
import java.io.Serializable;
import javax.faces.context.FacesContext;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.metadata.ClassMetadata;

public class EntityConverterBean {
    public String getId(Class<?> entityClass, Object entity) {
        if (entity == null) {
            return null;
        }
        Session session = (Session)HibernateHelper.instance().getEntityManager().getDelegate();
        ClassMetadata classMetadata = session.getSessionFactory().getClassMetadata(entityClass);
        if (classMetadata == null) {
            throw new IllegalArgumentException("Cannot convert field type '" + entityClass.getName() + "' to entity");
        }
        Serializable key = classMetadata.getIdentifier(entity, (SessionImplementor)session);
        FacesContext context = FacesContext.getCurrentInstance();
        String id = (String)context.getApplication().getExpressionFactory().coerceToType((Object)key, String.class);
        return id;
    }

    public <T> T getEntity(Class<T> entityClass, String id) {
        if (id == null) {
            return null;
        }
        Session session = (Session)HibernateHelper.instance().getEntityManager().getDelegate();
        ClassMetadata classMetadata = session.getSessionFactory().getClassMetadata(entityClass);
        if (classMetadata == null) {
            return null;
        }
        Class keyType = classMetadata.getIdentifierType().getReturnedClass();
        FacesContext context = FacesContext.getCurrentInstance();
        Serializable key = null;
        try {
            key = (Serializable)context.getApplication().getExpressionFactory().coerceToType((Object)id, keyType);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (key == null) {
            return null;
        }
        Object entity = HibernateHelper.instance().getEntityManager().find(entityClass, (Object)key);
        return (T)entity;
    }
}

