/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.component.ui;

import com.intersult.jsf.util.io.Base64Codec;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import javax.faces.component.FacesComponent;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.imageio.ImageIO;

@FacesComponent(value="intersult.VerticalText")
public class VerticalTextComponent
extends UIOutput {
    public static final String COMPONENT_NAME = "intersult.VerticalText";
    public static final String COMPONENT_FAMILY = "intersult.VerticalText";

    public String getFamily() {
        return "intersult.VerticalText";
    }

    public int getWidth() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)"width"), (Object)(this.getFontSize() + 5));
    }

    public void setWidth(int width) {
        this.getStateHelper().put((Serializable)((Object)"width"), (Object)width);
    }

    public int getHeight() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)"height"), (Object)200);
    }

    public void setHeight(int height) {
        this.getStateHelper().put((Serializable)((Object)"height"), (Object)height);
    }

    public int getFontSize() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)"fontSize"), (Object)20);
    }

    public void setFontSize(int fontSize) {
        this.getStateHelper().put((Serializable)((Object)"fontSize"), (Object)fontSize);
    }

    public String getFontName() {
        return (String)this.getStateHelper().eval((Serializable)((Object)"fontName"), (Object)"Serif");
    }

    public void setFontName(String fontName) {
        this.getStateHelper().put((Serializable)((Object)"fontName"), (Object)fontName);
    }

    public String getColor() {
        return (String)this.getStateHelper().eval((Serializable)((Object)"color"), (Object)"#000000");
    }

    public void setColor(String color) {
        this.getStateHelper().put((Serializable)((Object)"color"), (Object)color);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("img", (UIComponent)this);
        writer.writeAttribute("src", (Object)this.getImageBase64(), "value");
    }

    public void encodeEnd(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("img");
        super.encodeEnd(context);
    }

    private String getImageBase64() throws IOException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("data:image/png;base64,");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)this.getImage(), "png", outputStream);
        buffer.append(Base64Codec.encode(outputStream.toByteArray()));
        return buffer.toString();
    }

    private BufferedImage getImage() {
        String text = this.getCurrentValue(this.getFacesContext());
        int width = this.getWidth();
        int height = this.getHeight();
        int fontSize = this.getFontSize();
        String fontName = this.getFontName();
        String color = this.getColor();
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D graphics = image.createGraphics();
        graphics.setComposite(AlphaComposite.Src);
        graphics.setFont(new Font(fontName, 0, fontSize));
        AffineTransform transform = graphics.getTransform();
        graphics.rotate(-1.5707963267948966);
        graphics.setPaint(Color.decode(color));
        graphics.drawString(text, -height, width - 5);
        graphics.setTransform(transform);
        graphics.dispose();
        return image;
    }

    public String getCurrentValue(FacesContext context) {
        Object currentValue = this.getValue();
        Converter converter = this.getConverter();
        if (converter == null) {
            if (currentValue == null) {
                return "";
            }
            if (currentValue instanceof String) {
                return (String)currentValue;
            }
            Class<?> converterType = currentValue.getClass();
            converter = context.getApplication().createConverter(converterType);
            if (converter == null) {
                return currentValue.toString();
            }
        }
        return converter.getAsString(context, (UIComponent)this, currentValue);
    }
}

