/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.component.ui;

import com.intersult.jsf.Jsf;
import com.intersult.jsf.el.ExpressionAnalyzer;
import com.intersult.jsf.el.ValueReference;
import com.intersult.jsf.util.java.AnnotationUtils;
import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.LabelRenderer;
import com.sun.faces.util.MessageUtils;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.logging.Level;
import javax.el.ValueExpression;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.NotEmpty;

@FacesRenderer(componentFamily="javax.faces.Output", rendererType="intersult.Label")
public class RequiredLabelRenderer
extends LabelRenderer {
    private static final Attribute[] ATTRIBUTES = AttributeManager.getAttributes((AttributeManager.Key)AttributeManager.Key.OUTPUTLABEL);
    private static final String RENDER_END_ELEMENT = "com.sun.faces.RENDER_END_ELEMENT";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        String forClientId = null;
        String forValue = (String)component.getAttributes().get("for");
        if (forValue != null) {
            UIComponent forComponent = this.getForComponent(context, forValue = this.augmentIdReference(forValue, component), component, false);
            forClientId = forComponent == null ? this.getForComponentClientId(component, context, forValue) : forComponent.getClientId(context);
        }
        component.getAttributes().put(RENDER_END_ELEMENT, "yes");
        writer.startElement("label", component);
        this.writeIdAttributeIfNecessary(context, writer, component);
        if (forClientId != null) {
            writer.writeAttribute("for", (Object)forClientId, "for");
        }
        RenderKitUtils.renderPassThruAttributes((FacesContext)context, (ResponseWriter)writer, (UIComponent)component, (Attribute[])ATTRIBUTES);
        String styleClass = this.getStyleClass(context, component);
        if (null != styleClass && !"".equals(styleClass)) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        writer.writeText((Object)"\n", component, null);
        String value = this.getCurrentValue(context, component);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Value to be rendered " + value);
        }
        if (value != null && value.length() != 0) {
            boolean escape;
            Object val = component.getAttributes().get("escape");
            boolean bl = escape = val != null && Boolean.valueOf(val.toString()) != false;
            if (escape) {
                writer.writeText((Object)value, component, "value");
            } else {
                writer.write(value);
            }
        }
        writer.flush();
    }

    public String getStyleClass(FacesContext context, UIComponent component) {
        Boolean required;
        StringBuilder buffer = new StringBuilder();
        String styleClass = (String)component.getAttributes().get("styleClass");
        if (styleClass != null) {
            buffer.append(styleClass);
        }
        if (Boolean.TRUE.equals(required = this.getRequired(context, component))) {
            String requiredStyleClass;
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            if ((requiredStyleClass = (String)component.getAttributes().get("requiredStyleClass")) == null) {
                requiredStyleClass = "label-required";
            }
            buffer.append(requiredStyleClass);
        } else if (Boolean.FALSE.equals(required)) {
            String notRequiredStyleClass;
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            if ((notRequiredStyleClass = (String)component.getAttributes().get("notRequiredStyleClass")) == null) {
                notRequiredStyleClass = "label-not-required";
            }
            buffer.append(notRequiredStyleClass);
        }
        return buffer.toString();
    }

    public Boolean getRequired(FacesContext context, UIComponent component) {
        Boolean disabled = (Boolean)component.getAttributes().get("disabled");
        if (Boolean.TRUE.equals(disabled)) {
            return Boolean.FALSE;
        }
        String forValue = (String)component.getAttributes().get("forComponent");
        if (forValue == null) {
            forValue = (String)component.getAttributes().get("for");
        }
        if (forValue == null) {
            return null;
        }
        UIComponent forComponent = this.getForComponent(context, forValue = this.augmentIdReference(forValue, component), component, true);
        if (forComponent == null) {
            return null;
        }
        if (!(forComponent instanceof EditableValueHolder)) {
            return null;
        }
        if (Boolean.TRUE.equals(forComponent.getAttributes().get("disabled"))) {
            return null;
        }
        if (((EditableValueHolder)forComponent).isRequired()) {
            return true;
        }
        ValueExpression valueExpression = forComponent.getValueExpression("value");
        if (valueExpression == null) {
            return null;
        }
        ValueReference valueReference = ExpressionAnalyzer.getReference(valueExpression, context.getELContext());
        if (valueReference == null) {
            return null;
        }
        List<Annotation> annotations = AnnotationUtils.getAnnotations(valueReference.getBaseClass(), valueReference.getProperty().toString());
        try {
            if (RequiredAnnotationChecker.check(annotations)) {
                return Boolean.TRUE;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ValueExpression requiredExpression = component.getValueExpression("required");
        if (requiredExpression != null && Boolean.TRUE.equals(requiredExpression.getValue(context.getELContext()))) {
            return Boolean.TRUE;
        }
        if ("true".equals(component.getAttributes().get("required"))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected UIComponent getForComponent(FacesContext context, String forComponent, UIComponent component, boolean warn) {
        UIComponent result;
        block6: {
            if (null == forComponent || forComponent.length() == 0) {
                return null;
            }
            result = null;
            try {
                for (UIComponent currentParent = component; currentParent != null && (result = currentParent.findComponent(forComponent)) == null; currentParent = currentParent.getParent()) {
                }
                if (result == null) {
                    result = Jsf.findUIComponentBelow((UIComponent)context.getViewRoot(), forComponent);
                }
            }
            catch (Exception exception) {
                if (!warn || !logger.isLoggable(Level.FINEST)) break block6;
                logger.log(Level.FINEST, "Unable to find for component", exception);
            }
        }
        if (warn && result == null && logger.isLoggable(Level.WARNING)) {
            logger.warning(MessageUtils.getExceptionMessageString((String)"com.sun.faces.COMPONENT_NOT_FOUND_IN_VIEW_WARNING", (Object[])new Object[]{forComponent}));
        }
        return result;
    }

    public static class RequiredAnnotationChecker {
        public static boolean check(List<Annotation> annotations) {
            for (Annotation annotation : annotations) {
                if (annotation instanceof NotNull) {
                    return true;
                }
                if (annotation instanceof NotEmpty) {
                    return true;
                }
                if (!(annotation instanceof Size) || ((Size)annotation).min() <= 0) continue;
                return true;
            }
            return false;
        }
    }
}

