/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.component.scope;

import com.intersult.jsf.Jsf;
import com.intersult.jsf.Scopes;
import java.io.IOException;
import java.io.Serializable;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagException;
import javax.faces.view.facelets.TagHandler;

public class UnloadHandler
extends TagHandler {
    public UnloadHandler(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext context, UIComponent parent) throws IOException {
        if (!(parent instanceof ActionSource)) {
            throw new TagException(this.tag, "Tag must be child of ActionSource component");
        }
        if (!ComponentHandler.isNew((UIComponent)parent)) {
            return;
        }
        ActionSource actionSource = (ActionSource)parent;
        TagAttribute scopeIdAttribute = this.getAttribute("scopeId");
        ValueExpression scopeIdExpression = scopeIdAttribute == null ? null : scopeIdAttribute.getValueExpression(context, String.class);
        boolean immediate = false;
        TagAttribute immediateAttribute = this.getAttribute("immediate");
        if (immediateAttribute != null) {
            immediate = Boolean.TRUE.equals(immediateAttribute.getObject(context, Boolean.class));
        }
        actionSource.addActionListener((ActionListener)new UnloadActionListener(scopeIdExpression, immediate));
        this.nextHandler.apply(context, parent);
    }

    public static class UnloadActionListener
    implements ActionListener,
    Serializable {
        private static final long serialVersionUID = 1L;
        private ValueExpression scopeIdExpression;
        private boolean immediate;

        public UnloadActionListener(ValueExpression scopeIdExpression, boolean immediate) {
            this.scopeIdExpression = scopeIdExpression;
            this.immediate = immediate;
        }

        public void processAction(ActionEvent event) {
            String resolvedId;
            if (this.scopeIdExpression == null) {
                resolvedId = Scopes.instance().getId();
            } else {
                String scopeId = (String)this.scopeIdExpression.getValue(FacesContext.getCurrentInstance().getELContext());
                if (scopeId == null) {
                    throw new FacesException("Unload-Tag must be placed inside <e:scope> or specify attribute scopeId");
                }
                resolvedId = Jsf.resolveId(event.getComponent(), scopeId);
            }
            Scopes.instance().unload(resolvedId, this.immediate);
        }
    }
}

