/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.component.scope;

import com.intersult.jsf.Jsf;
import com.intersult.jsf.Scopes;
import com.intersult.jsf.component.scope.ScopeComponent;
import java.io.IOException;
import java.util.Map;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;

public class ScopeHandler
extends ComponentHandler {
    public ScopeHandler(ComponentConfig config) {
        super(config);
    }

    public static void includeFacelet(FaceletContext ctx, UIComponent component, String viewId, String library) throws IOException {
        if (library == null || "".equals(library)) {
            ctx.includeFacelet(component, viewId);
        } else {
            ResourceHandler resourceHandler = ctx.getFacesContext().getApplication().getResourceHandler();
            Resource resource = resourceHandler.createResource(viewId, library);
            if (resource == null) {
                throw new IOException("Error loading scope viewId '" + viewId + "', library '" + library + "'");
            }
            ctx.includeFacelet(component, resource.getURL());
        }
    }

    public void applyNextHandler(FaceletContext context, UIComponent component) throws IOException, FacesException, ELException {
        TagAttribute recoverAttribute;
        ScopeComponent scopeComponent = (ScopeComponent)component;
        Scopes scopes = Scopes.instance();
        String viewId = scopeComponent.getViewId();
        String library = scopeComponent.getLibrary();
        Scopes.Lifecycle lifecycle = scopeComponent.getLifecycle();
        Boolean load = scopeComponent.getLoad();
        TagAttribute actionAttribute = this.getTagAttribute("action");
        if (actionAttribute != null) {
            scopeComponent.setAction(actionAttribute.getMethodExpression(context, Void.TYPE, new Class[0]));
        }
        if ((recoverAttribute = this.getTagAttribute("recover")) != null) {
            scopeComponent.setRecover(recoverAttribute.getMethodExpression(context, Boolean.TYPE, new Class[]{Throwable.class}));
        }
        String clientId = component.getClientId(context.getFacesContext());
        Scopes.Scope scope = scopes.get(clientId);
        if (load != null) {
            if (load.booleanValue() && scope == null) {
                scope = Scopes.instance().load(scopeComponent, true, lifecycle);
            } else if (!load.booleanValue() && scope != null) {
                scope.unload();
            }
        }
        if (scope != null) {
            try {
                ValueExpression origExpression = context.getVariableMapper().setVariable("scope", context.getExpressionFactory().createValueExpression((Object)scope, Scopes.Scope.class));
                Object parentId = Scopes.push(clientId);
                if (viewId != null) {
                    ScopeHandler.includeFacelet(context, component, viewId, library);
                }
                super.applyNextHandler(context, component);
                Map<String, Object> parameters = Jsf.getParameterMap(component, true);
                scope.putAll(parameters);
                Scopes.pop(parentId);
                context.getVariableMapper().setVariable("scope", origExpression);
            }
            catch (Exception exception) {
                throw new FacesException("Error loading facelet '" + viewId + "' in scope '" + clientId + "'", (Throwable)exception);
            }
        }
    }

    public void onComponentCreated(FaceletContext context, UIComponent component, UIComponent parent) {
        parent.getChildren().add(component);
    }
}

