/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.component.scope;

import com.intersult.jsf.Jsf;
import com.intersult.jsf.Scopes;
import com.intersult.jsf.component.ComponentHandlerBase;
import com.intersult.jsf.component.scope.LoadComponent;
import com.intersult.jsf.component.scope.ScopeComponent;
import com.intersult.jsf.tag.TagContext;
import java.io.Serializable;
import java.util.Map;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.view.facelets.ComponentConfig;

public class Load2Handler
extends ComponentHandlerBase {
    public Load2Handler(ComponentConfig config) {
        super(config);
    }

    @Override
    public void apply(TagContext context) {
        LoadListener listener = new LoadListener();
        listener.setAction(context.getAttribute("action").getMethodExpression(Void.TYPE, new Class[0]));
        listener.setUnloadAction(context.getAttribute("unloadAction").getMethodExpression(Void.TYPE, new Class[0]));
        LoadComponent loadComponent = (LoadComponent)context.getComponent();
        listener.setComponent(loadComponent);
        context.applyAction(listener);
    }

    public static class LoadListener
    implements ActionListener,
    Serializable {
        private static final long serialVersionUID = 1L;
        private LoadComponent component;
        private MethodExpression action;
        private MethodExpression unloadAction;

        public LoadComponent getComponent() {
            return this.component;
        }

        public void setComponent(LoadComponent component) {
            this.component = component;
        }

        public MethodExpression getAction() {
            return this.action;
        }

        public void setAction(MethodExpression action) {
            this.action = action;
        }

        public MethodExpression getUnloadAction() {
            return this.unloadAction;
        }

        public void setUnloadAction(MethodExpression unloadAction) {
            this.unloadAction = unloadAction;
        }

        public void processAction(ActionEvent event) throws AbortProcessingException {
            Scopes.Scope scope;
            if (!this.component.isRendered()) {
                return;
            }
            String scopeId = this.component.getScopeId();
            String viewId = this.component.getViewId();
            String library = this.component.getLibrary();
            Boolean cascade = this.component.getCascade();
            Scopes.Lifecycle lifecycle = this.component.getLifecycle();
            if (viewId == null) {
                if (scopeId == null) {
                    throw new FacesException("Missing scope id in tag load '" + this.component.getClientId() + "'");
                }
                ScopeComponent scopeComponent = Scopes.findScopeComponent(scopeId);
                scope = Scopes.instance().load(scopeComponent, cascade, lifecycle);
            } else {
                scope = Scopes.instance().load(scopeId, viewId, library, cascade, lifecycle);
            }
            Map<String, Object> parameters = Jsf.getParameterMap((UIComponent)this.component, true);
            scope.putAll(parameters);
            if (this.action != null) {
                FacesContext context = FacesContext.getCurrentInstance();
                Object previous = scope.push();
                this.action.invoke(context.getELContext(), null);
                scope.pop(previous);
            }
            if (this.unloadAction != null) {
                scope.put("scope.unloadAction", this.unloadAction);
            }
        }
    }
}

