/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.component.push;

import com.intersult.jsf.Jsf;
import com.intersult.jsf.push.PushContext;
import com.intersult.jsf.util.Behaviors;
import com.sun.faces.renderkit.Attribute;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.faces.application.ResourceDependency;
import javax.faces.component.FacesComponent;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

@FacesComponent(value="intersult.Socket")
@ResourceDependency(name="atmosphere.js", library="ext-js", target="head")
public class SocketComponent
extends UIComponentBase
implements ClientBehaviorHolder {
    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList("open", "close", "message", "error"));
    public static final Attribute ONOPEN = Attribute.attr((String)"onopen", (String[])new String[]{"open"});
    public static final Attribute ONCLOSE = Attribute.attr((String)"onclose", (String[])new String[]{"close"});
    public static final Attribute ONMESSAGE = Attribute.attr((String)"onmessage", (String[])new String[]{"message"});
    public static final Attribute ONERROR = Attribute.attr((String)"onerror", (String[])new String[]{"error"});

    public String getFamily() {
        return "intersult.Socket";
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public String getDefaultEventName() {
        return "message";
    }

    public String getChannel() {
        return (String)this.getStateHelper().get((Serializable)((Object)"channel"));
    }

    public void setChannel(String channel) {
        this.getStateHelper().put((Serializable)((Object)"channel"), (Object)channel);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        String onerror;
        String onmessage;
        String onclose;
        super.encodeBegin(context);
        String clientId = this.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("script", (UIComponent)this);
        writer.writeAttribute("id", (Object)clientId, "clientId");
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("var request = {\r\n");
        String channel = this.getChannel();
        String url = context.getExternalContext().getRequestContextPath() + PushContext.getPushUrl(context, channel);
        writer.write("\turl: '" + url + "',\r\n");
        if (Jsf.isDebug()) {
            writer.write("\tlogLevel: 'debug',\r\n");
        }
        writer.write("\ttransport: 'websocket',\r\n");
        writer.write("\ttimeout: 0,\r\n");
        writer.write("\treconnectInterval: 30000,\r\n");
        writer.write("\tmaxReconnectOnClose: Number.MAX_VALUE,\r\n");
        writer.write("\tfallbackTransport: 'long-polling',\r\n");
        writer.write("\tautoConnect: true,\r\n");
        String onopen = Behaviors.getValueWithBehaviors((UIComponent)this, ONOPEN);
        if (onopen != null && !"".equals(onopen)) {
            writer.write("\tonOpen: function(response) {" + onopen + "},\r\n");
            writer.write("\tonReopen: function(response) {" + onopen + "},\r\n");
        }
        if ((onclose = Behaviors.getValueWithBehaviors((UIComponent)this, ONCLOSE)) != null && !"".equals(onclose)) {
            writer.write("\tonClose: function(response) {" + onclose + "},\r\n");
        }
        if ((onmessage = Behaviors.getValueWithBehaviors((UIComponent)this, ONMESSAGE)) != null && !"".equals(onmessage)) {
            writer.write("\tonMessage: function(response) {" + onmessage + "},\r\n");
        }
        if ((onerror = Behaviors.getValueWithBehaviors((UIComponent)this, ONERROR)) != null && !"".equals(onerror)) {
            writer.write("\tonError: function(response) {" + onerror + "}\r\n");
        }
        writer.write("};\r\n");
        writer.write("var socket = atmosphere.subscribe(request);\r\n");
        writer.endElement("script");
    }
}

