/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.component.push;

import com.intersult.jsf.Jsf;
import com.intersult.jsf.extensions.ExtPartialResponseWriter;
import com.intersult.jsf.push.PushContext;
import com.intersult.jsf.view.RenderVisitCallback;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.FacesComponent;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

@FacesComponent(value="intersult.Push")
@ResourceDependencies(value={@ResourceDependency(name="jsf.js", library="javax.faces"), @ResourceDependency(name="ajax.js", library="ext-js"), @ResourceDependency(name="atmosphere.js", library="ext-js", target="head"), @ResourceDependency(name="push.js", library="ext-js", target="head")})
public class PushComponent
extends UINamingContainer {
    public static final String PUSH_ATTRIBUTE = "intersult.Push";

    public String getFamily() {
        return PUSH_ATTRIBUTE;
    }

    public boolean getRendersChildren() {
        return true;
    }

    public String getChannel() {
        String channel = (String)this.getStateHelper().eval((Serializable)((Object)"channel"));
        if (channel == null) {
            channel = "/" + this.getClientId();
        }
        return channel;
    }

    public void setChannel(String channel) {
        this.getStateHelper().put((Serializable)((Object)"channel"), (Object)channel);
    }

    public boolean isDirect() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)"direct"), (Object)Boolean.FALSE);
    }

    public void setDirect(boolean direct) {
        this.getStateHelper().put((Serializable)((Object)"direct"), (Object)direct);
    }

    public boolean isPushPhase() {
        String event = (String)this.getFacesContext().getExternalContext().getRequestParameterMap().get("javax.faces.behavior.event");
        return !"push".equals(event);
    }

    public boolean visitTree(VisitContext visitContext, VisitCallback callback) {
        if (callback instanceof RenderVisitCallback) {
            if (this.isDirect()) {
                return this.pushDirect(visitContext, callback);
            }
            if (this.isPushPhase()) {
                return this.pushAjax();
            }
        }
        return super.visitTree(visitContext, callback);
    }

    public boolean pushDirect(VisitContext visitContext, VisitCallback callback) {
        FacesContext context = this.getFacesContext();
        ExtPartialResponseWriter orig = Jsf.unwrap(context.getResponseWriter(), ExtPartialResponseWriter.class);
        StringWriter stringWriter = new StringWriter();
        ExtPartialResponseWriter writer = orig.cloneWithWriter(stringWriter);
        try {
            context.setResponseWriter((ResponseWriter)writer);
            writer.startDocument();
            boolean bl = super.visitTree(visitContext, callback);
            return bl;
        }
        catch (IOException exception) {
            throw new FacesException("Error writing changes", (Throwable)exception);
        }
        finally {
            try {
                writer.endDocument();
            }
            catch (IOException exception) {
                throw new FacesException("Error writing changes", (Throwable)exception);
            }
            context.setResponseWriter((ResponseWriter)orig);
            PushContext.instance().push(this.getChannel(), stringWriter.toString());
        }
    }

    public boolean pushAjax() {
        FacesContext context = this.getFacesContext();
        String clientId = this.getClientId(context);
        String prefix = clientId + UINamingContainer.getSeparatorChar((FacesContext)context);
        StringBuilder renderIds = new StringBuilder();
        for (String renderId : context.getPartialViewContext().getRenderIds()) {
            if (!renderId.startsWith(prefix) && !renderId.equals(clientId)) continue;
            if (renderIds.length() > 0) {
                renderIds.append(" ");
            }
            renderIds.append(renderId);
        }
        PushContext.instance().push(this.getChannel(), renderIds.toString());
        return false;
    }

    public void encodeChildren(FacesContext context) throws IOException {
        this.startDiv(context);
        super.encodeChildren(context);
        this.encodeScript(context);
        this.endDiv(context);
    }

    public void encodeScript(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("script", (UIComponent)this);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        String channel = this.getChannel();
        String baseUrl = context.getExternalContext().getRequestContextPath() + "/faces" + "/javax.faces.resource";
        String clientId = this.getClientId(context);
        writer.write("ext.push.openChannel('" + baseUrl + "', '" + channel + "', '" + clientId + "', " + this.isDirect() + ");");
        writer.endElement("script");
    }

    public void startDiv(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = this.getClientId(context);
        writer.startElement("div", (UIComponent)this);
        writer.writeAttribute("id", (Object)clientId, "clientId");
    }

    public void endDiv(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("div");
    }
}

