/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.component.captcha;

import com.intersult.jsf.util.Locales;
import com.octo.captcha.component.image.backgroundgenerator.BackgroundGenerator;
import com.octo.captcha.component.image.backgroundgenerator.FunkyBackgroundGenerator;
import com.octo.captcha.component.image.color.ColorGenerator;
import com.octo.captcha.component.image.color.RandomRangeColorGenerator;
import com.octo.captcha.component.image.fontgenerator.DeformedRandomFontGenerator;
import com.octo.captcha.component.image.fontgenerator.FontGenerator;
import com.octo.captcha.component.image.textpaster.NonLinearTextPaster;
import com.octo.captcha.component.image.textpaster.TextPaster;
import com.octo.captcha.component.image.wordtoimage.ComposedWordToImage;
import com.octo.captcha.component.image.wordtoimage.WordToImage;
import com.octo.captcha.component.word.wordgenerator.RandomWordGenerator;
import com.octo.captcha.component.word.wordgenerator.WordGenerator;
import com.octo.captcha.engine.image.ListImageCaptchaEngine;
import com.octo.captcha.image.ImageCaptcha;
import com.octo.captcha.image.ImageCaptchaFactory;
import com.octo.captcha.image.gimpy.GimpyFactory;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.imageio.ImageIO;

public class Captcha
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String CAPTCHA_ATTRIBUTE = Captcha.class.getName();
    private static transient CaptchaEngine engine;
    private ImageCaptcha captcha;

    public static CaptchaEngine getEngine() {
        if (engine == null) {
            engine = new CaptchaEngine();
        }
        return engine;
    }

    public static ImageCaptcha getCaptcha() {
        Map sessionMap = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
        ImageCaptcha captcha = (ImageCaptcha)sessionMap.get(CAPTCHA_ATTRIBUTE);
        if (captcha == null) {
            captcha = Captcha.getEngine().getNextImageCaptcha(Locales.instance().getLocale());
            sessionMap.put(CAPTCHA_ATTRIBUTE, captcha);
        }
        return captcha;
    }

    public static void writeCaptcha(FacesContext context, String filename) throws IOException {
        ExternalContext externalContext = context.getExternalContext();
        BufferedImage image = Captcha.getCaptcha().getImageChallenge();
        externalContext.addResponseHeader("Content-Disposition", "inline; filename=\"" + filename + "\"");
        externalContext.setResponseContentType("image/png");
        ImageIO.write((RenderedImage)image, "png", externalContext.getResponseOutputStream());
        context.responseComplete();
    }

    public static boolean validate(FacesContext context, String input) {
        boolean valid;
        try {
            valid = Captcha.getCaptcha().validateResponse((Object)input);
        }
        catch (Exception exception) {
            valid = false;
        }
        Captcha.reset();
        return valid;
    }

    public static void reset() {
        Map sessionMap = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
        sessionMap.remove(CAPTCHA_ATTRIBUTE);
    }

    public static final class CaptchaEngine
    extends ListImageCaptchaEngine {
        protected void buildInitialFactories() {
            RandomWordGenerator wordGenerator = new RandomWordGenerator("abcdefhjkmnpqrstuvwxyz2345678");
            NonLinearTextPaster textPaster = new NonLinearTextPaster(Integer.valueOf(5), Integer.valueOf(6), Color.WHITE);
            RandomRangeColorGenerator colorGenerator = new RandomRangeColorGenerator(new int[]{0, 255}, new int[]{0, 255}, new int[]{0, 255}, new int[]{0, 255});
            FunkyBackgroundGenerator backgroundGenerator = new FunkyBackgroundGenerator(Integer.valueOf(300), Integer.valueOf(75), (ColorGenerator)colorGenerator);
            DeformedRandomFontGenerator fontGenerator = new DeformedRandomFontGenerator(Integer.valueOf(50), Integer.valueOf(60));
            ComposedWordToImage wordToImage = new ComposedWordToImage((FontGenerator)fontGenerator, (BackgroundGenerator)backgroundGenerator, (TextPaster)textPaster);
            this.addFactory((ImageCaptchaFactory)new GimpyFactory((WordGenerator)wordGenerator, (WordToImage)wordToImage));
        }
    }
}

