/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.component.behavior;

import com.intersult.jsf.component.behavior.ExtBehaviorBase;
import com.intersult.jsf.el.ExpressionAnalyzer;
import com.intersult.jsf.el.ValueReference;
import com.intersult.jsf.util.java.AnnotationUtils;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.application.ResourceDependency;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.component.behavior.FacesBehavior;
import javax.faces.context.FacesContext;
import javax.faces.validator.LengthValidator;
import javax.faces.validator.Validator;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.Length;

@FacesBehavior(value="intersult.CharactersLeftBehavior")
@ResourceDependency(name="util.js", library="ext-js")
public class CharactersLeftBehavior
extends ExtBehaviorBase {
    public String getScript(ClientBehaviorContext behaviorContext) {
        UIComponent component;
        FacesContext context = behaviorContext.getFacesContext();
        Integer max = this.getMax(context, component = behaviorContext.getComponent());
        if (max == null) {
            return null;
        }
        return "ext.util.checkCharactersLeft(this, " + max + ");";
    }

    public Integer getMax(FacesContext context, UIComponent component) {
        ValueExpression valueExpression;
        if (component instanceof EditableValueHolder && ((EditableValueHolder)component).getValidators() != null) {
            for (Validator validator : ((EditableValueHolder)component).getValidators()) {
                if (!(validator instanceof LengthValidator)) continue;
                return ((LengthValidator)validator).getMaximum();
            }
        }
        if ((valueExpression = component.getValueExpression("value")) == null) {
            return null;
        }
        ValueReference valueReference = ExpressionAnalyzer.getReference(valueExpression, context.getELContext());
        if (valueReference == null) {
            return null;
        }
        List<Annotation> annotations = AnnotationUtils.getAnnotations(valueReference.getBaseClass(), valueReference.getProperty().toString());
        try {
            return LengthAnnotationChecker.check(annotations);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static class LengthAnnotationChecker {
        public static Integer check(List<Annotation> annotations) {
            for (Annotation annotation : annotations) {
                if (annotation instanceof Size && ((Size)annotation).max() < Integer.MAX_VALUE) {
                    return ((Size)annotation).max();
                }
                if (!(annotation instanceof Length) || ((Length)annotation).max() >= Integer.MAX_VALUE) continue;
                return ((Length)annotation).max();
            }
            return null;
        }
    }
}

