/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.component.ajax;

import com.intersult.jsf.Jsf;
import com.intersult.jsf.api.Bindable;
import com.intersult.jsf.component.ajax.AjaxCommandBehavior;
import com.intersult.jsf.component.ajax.AjaxCommandComponent;
import com.sun.faces.facelets.tag.jsf.CompositeComponentTagHandler;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.el.MethodExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.view.AttachedObjectTarget;
import javax.faces.view.BehaviorHolderAttachedObjectHandler;
import javax.faces.view.BehaviorHolderAttachedObjectTarget;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.MetadataTarget;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagException;

public class AjaxCommandHandler
extends ComponentHandler {
    public AjaxCommandHandler(ComponentConfig config) {
        super(config);
    }

    public void apply(FaceletContext context, UIComponent parent) throws IOException {
        super.apply(context, parent);
    }

    public void onComponentCreated(FaceletContext context, UIComponent component, UIComponent parent) {
        UIComponent holder = null;
        TagAttribute forAttribute = this.getAttribute("for");
        if (forAttribute != null) {
            holder = (UIComponent)forAttribute.getObject(context, UIComponent.class);
        }
        if (holder == null) {
            holder = parent;
        }
        Application application = context.getFacesContext().getApplication();
        AjaxCommandBehavior behavior = (AjaxCommandBehavior)application.createBehavior("intersult.AjaxCommandBehavior");
        Jsf.bind(context, this.tag, behavior);
        behavior.setComponent((AjaxCommandComponent)component);
        if (holder instanceof ClientBehaviorHolder) {
            this.applyBehavior(context.getFacesContext(), holder, behavior);
        } else if (UIComponent.isCompositeComponent((UIComponent)holder)) {
            BeanInfo componentBeanInfo = (BeanInfo)holder.getAttributes().get("javax.faces.component.BEANINFO_KEY");
            BeanDescriptor componentDescriptor = componentBeanInfo.getBeanDescriptor();
            List targetList = (List)componentDescriptor.getValue("javax.faces.view.AttachedObjectTargets");
            if (targetList != null) {
                String eventName = this.getEventName(context);
                boolean applied = false;
                for (AttachedObjectTarget target : targetList) {
                    if (!(target instanceof BehaviorHolderAttachedObjectTarget)) continue;
                    BehaviorHolderAttachedObjectTarget behaviorTarget = (BehaviorHolderAttachedObjectTarget)target;
                    if ((eventName == null || !eventName.equals(behaviorTarget.getName())) && (null != eventName || !behaviorTarget.isDefaultEvent())) continue;
                    CompositeComponentTagHandler.getAttachedObjectHandlers((UIComponent)holder).add(new AjaxCommandRetargetHandler(behavior, this.getFor(context), this.getEventName(context)));
                    applied = true;
                }
                if (!applied) {
                    throw new TagException(this.tag, "Error attaching ClientBehavior to composite component with id '" + holder.getClientId(context.getFacesContext()) + "', it does not support event '" + eventName + "'");
                }
            }
        } else {
            throw new TagException(this.tag, "Error attaching ClientBehavior to component with id '" + holder.getClientId(context.getFacesContext()) + "', it is not a ClientBehaviorHolder");
        }
    }

    public void applyBehavior(FacesContext context, UIComponent holder, AjaxCommandBehavior behavior) {
        String event = (String)behavior.eval(context.getELContext(), (Serializable)((Object)"event"), null);
        if (event == null || "".equals(event)) {
            event = ((ClientBehaviorHolder)holder).getDefaultEventName();
        }
        if (event == null) {
            throw new TagException(this.tag, "Parent component '" + holder.getClientId(context) + "' does not specify default event, set attribute manually.");
        }
        behavior.setEvent(event);
        if (!((ClientBehaviorHolder)holder).getEventNames().contains(event)) {
            throw new TagException(this.tag, "'" + holder.getClass().getSimpleName() + "' with id '" + holder.getClientId() + "' is ClientBehaviorHolder but does not support behavior '" + event + "'");
        }
        ((ClientBehaviorHolder)holder).addClientBehavior(event, (ClientBehavior)behavior);
    }

    protected MetaRuleset createMetaRuleset(Class type) {
        return super.createMetaRuleset(type).addRule(new MetaRule(){

            public Metadata applyRule(String name, final TagAttribute attribute, MetadataTarget meta) {
                if (meta.isTargetInstanceOf(AjaxCommandComponent.class) && "action".equals(name)) {
                    return new Metadata(){

                        public void applyMetadata(FaceletContext context, Object instance) {
                            MethodExpression action = attribute.getMethodExpression(context, String.class, new Class[0]);
                            ((AjaxCommandComponent)((Object)instance)).setActionExpression(action);
                        }
                    };
                }
                return null;
            }
        });
    }

    public String getFor(FaceletContext ctx) {
        TagAttribute attribute = this.getAttribute("for");
        if (attribute == null) {
            return null;
        }
        if (ctx == null) {
            return attribute.getValue();
        }
        return attribute.getValue(ctx);
    }

    public String getEventName(FaceletContext ctx) {
        TagAttribute attribute = this.getAttribute("event");
        if (attribute == null) {
            return null;
        }
        if (ctx == null) {
            return attribute.getValue();
        }
        return attribute.getValue(ctx);
    }

    public class AjaxCommandRetargetHandler
    implements BehaviorHolderAttachedObjectHandler {
        private AjaxCommandBehavior behavior;
        private String _for;
        private String eventName;

        public AjaxCommandRetargetHandler(AjaxCommandBehavior behavior, String _for, String eventName) {
            this.behavior = behavior;
            this._for = _for;
            this.eventName = eventName;
        }

        public Bindable getBehavior() {
            return this.behavior;
        }

        public void applyAttachedObject(FacesContext context, UIComponent parent) {
            AjaxCommandHandler.this.applyBehavior(context, parent, this.behavior);
        }

        public String getFor() {
            return this._for;
        }

        public String getEventName() {
            return this.eventName;
        }
    }
}

