/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.component.ajax;

import com.intersult.jsf.Jsf;
import com.intersult.jsf.api.Bindable;
import com.intersult.jsf.component.ajax.AjaxCommandComponent;
import com.intersult.jsf.component.behavior.ExtBehaviorBase;
import com.intersult.jsf.extensions.ExtResponseWriter;
import com.intersult.jsf.util.Behaviors;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorBase;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.component.behavior.ClientBehaviorHint;
import javax.faces.component.behavior.FacesBehavior;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

@FacesBehavior(value="intersult.AjaxCommandBehavior")
public class AjaxCommandBehavior
extends ClientBehaviorBase
implements Bindable {
    private Map<Serializable, ValueExpression> binding = new HashMap<Serializable, ValueExpression>();
    private transient AjaxCommandComponent component;
    private String event;

    public Object saveState(FacesContext context) {
        Object[] states = new Object[]{super.saveState(context), this.binding, this.component, this.event};
        return states;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] states = (Object[])state;
        this.binding = (Map)states[1];
        if (this.component == null) {
            this.component = (AjaxCommandComponent)((Object)states[2]);
        }
        this.event = (String)states[3];
        super.restoreState(context, states[0]);
    }

    @Override
    public ValueExpression getValueExpression(Serializable name) {
        return this.binding.get(name);
    }

    @Override
    public void setValueExpression(Serializable name, ValueExpression expression) {
        this.binding.put(name, expression);
    }

    @Override
    public Object eval(Serializable name) {
        return this.eval(FacesContext.getCurrentInstance().getELContext(), name, null);
    }

    @Override
    public Object eval(ELContext elContext, Serializable name, Object fallback) {
        ValueExpression expression = this.binding.get(name);
        if (expression == null) {
            return fallback;
        }
        Object value = expression.getValue(elContext);
        if (value == null) {
            return fallback;
        }
        return value;
    }

    @Override
    public void put(Serializable name, Object value) {
        this.put(FacesContext.getCurrentInstance().getELContext(), name, value);
    }

    @Override
    public void put(ELContext elContext, Serializable name, Object value) {
        FacesContext context = (FacesContext)elContext.getContext(FacesContext.class);
        ValueExpression expression = context.getApplication().getExpressionFactory().createValueExpression(value, Object.class);
        this.binding.put(name, expression);
    }

    @Override
    public void remove(Serializable name) {
        this.binding.remove(name);
    }

    public AjaxCommandComponent getComponent() {
        return this.component;
    }

    public void setComponent(AjaxCommandComponent component) {
        this.component = component;
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public Boolean getDisableDefault() {
        return (Boolean)this.eval(FacesContext.getCurrentInstance().getELContext(), (Serializable)((Object)"disableDefault"), Boolean.TRUE);
    }

    public void setDisableDefault(Boolean disableDefault) {
        this.put((Serializable)((Object)"disableDefault"), disableDefault);
    }

    public Boolean getRendered() {
        return (Boolean)this.eval(FacesContext.getCurrentInstance().getELContext(), (Serializable)((Object)"rendered"), Boolean.TRUE);
    }

    public void setRendered(Boolean rendered) {
        this.put((Serializable)((Object)"rendered"), rendered);
    }

    public Set<ClientBehaviorHint> getHints() {
        if (this.getDisableDefault().booleanValue()) {
            return ExtBehaviorBase.SUBMITTING_HINTS;
        }
        return super.getHints();
    }

    public String getScript(ClientBehaviorContext behaviorContext) {
        ELContext elContext = behaviorContext.getFacesContext().getELContext();
        if (!this.getRendered().booleanValue()) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        String source = (String)this.eval(elContext, (Serializable)((Object)"source"), null);
        source = source == null || "".equals(source) ? this.component.getClientId(behaviorContext.getFacesContext()) : Jsf.resolveId(behaviorContext.getComponent(), source);
        buffer.append("jsf.ajax.request('" + source + "', event");
        buffer.append(", {");
        buffer.append("'javax.faces.behavior.event': '" + this.event + "'");
        buffer.append(", execute: ");
        String execute = (String)this.eval(elContext, (Serializable)((Object)"execute"), null);
        execute = execute == null || "".equals(execute) ? "'" + behaviorContext.getComponent().getClientId(behaviorContext.getFacesContext()) + "'" : Jsf.resolveIdString(behaviorContext.getComponent(), execute);
        buffer.append(execute);
        String render = (String)this.eval(elContext, (Serializable)((Object)"render"), null);
        if (render != null && !"".equals(render)) {
            buffer.append(", render: ");
            buffer.append(Jsf.resolveIdString(behaviorContext.getComponent(), render));
        }
        String onbegin = Behaviors.getValueWithBehaviors((UIComponent)this.component, AjaxCommandComponent.BEGIN_ATTRIBUTE);
        String oncomplete = Behaviors.getValueWithBehaviors((UIComponent)this.component, AjaxCommandComponent.COMPLETE_ATTRIBUTE);
        String onsuccess = Behaviors.getValueWithBehaviors((UIComponent)this.component, AjaxCommandComponent.SUCCESS_ATTRIBUTE);
        String onerror = Behaviors.getValueWithBehaviors((UIComponent)this.component, AjaxCommandComponent.ERROR_ATTRIBUTE);
        if (onbegin != null && !"".equals(onbegin) || oncomplete != null && !"".equals(oncomplete) || onsuccess != null && !"".equals(onsuccess) || onerror != null && !"".equals(onerror)) {
            buffer.append(", onevent: function(data) {");
            if (onbegin != null && !"".equals(onbegin)) {
                buffer.append("if (data.status === 'begin') {" + onbegin + "} ");
            }
            if (oncomplete != null && !"".equals(oncomplete)) {
                buffer.append("if (data.status === 'complete') {" + oncomplete + "} ");
            }
            if (onsuccess != null && !"".equals(onsuccess)) {
                buffer.append("if (data.status === 'success') {" + onsuccess + "} ");
            }
            if (onerror != null && !"".equals(onerror)) {
                buffer.append("if (data.status === 'error') {" + onerror + "} ");
            }
            buffer.append("}");
        }
        for (Map.Entry<String, Object> param : Jsf.getParameterMap((UIComponent)this.component).entrySet()) {
            buffer.append(", \"");
            buffer.append(param.getKey());
            buffer.append("\": \"");
            buffer.append(param.getValue());
            buffer.append("\"");
        }
        buffer.append("}");
        buffer.append(");");
        try {
            this.writeDiv(behaviorContext.getFacesContext(), (ResponseWriter)ExtResponseWriter.getEndElementWriter());
        }
        catch (IOException exception) {
            throw new FacesException("Error writing AJAX-DIV", (Throwable)exception);
        }
        return buffer.toString();
    }

    public void writeDiv(FacesContext context, ResponseWriter writer) throws IOException {
        writer.startElement("div", (UIComponent)this.component);
        writer.writeAttribute("id", (Object)this.component.getClientId(context), null);
        if (this.binding.containsKey("status")) {
            writer.writeAttribute("status", this.binding.get("status").getValue(context.getELContext()), "status");
        }
        writer.writeAttribute("style", (Object)"display: none;", null);
        writer.endElement("div");
    }
}

