/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.api;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import javax.faces.context.FacesContext;

public abstract class ExtResourceHandler
extends ResourceHandlerWrapper {
    public static final String LIBRARY_PARAM = "ln";
    private ResourceHandler wrapped;
    private String libraryName;

    public ExtResourceHandler(ResourceHandler wrapped, String libraryName) {
        this.wrapped = wrapped;
        this.libraryName = libraryName;
    }

    public ResourceHandler getWrapped() {
        return this.wrapped;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public Resource createResource(String resourceName, String libraryName) {
        if (this.libraryName.equals(libraryName)) {
            return new ExtResource(resourceName, libraryName);
        }
        return this.wrapped.createResource(resourceName, libraryName);
    }

    public boolean libraryExists(String libraryName) {
        if (this.libraryName.equals(libraryName)) {
            return true;
        }
        return this.wrapped.libraryExists(libraryName);
    }

    public void handleResourceRequest(FacesContext context) throws IOException {
        String libraryName = (String)context.getExternalContext().getRequestParameterMap().get(LIBRARY_PARAM);
        if (this.libraryName.equals(libraryName)) {
            String resourceName = context.getExternalContext().getRequestPathInfo().substring("/javax.faces.resource".length() + 1);
            this.handleResourceRequest(context, resourceName);
            return;
        }
        this.wrapped.handleResourceRequest(context);
    }

    public abstract void handleResourceRequest(FacesContext var1, String var2) throws IOException;

    public static class ExtResource
    extends Resource {
        private String resourceName;

        public ExtResource(String resourceName, String libraryName) {
            this.resourceName = resourceName;
            this.setLibraryName(libraryName);
        }

        public InputStream getInputStream() throws IOException {
            return null;
        }

        public Map<String, String> getResponseHeaders() {
            return new HashMap<String, String>();
        }

        public String getRequestPath() {
            FacesContext context = FacesContext.getCurrentInstance();
            return context.getApplication().getViewHandler().getResourceURL(context, "/faces/javax.faces.resource/" + this.resourceName + "?ln=" + this.getLibraryName());
        }

        public URL getURL() {
            try {
                return new URL(this.getRequestPath());
            }
            catch (MalformedURLException exception) {
                throw new IllegalArgumentException("Error creating resourceName URL", exception);
            }
        }

        public boolean userAgentNeedsUpdate(FacesContext context) {
            return true;
        }
    }
}

