/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf;

import com.intersult.jsf.Jsf;
import com.intersult.jsf.component.scope.ScopeComponent;
import com.intersult.jsf.component.scope.ScopesComponent;
import com.intersult.jsf.event.Event;
import com.intersult.jsf.util.collection.JoinCollection;
import com.intersult.jsf.util.collection.JoinSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.NoneScoped;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.view.facelets.FaceletException;
import org.apache.log4j.Logger;

@ManagedBean
@NoneScoped
public class Scopes
implements Serializable {
    private static final long serialVersionUID = 1L;
    static Logger log = Logger.getLogger(Scopes.class);
    public static final String CUSTOM_SCOPE = "scope";
    public static final String VIEW_SCOPE = "view";
    public static final String SCOPE_NAME = "scope";
    private static int count;

    public Map<String, Scope> getMap(Lifecycle lifecycle) {
        switch (lifecycle) {
            case request: {
                return this.getRequestMap();
            }
            case view: {
                return this.getViewMap();
            }
            case page: {
                return this.getPageMap();
            }
            case session: {
                return this.getSessionMap();
            }
            case application: {
                return this.getApplicationMap();
            }
        }
        throw new IllegalArgumentException("Unknown lifecycle type '" + (Object)((Object)lifecycle) + "'");
    }

    private Map<String, Scope> getRequestMap() {
        return this.getMap(FacesContext.getCurrentInstance().getExternalContext().getRequestMap(), "javax.faces.ScopeMap");
    }

    public Map<String, Scope> getViewMap() {
        return this.getMap(FacesContext.getCurrentInstance().getViewRoot().getViewMap(), "javax.faces.ScopeMap");
    }

    public Map<String, Scope> getPageMap() {
        FacesContext context = FacesContext.getCurrentInstance();
        Map<String, Object> pageMap = this.getMap(context.getExternalContext().getSessionMap(), "javax.faces.PageMap");
        return this.getMap(pageMap, context.getViewRoot().getViewId());
    }

    public Map<String, Scope> getSessionMap() {
        return this.getMap(FacesContext.getCurrentInstance().getExternalContext().getSessionMap(), "javax.faces.ScopeMap");
    }

    public Map<String, Scope> getApplicationMap() {
        return this.getMap(FacesContext.getCurrentInstance().getExternalContext().getApplicationMap(), "javax.faces.ScopeMap");
    }

    private <T> Map<String, T> getMap(Map<String, Object> metaMap, String metaKey) {
        LinkedHashMap scopeMap = (LinkedHashMap)metaMap.get(metaKey);
        if (scopeMap == null) {
            scopeMap = new LinkedHashMap();
            metaMap.put(metaKey, scopeMap);
        }
        return scopeMap;
    }

    public static Scopes instance() {
        return Jsf.getBean(Scopes.class);
    }

    public static ScopeComponent findScopeComponent(String id) {
        UIViewRoot viewRoot = FacesContext.getCurrentInstance().getViewRoot();
        ScopeComponent scopeComponent = (ScopeComponent)viewRoot.findComponent(id);
        if (scopeComponent == null) {
            throw new FaceletException("Cannot find scope with id '" + id + "' in view '" + viewRoot.getViewId() + "'");
        }
        return scopeComponent;
    }

    public static Object push(String scopeId) {
        return FacesContext.getCurrentInstance().getAttributes().put("id", scopeId);
    }

    public static void pop(Object previous) {
        if (previous == null) {
            FacesContext.getCurrentInstance().getAttributes().remove("id");
        } else {
            FacesContext.getCurrentInstance().getAttributes().put("id", previous);
        }
    }

    public synchronized List<Scope> getList() {
        ArrayList<Scope> list = new ArrayList<Scope>();
        list.addAll(this.getRequestMap().values());
        list.addAll(this.getViewMap().values());
        list.addAll(this.getPageMap().values());
        list.addAll(this.getSessionMap().values());
        list.addAll(this.getApplicationMap().values());
        return list;
    }

    public synchronized Collection<Scope> getScopes() {
        return new JoinCollection<Scope>(this.getRequestMap().values(), this.getViewMap().values(), this.getPageMap().values(), this.getSessionMap().values(), this.getApplicationMap().values());
    }

    public synchronized Set<Map.Entry<String, Scope>> entrySet() {
        return new JoinSet<Map.Entry<String, Scope>>(this.getRequestMap().entrySet(), this.getViewMap().entrySet(), this.getPageMap().entrySet(), this.getSessionMap().entrySet(), this.getApplicationMap().entrySet());
    }

    public synchronized void remove(String scopeId) {
        for (Lifecycle lifecycle : Lifecycle.values()) {
            Map<String, Scope> map = this.getMap(lifecycle);
            Scope scope = map.get(scopeId);
            if (scope == null) continue;
            scope.callDestructionCallback();
            map.remove(scopeId);
            break;
        }
    }

    public Scope getScope() {
        ELContext el = FacesContext.getCurrentInstance().getELContext();
        ValueExpression expression = el.getVariableMapper().resolveVariable("scope");
        if (expression != null) {
            return (Scope)expression.getValue(el);
        }
        String id = this.getId();
        if (id == null) {
            return null;
        }
        Scope scope = this.get(id);
        return scope;
    }

    public String getId() {
        ValueExpression expression;
        FacesContext context = FacesContext.getCurrentInstance();
        String id = (String)context.getAttributes().get("id");
        if (id == null) {
            id = (String)context.getExternalContext().getRequestParameterMap().get("id");
        }
        if (Jsf.isUseFlash() && id == null) {
            id = (String)context.getExternalContext().getFlash().get((Object)"id");
        }
        if (id == null && (expression = context.getELContext().getVariableMapper().resolveVariable("scope")) != null) {
            id = (String)((Scope)expression.getValue(context.getELContext())).get("id");
        }
        return id;
    }

    public String getOpenId() {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        String id = (String)externalContext.getRequestParameterMap().get("scopeId");
        if (id == null) {
            id = (String)externalContext.getRequestParameterMap().get("id");
        }
        return id;
    }

    public Scope get(String id) {
        Scope scope = this.getRequestMap().get(id);
        if (scope != null) {
            return scope;
        }
        scope = this.getViewMap().get(id);
        if (scope != null) {
            return scope;
        }
        scope = this.getPageMap().get(id);
        if (scope != null) {
            return scope;
        }
        scope = this.getSessionMap().get(id);
        if (scope != null) {
            return scope;
        }
        scope = this.getApplicationMap().get(id);
        return scope;
    }

    public void put(String id, Scope scope, Lifecycle lifecycle) {
        this.getMap(lifecycle).put(id, scope);
    }

    public Scope load(String id, Lifecycle lifecycle) {
        return this.load(Scopes.findScopeComponent(id), true, lifecycle);
    }

    public Scope load(ScopeComponent scopeComponent, boolean cascade, Lifecycle lifecycle) {
        String scopeId = scopeComponent.getClientId();
        String viewId = scopeComponent.getViewId();
        String library = scopeComponent.getLibrary();
        if (lifecycle == null) {
            lifecycle = scopeComponent.getLifecycle();
        }
        scopeComponent.processLoad();
        FacesContext.getCurrentInstance().getViewRoot().queueEvent((FacesEvent)new ActionEvent((UIComponent)scopeComponent));
        Jsf.renderClientId(scopeId);
        Scope scope = this.load(scopeId, viewId, library, cascade, lifecycle);
        scope.put("scope.bind", Boolean.TRUE);
        return scope;
    }

    public synchronized Scope load(String scopeId, String viewId, String library, boolean cascade, Lifecycle lifecycle) {
        Scope scope;
        if (lifecycle == null) {
            lifecycle = Lifecycle.page;
        }
        if ((scope = this.get(scopeId)) == null) {
            scope = new Scope();
            scope.put("scope.load", Boolean.TRUE);
            if (scopeId == null) {
                scopeId = this.generateScopeName(viewId);
            }
            this.put(scopeId, scope, lifecycle);
        } else {
            Lifecycle scopeTarget = (Lifecycle)((Object)scope.get("scope.target"));
            if (scopeTarget != null && scopeTarget != lifecycle) {
                throw new IllegalArgumentException("Cannot reload scope with id '" + scopeId + "' and viewId '" + viewId + "' into different target '" + (Object)((Object)lifecycle) + "', was '" + (Object)((Object)scopeTarget) + "'");
            }
            this.cascade(scope, false);
            scope.callDestructionCallback();
            scope.clear();
            scope.put("scope.load", Boolean.FALSE);
        }
        scope.put("id", scopeId);
        scope.put("scope.viewId", viewId);
        if (library != null) {
            scope.put("scope.library", library);
        }
        scope.put("scope.viewRootId", FacesContext.getCurrentInstance().getViewRoot().getViewId());
        Scope parent = this.getScope();
        scope.put("scope.parent", parent);
        if (cascade && parent != null) {
            parent.addCascade(scope);
        }
        Event.instance().raise("scope.load." + scopeId, scope);
        Event.instance().raise("scope.load", scope);
        return scope;
    }

    public String generateScopeName(String viewId) {
        int index = viewId.lastIndexOf(46);
        if (index > 0) {
            viewId = viewId.substring(0, index);
        }
        if (viewId.charAt(0) == '/') {
            viewId = viewId.substring(1);
        }
        viewId = viewId.replace('/', '-');
        for (Lifecycle lifecycle : Lifecycle.values()) {
            if (!this.getMap(lifecycle).containsKey(viewId)) continue;
            viewId = viewId + "-" + count++;
            break;
        }
        return viewId;
    }

    public void unload(String id) {
        this.unload(id, false);
    }

    public void unload(String id, boolean immediate) {
        Scope scope = this.get(id);
        if (scope != null) {
            this.unload(scope, immediate);
        }
    }

    public synchronized void unload(Scope scope, boolean immediate) {
        scope.put("scope.unload", (Object)immediate);
        this.cascade(scope, immediate);
    }

    private void cascade(Scope scope, boolean immediate) {
        for (Scope cascade : scope.getCascade()) {
            if (cascade.get("scope.unload") != null) continue;
            this.unload(cascade, immediate);
        }
    }

    public synchronized void cleanup() {
        FacesContext context = FacesContext.getCurrentInstance();
        boolean valid = Jsf.instance().isValid();
        Iterator<Map.Entry<String, Scope>> iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Scope> entry = iterator.next();
            Scope scope = entry.getValue();
            if (!scope.containsKey("scope.unload")) continue;
            if (valid || Boolean.TRUE.equals(scope.get("scope.unload"))) {
                ScopeComponent scopeComponent = (ScopeComponent)context.getViewRoot().findComponent(entry.getKey());
                if (scopeComponent != null) {
                    scopeComponent.processUnload();
                    Jsf.evaluate((String)scope.get("scope.onunload"));
                    this.removeCascade(entry.getValue());
                    this.invokeUnloadAction(scope);
                    this.raiseEvents(entry, scope);
                    scope.callDestructionCallback();
                    if (scopeComponent.getParent() instanceof ScopesComponent) {
                        Jsf.deleteClientId(entry.getKey());
                    } else {
                        Jsf.renderClientId(entry.getKey());
                    }
                }
                iterator.remove();
                continue;
            }
            scope.remove("scope.unload");
        }
    }

    public void raiseEvents(Map.Entry<String, Scope> entry, Scope scope) {
        Event.instance().raise("scope.unload." + entry.getKey(), scope);
        Event.instance().raise("scope.unload", scope);
    }

    public void removeCascade(Scope scope) {
        Scope parent = (Scope)scope.get("scope.parent");
        if (parent != null) {
            parent.removeCascade(scope);
        }
    }

    public void invokeUnloadAction(Scope scope) {
        MethodExpression unloadAction = (MethodExpression)scope.get("scope.unloadAction");
        if (unloadAction != null) {
            Object previous = scope.push();
            unloadAction.invoke(FacesContext.getCurrentInstance().getELContext(), null);
            scope.pop(previous);
        }
    }

    public static class Constants {
        public static final String ID_NAME = "id";
        public static final String LOAD_ID_NAME = "scopeId";
        public static final String PARENT_NAME = "scope.parent";
        public static final String VIEW_NAME = "scope.viewId";
        public static final String LIBRARY_NAME = "scope.library";
        public static final String VIEW_ROOT_NAME = "scope.viewRootId";
        public static final String LOAD_NAME = "scope.load";
        public static final String UNLOAD_NAME = "scope.unload";
        public static final String EVENT_LOAD = "scope.load";
        public static final String EVENT_UNLOAD = "scope.unload";
        public static final String ONUNLOAD = "scope.onunload";
        public static final String UNLOAD_ACTION_NAME = "scope.unloadAction";
        public static final String CASCADE_NAME = "scope.cascade";
        public static final String TARGET_NAME = "scope.target";
        public static final String BIND_NAME = "scope.bind";
        public static final String PAGE_MAP_NAME = "javax.faces.PageMap";
        public static final String SCOPE_MAP_NAME = "javax.faces.ScopeMap";
    }

    public static enum Lifecycle {
        request,
        view,
        page,
        session,
        application;

    }

    public class Scope
    extends HashMap<Object, Object> {
        private static final long serialVersionUID = 1L;
        private List<Runnable> destructionCallbackList = new ArrayList<Runnable>();

        @Override
        public Object get(Object key) {
            Object value = super.get(key);
            return value;
        }

        @Override
        public Object put(Object key, Object value) {
            Object old = super.put(key, value);
            return old;
        }

        @Override
        public Object remove(Object key) {
            return super.remove(key);
        }

        public void unload() {
            Scopes.this.unload(this, false);
        }

        public void render() {
            Jsf.renderClientId((String)this.get("id"));
        }

        public Object push() {
            return Scopes.push((String)this.get("id"));
        }

        public void pop(Object previous) {
            Scopes.pop(previous);
        }

        public void registerDestructionCallback(Runnable runnable) {
            this.destructionCallbackList.add(runnable);
        }

        public void callDestructionCallback() {
            for (Runnable destructionCallback : this.destructionCallbackList) {
                destructionCallback.run();
            }
        }

        public void addCascade(Scope scope) {
            this.getCascade().add(scope);
        }

        public void removeCascade(Scope scope) {
            this.getCascade().remove(scope);
        }

        public Set<Scope> getCascade() {
            HashSet cascade = (HashSet)this.get("scope.cascade");
            if (cascade == null) {
                cascade = new HashSet();
                this.put("scope.cascade", cascade);
            }
            return cascade;
        }

        @Override
        public int hashCode() {
            return this.get("id").hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || !(object instanceof Scope)) {
                return false;
            }
            return this.get("id").equals(((Scope)object).get("id"));
        }

        @Override
        public String toString() {
            return "scope(" + this.get("id") + ")";
        }
    }
}

