/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf;

import com.intersult.jsf.Jsf;
import com.intersult.jsf.extensions.ExtFacesContext;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.event.PhaseId;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class FacesFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger("javax.faces.webapp", "javax.faces.LogStrings");
    public static final String LIFECYCLE_ID_ATTR = "javax.faces.LIFECYCLE_ID";
    private ServletContext servletContext;
    private FacesContextFactory facesContextFactory;
    private Lifecycle lifecycle;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.servletContext = filterConfig.getServletContext();
        try {
            this.facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
        }
        catch (FacesException e) {
            ResourceBundle rb = LOGGER.getResourceBundle();
            String msg = rb.getString("severe.webapp.facesservlet.init_failed");
            Throwable rootCause = e.getCause() != null ? e.getCause() : e;
            LOGGER.log(Level.SEVERE, msg, rootCause);
            throw new UnavailableException(msg);
        }
        try {
            LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
            String lifecycleId = this.servletContext.getInitParameter(LIFECYCLE_ID_ATTR);
            if (null == lifecycleId) {
                lifecycleId = this.servletContext.getInitParameter(LIFECYCLE_ID_ATTR);
            }
            if (lifecycleId == null) {
                lifecycleId = "DEFAULT";
            }
            this.lifecycle = lifecycleFactory.getLifecycle(lifecycleId);
        }
        catch (FacesException e) {
            Throwable rootCause = e.getCause();
            if (rootCause == null) {
                throw e;
            }
            throw new ServletException(e.getMessage(), rootCause);
        }
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        String pathInfo = request.getPathInfo();
        if (pathInfo != null && ((pathInfo = pathInfo.toUpperCase()).contains("/WEB-INF/") || pathInfo.contains("/WEB-INF") || pathInfo.contains("/META-INF/") || pathInfo.contains("/META-INF"))) {
            response.sendError(404);
            return;
        }
        FacesContext context = this.facesContextFactory.getFacesContext((Object)this.servletContext, (Object)new HttpServletRequestWrapper(request), (Object)new HttpServletResponseWrapper(response), this.lifecycle);
        ExtFacesContext extContext = Jsf.unwrap(context, ExtFacesContext.class);
        extContext.setState(ExtFacesContext.State.FILTER_BEFORE);
        context.setCurrentPhaseId(PhaseId.RESTORE_VIEW);
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (FacesException e) {
            Throwable t = e.getCause();
            if (t == null) {
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new ServletException(t.getMessage(), t);
        }
        finally {
            context.release();
        }
    }

    public void destroy() {
        this.facesContextFactory = null;
        this.lifecycle = null;
        this.servletContext = null;
    }
}

