/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.composer.keyboard;

import android.app.Activity;
import android.view.View;
import android.view.Window;
import androidx.annotation.Px;
import com.intercom.composer.keyboard.KeyboardManager;
import com.intercom.composer.keyboard.OnKeyboardVisibilityListener;
import com.intercom.composer.keyboard.OrientationProvider;

public class KeyboardHelper
implements OnKeyboardVisibilityListener {
    private final KeyboardManager keyboardManager;
    private final Window window;
    private final View editText;
    private final View behindKeyboardView;
    private final OrientationProvider orientationProvider;

    public KeyboardHelper(Activity activity, OrientationProvider orientationProvider, View editText, View behindKeyboardView) {
        this(new KeyboardManager(activity, orientationProvider), orientationProvider, activity.getWindow(), editText, behindKeyboardView);
    }

    KeyboardHelper(KeyboardManager keyboardManager, OrientationProvider orientationProvider, Window window, View editText, View behindKeyboardView) {
        if (behindKeyboardView == null) {
            throw new IllegalArgumentException("behindKeyboardView can not be null!");
        }
        if (editText == null) {
            throw new IllegalArgumentException("editText can not be null!");
        }
        this.editText = editText;
        this.behindKeyboardView = behindKeyboardView;
        this.window = window;
        this.window.setSoftInputMode(19);
        this.orientationProvider = orientationProvider;
        this.keyboardManager = keyboardManager;
        this.keyboardManager.setOnKeyboardVisibilityListener(this);
    }

    @Override
    public void onKeyboardVisibilityChanged(boolean visible, @Px int height) {
        if (visible) {
            this.window.setSoftInputMode(16);
            if (this.isBehindKeyboardViewVisible()) {
                this.behindKeyboardView.getLayoutParams().height = 0;
                this.behindKeyboardView.requestLayout();
            }
        } else if (this.isBehindKeyboardViewVisible()) {
            this.window.setSoftInputMode(32);
        } else {
            this.window.setSoftInputMode(16);
        }
    }

    private boolean isBehindKeyboardViewVisible() {
        return this.behindKeyboardView.getLayoutParams().height != 0;
    }

    public void showBehindKeyboardView() {
        int orientation = this.orientationProvider.getOrientation();
        if (this.keyboardManager.isShowingKeyboard()) {
            this.behindKeyboardView.getLayoutParams().height = this.keyboardManager.getKeyboardHeight(orientation);
            this.behindKeyboardView.requestLayout();
            this.window.setSoftInputMode(32);
            if (this.keyboardManager.isShowingKeyboard()) {
                this.keyboardManager.hideSoftInput(this.editText);
            }
        } else if (!this.isBehindKeyboardViewVisible()) {
            this.behindKeyboardView.getLayoutParams().height = this.keyboardManager.getKeyboardHeight(orientation);
            this.behindKeyboardView.requestLayout();
            this.window.setSoftInputMode(32);
        }
    }

    public boolean hideBehindKeyboardView() {
        if (this.isBehindKeyboardViewVisible()) {
            this.behindKeyboardView.getLayoutParams().height = 0;
            this.behindKeyboardView.requestLayout();
            this.window.setSoftInputMode(16);
            return true;
        }
        return false;
    }

    public void onDestroy() {
        this.keyboardManager.removeGlobalLayoutListener();
    }
}

