/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.composer.input.text;

import android.widget.EditText;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.intercom.composer.input.IconProvider;
import com.intercom.composer.input.Input;
import com.intercom.composer.input.InputFragment;
import com.intercom.composer.input.text.SendTextCallback;
import com.intercom.composer.input.text.options.TextInputOption;
import java.util.List;

public abstract class TextInput<T extends InputFragment>
extends Input<T> {
    @Nullable
    private final List<TextInputOption> options;
    private EditText editText;
    private SendTextCallback sendTextCallback;

    public TextInput(String uniqueIdentifier, IconProvider iconProvider, SendTextCallback sendTextCallback) {
        this(uniqueIdentifier, iconProvider, sendTextCallback, null);
    }

    public TextInput(String uniqueIdentifier, IconProvider iconProvider, SendTextCallback sendTextCallback, @Nullable List<TextInputOption> options) {
        super(uniqueIdentifier, iconProvider);
        this.sendTextCallback = sendTextCallback;
        this.options = options;
    }

    @NonNull
    protected abstract EditText createEditText();

    @NonNull
    public EditText getEditText() {
        if (this.editText == null) {
            this.editText = this.createEditText();
        }
        return this.editText;
    }

    public void sendTextBack(CharSequence charSequence) {
        this.sendTextCallback.textToBeSent(this, charSequence);
    }

    @Nullable
    public List<TextInputOption> getOptions() {
        return this.options;
    }
}

