/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.composer.input.iconbar;

import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.FragmentManager;
import androidx.recyclerview.widget.RecyclerView;
import com.intercom.composer.R;
import com.intercom.composer.input.Input;
import com.intercom.composer.input.InputFragment;
import com.intercom.composer.input.empty.EmptyInput;
import com.intercom.composer.input.iconbar.EmptyIconViewHolder;
import com.intercom.composer.input.iconbar.InputClickedListener;
import com.intercom.composer.input.iconbar.InputIconViewHolder;
import com.intercom.composer.input.iconbar.InputSelectedListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class InputIconsRecyclerAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    @VisibleForTesting
    static final int VIEW_TYPE_INPUT = 1;
    @VisibleForTesting
    static final int VIEW_TYPE_EMPTY_SPACE = 2;
    private final InputSelectedListener onInputIconSelectedListener;
    private final LayoutInflater layoutInflater;
    private List<Input> inputs = new ArrayList<Input>();
    @Nullable
    private Input selectedInput;
    private final InputClickedListener inputClickedListener;
    private final FragmentManager fragmentManager;
    private final HashSet<String> hiddenInputIdentifiers = new HashSet();

    public InputIconsRecyclerAdapter(LayoutInflater layoutInflater, List<Input> inputs, InputSelectedListener onInputIconSelectedListener, InputClickedListener inputClickedListener, FragmentManager fragmentManager) {
        this.inputs = inputs;
        this.onInputIconSelectedListener = onInputIconSelectedListener;
        this.layoutInflater = layoutInflater;
        this.inputClickedListener = inputClickedListener;
        this.fragmentManager = fragmentManager;
    }

    public int getItemViewType(int position) {
        Input input = this.inputs.get(position);
        if (input instanceof EmptyInput || this.hiddenInputIdentifiers.contains(input.getUniqueIdentifier())) {
            return 2;
        }
        return 1;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 2) {
            return new EmptyIconViewHolder(this.layoutInflater.inflate(R.layout.intercom_composer_empty_view_layout, parent, false));
        }
        return new InputIconViewHolder(this.layoutInflater.inflate(R.layout.intercom_composer_input_icon_view_layout, parent, false), this.inputClickedListener);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int position) {
        Input input = this.inputs.get(position);
        if (viewHolder instanceof InputIconViewHolder) {
            InputIconViewHolder inputIconViewHolder = (InputIconViewHolder)viewHolder;
            boolean isSelected = this.selectedInput != null && input.getUniqueIdentifier().equals(this.selectedInput.getUniqueIdentifier());
            inputIconViewHolder.bind(input, isSelected);
        }
    }

    public int getItemCount() {
        return this.inputs.size();
    }

    @Nullable
    public Input getSelectedInput() {
        return this.selectedInput;
    }

    public boolean selectInput(Input input, boolean showKeyboard, boolean animateEditText) {
        if (this.inputs.indexOf(input) == -1) {
            return false;
        }
        this.fireInputSelectionCallbacks(input);
        if (input == this.selectedInput) {
            return false;
        }
        this.selectedInput = input;
        this.notifyDataSetChanged();
        this.onInputIconSelectedListener.onInputSelected(input, this.inputs.indexOf(input), showKeyboard, animateEditText);
        return true;
    }

    private void fireInputSelectionCallbacks(Input input) {
        if (input == this.selectedInput) {
            Object fragment = input.findFragment(this.fragmentManager);
            if (fragment != null) {
                ((InputFragment)((Object)fragment)).onInputReselected();
            }
        } else {
            Object fragment;
            if (this.selectedInput != null && (fragment = this.selectedInput.findFragment(this.fragmentManager)) != null) {
                ((InputFragment)((Object)fragment)).onInputDeselected();
            }
            if ((fragment = input.findFragment(this.fragmentManager)) != null) {
                ((InputFragment)((Object)fragment)).onInputSelected();
            }
        }
    }

    public void deselectAllInputs() {
        this.selectedInput = null;
        this.notifyDataSetChanged();
    }

    public void hideAllInputsExcept(List<String> visibleInputIdentifiers) {
        this.hiddenInputIdentifiers.clear();
        for (Input input : this.inputs) {
            String uniqueIdentifier = input.getUniqueIdentifier();
            if (visibleInputIdentifiers.contains(uniqueIdentifier)) continue;
            this.hiddenInputIdentifiers.add(uniqueIdentifier);
        }
        this.notifyDataSetChanged();
    }

    public void showAllInputs() {
        this.hiddenInputIdentifiers.clear();
        this.notifyDataSetChanged();
    }
}

