/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.composer.input.iconbar;

import android.view.View;
import android.widget.ImageView;
import androidx.annotation.VisibleForTesting;
import androidx.recyclerview.widget.RecyclerView;
import com.intercom.composer.R;
import com.intercom.composer.input.Input;
import com.intercom.composer.input.iconbar.InputClickedListener;

class InputIconViewHolder
extends RecyclerView.ViewHolder
implements View.OnClickListener {
    @VisibleForTesting
    final ImageView imageView;
    @VisibleForTesting
    final InputClickedListener listener;

    InputIconViewHolder(View itemView, InputClickedListener listener) {
        super(itemView);
        this.listener = listener;
        this.imageView = (ImageView)itemView.findViewById(R.id.input_icon_image_view);
        this.imageView.setOnClickListener((View.OnClickListener)this);
        itemView.setOnClickListener((View.OnClickListener)this);
    }

    public void onClick(View view) {
        this.listener.onInputClicked(this);
    }

    void bind(Input input, boolean isSelected) {
        this.imageView.setImageDrawable(input.getIconDrawable(this.imageView.getContext()));
        this.imageView.setSelected(isSelected);
        this.imageView.setContentDescription((CharSequence)input.getUniqueIdentifier());
    }
}

