/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.composer.animation;

import android.animation.Animator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.intercom.composer.ComposerAnimationStateListener;
import com.intercom.composer.animation.AnimationStatus;
import com.intercom.composer.animation.SendButtonAnimatorListener;
import com.intercom.composer.input.Input;
import com.intercom.composer.input.empty.EmptyInput;
import com.intercom.composer.pager.ComposerPagerAdapter;
import java.util.List;

public class ShowSendButtonAnimatorListener
extends SendButtonAnimatorListener {
    private final LinearLayoutManager layoutManager;

    public ShowSendButtonAnimatorListener(List<Input> inputs, ComposerPagerAdapter composerPagerAdapter, RecyclerView.Adapter recyclerAdapter, LinearLayoutManager layoutManager, ComposerAnimationStateListener animationStateListener) {
        super(inputs, composerPagerAdapter, recyclerAdapter, animationStateListener);
        this.layoutManager = layoutManager;
    }

    public void onAnimationEnd(Animator animation) {
        super.onAnimationEnd(animation);
        if (!this.animationCanceled && !this.emptyInputAdded()) {
            this.animationStateListener.onAnimationStateChanged(AnimationStatus.SHOWN);
            this.inputs.add(new EmptyInput());
            this.composerPagerAdapter.notifyDataSetChanged();
            int emptySpacePosition = this.inputs.size() - 1;
            this.recyclerAdapter.notifyItemInserted(emptySpacePosition);
            if (this.layoutManager.findLastVisibleItemPosition() == emptySpacePosition - 1) {
                this.layoutManager.scrollToPosition(emptySpacePosition);
            }
        }
    }

    public void onAnimationStart(Animator animation) {
        super.onAnimationStart(animation);
        this.animationStateListener.onAnimationStateChanged(AnimationStatus.SHOWING);
        this.animationStateListener.setSendButtonVisibility(0);
    }
}

