/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.composer.animation;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.view.View;
import android.widget.LinearLayout;
import androidx.annotation.VisibleForTesting;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import com.intercom.composer.animation.AnimationStatus;
import com.intercom.composer.animation.EditTextLayoutAnimatorInternalListener;

public class EditTextLayoutAnimator {
    private static final long EDIT_TEXT_ANIMATION_MS = 350L;
    private final View editText;
    private EditTextLayoutAnimatorInternalListener editTextLayoutAnimatorListener;
    private ObjectAnimator animator;
    @VisibleForTesting
    AnimationStatus animationStatus = AnimationStatus.SHOWN;
    @VisibleForTesting
    final Animator.AnimatorListener showEditTextAnimationListener = new AnimatorListenerAdapter(){

        public void onAnimationEnd(Animator animation) {
            super.onAnimationEnd(animation);
            EditTextLayoutAnimator.this.animationStatus = AnimationStatus.SHOWN;
            if (EditTextLayoutAnimator.this.editTextLayoutAnimatorListener != null) {
                EditTextLayoutAnimator.this.editTextLayoutAnimatorListener.onEditTextLayoutAnimationEnd(AnimationStatus.SHOWN);
            }
        }

        public void onAnimationStart(Animator animation) {
            super.onAnimationStart(animation);
            EditTextLayoutAnimator.this.animationStatus = AnimationStatus.SHOWING;
        }
    };
    @VisibleForTesting
    final Animator.AnimatorListener hideEditTextAnimationListener = new AnimatorListenerAdapter(){

        public void onAnimationEnd(Animator animation) {
            super.onAnimationEnd(animation);
            EditTextLayoutAnimator.this.animationStatus = AnimationStatus.HIDDEN;
            if (EditTextLayoutAnimator.this.editTextLayoutAnimatorListener != null) {
                EditTextLayoutAnimator.this.editTextLayoutAnimatorListener.onEditTextLayoutAnimationEnd(AnimationStatus.HIDDEN);
            }
        }

        public void onAnimationStart(Animator animation) {
            super.onAnimationStart(animation);
            EditTextLayoutAnimator.this.animationStatus = AnimationStatus.HIDING;
        }
    };
    @VisibleForTesting
    final ValueAnimator.AnimatorUpdateListener animationUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            ((LinearLayout.LayoutParams)((EditTextLayoutAnimator)EditTextLayoutAnimator.this).editText.getLayoutParams()).bottomMargin = ((Float)animation.getAnimatedValue()).intValue();
            EditTextLayoutAnimator.this.editText.requestLayout();
        }
    };

    public EditTextLayoutAnimator(View editText) {
        this.editText = editText;
    }

    public void setEditTextLayoutAnimatorListener(EditTextLayoutAnimatorInternalListener animatorListener) {
        this.editTextLayoutAnimatorListener = animatorListener;
    }

    public void showEditText(boolean animated) {
        if (this.animationStatus == AnimationStatus.HIDING && this.animator != null) {
            this.animator.cancel();
        }
        if (this.animationStatus == AnimationStatus.HIDDEN) {
            this.animator = ObjectAnimator.ofFloat((Object)this.editText, (String)"layout_marginBottom", (float[])new float[]{-this.editText.getHeight(), 0.0f});
            this.animator.setDuration(animated ? 350L : 0L);
            this.animator.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
            this.animator.addUpdateListener(this.animationUpdateListener);
            this.animator.addListener(this.showEditTextAnimationListener);
            this.animator.start();
        }
    }

    public void hideEditText() {
        if (this.animationStatus == AnimationStatus.SHOWING && this.animator != null) {
            this.animator.cancel();
        }
        if (this.animationStatus == AnimationStatus.SHOWN) {
            this.animator = ObjectAnimator.ofFloat((Object)this.editText, (String)"layout_marginBottom", (float[])new float[]{0.0f, -this.editText.getHeight()});
            this.animator.setDuration(350L);
            this.animator.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
            this.animator.addUpdateListener(this.animationUpdateListener);
            this.animator.addListener(this.hideEditTextAnimationListener);
            this.animator.start();
        }
    }
}

