/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.input.gallery.adapter;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.intercom.input.gallery.adapter.EndlessScrollListener;

public class EndlessRecyclerScrollListener
extends RecyclerView.OnScrollListener {
    @NonNull
    private final LinearLayoutManager layoutManager;
    @NonNull
    private final EndlessScrollListener endlessScrollListener;
    private int maxCount = Integer.MIN_VALUE;

    public EndlessRecyclerScrollListener(@NonNull LinearLayoutManager layoutManager, @NonNull EndlessScrollListener endlessScrollListener) {
        this.layoutManager = layoutManager;
        this.endlessScrollListener = endlessScrollListener;
    }

    public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
        super.onScrolled(recyclerView, dx, dy);
        int visibleItemCount = recyclerView.getChildCount();
        int totalItemCount = this.layoutManager.getItemCount();
        int firstVisibleItemPosition = this.layoutManager.findFirstVisibleItemPosition();
        if (totalItemCount - visibleItemCount <= firstVisibleItemPosition && totalItemCount < this.maxCount) {
            this.endlessScrollListener.onLoadMore();
        }
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }
}

