/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.input.gallery;

import android.app.Activity;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Point;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.MediaStore;
import android.webkit.MimeTypeMap;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.FragmentActivity;
import com.intercom.input.gallery.GalleryImage;
import com.intercom.input.gallery.GalleryInputDataSource;
import com.intercom.input.gallery.GalleryInputFragment;
import com.intercom.input.gallery.GalleryInputScreen;
import com.intercom.input.gallery.PermissionHelper;
import com.intercom.input.gallery.UtilsKt;
import java.util.ArrayList;
import java.util.List;

public class LocalImagesDataSource
implements GalleryInputDataSource {
    private static final int READ_EXTERNAL_STORAGE_REQUEST = 1;
    private static final int ITEM_COUNT_LIMIT = 50;
    private GalleryInputDataSource.Listener listener;
    private PermissionHelper permissionHelper;
    private Context context;
    private GalleryInputScreen galleryInputScreen;
    private boolean loading;
    private final boolean shouldShowVideos;

    public static GalleryInputDataSource create(GalleryInputFragment fragment, boolean shouldShowVideos) {
        FragmentActivity activity = fragment.getActivity();
        PermissionHelper permissionHelper = PermissionHelper.create((Activity)activity);
        return new LocalImagesDataSource((Context)activity, permissionHelper, fragment, shouldShowVideos);
    }

    LocalImagesDataSource(Context context, PermissionHelper permissionHelper, GalleryInputScreen galleryInputScreen, boolean shouldShowVideos) {
        this.context = context;
        this.galleryInputScreen = galleryInputScreen;
        this.permissionHelper = permissionHelper;
        this.shouldShowVideos = shouldShowVideos;
    }

    @Override
    public int getPermissionStatus() {
        if (Build.VERSION.SDK_INT >= 33) {
            return this.permissionHelper.getPermissionStatus("android.permission.READ_MEDIA_IMAGES");
        }
        if (Build.VERSION.SDK_INT >= 23) {
            return this.permissionHelper.getPermissionStatus("android.permission.READ_EXTERNAL_STORAGE");
        }
        return 0;
    }

    @Override
    public void requestPermission() {
        this.permissionHelper.setAskedForPermissionPref(true);
        if (Build.VERSION.SDK_INT >= 33) {
            this.galleryInputScreen.requestPermissions(new String[]{"android.permission.READ_MEDIA_IMAGES", "android.permission.READ_MEDIA_AUDIO"}, 1);
        } else if (Build.VERSION.SDK_INT >= 23) {
            this.galleryInputScreen.requestPermissions(new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, 1);
        }
    }

    @Override
    public void setListener(GalleryInputDataSource.Listener listener) {
        this.listener = listener;
    }

    @Override
    public int getCount() {
        if (this.getPermissionStatus() != 0) {
            return 0;
        }
        Cursor cursor = this.createMediaCursor(0);
        int count = 0;
        if (cursor != null) {
            count = cursor.getCount();
            cursor.close();
        }
        return count;
    }

    @Override
    public void getImages(int offset, @Nullable String query) {
        this.loading = true;
        Cursor cursor = this.createMediaCursor(offset);
        this.loading = false;
        if (cursor == null) {
            this.listener.onError();
        } else {
            this.listener.onSuccess(this.galleryImagesFromCursor(cursor));
        }
    }

    @VisibleForTesting
    List<GalleryImage> galleryImagesFromCursor(Cursor cursor) {
        ArrayList<GalleryImage> galleryImages = new ArrayList<GalleryImage>(cursor.getCount());
        if (cursor.moveToFirst()) {
            do {
                int mediaType = cursor.getInt(cursor.getColumnIndexOrThrow("media_type"));
                String mimeType = cursor.getString(cursor.getColumnIndexOrThrow("mime_type"));
                String fileName = cursor.getString(cursor.getColumnIndexOrThrow("title"));
                int fileSize = cursor.getInt(cursor.getColumnIndexOrThrow("_size"));
                long videoDurationInMs = cursor.getLong(cursor.getColumnIndexOrThrow("duration"));
                if (fileName == null || mimeType == null) continue;
                long id2 = cursor.getLong(cursor.getColumnIndexOrThrow("_id"));
                Uri uri = ContentUris.withAppendedId((Uri)this.getContentUri(), (long)id2);
                fileName = this.createFileNameWithExtension(fileName, mimeType, MimeTypeMap.getSingleton());
                Point dimensions = this.getImageHeightAndWidth(cursor);
                boolean isVideo = mediaType == 3;
                String duration = UtilsKt.millisecondsToFormatTime(videoDurationInMs);
                GalleryImage galleryImage = new GalleryImage(fileName, mimeType, uri, "", "", dimensions.x, dimensions.y, fileSize, false, isVideo, duration);
                galleryImages.add(galleryImage);
            } while (cursor.moveToNext());
        }
        cursor.close();
        return galleryImages;
    }

    @NonNull
    @VisibleForTesting
    String createFileNameWithExtension(@NonNull String fileName, @NonNull String mimeType, MimeTypeMap mimeTypeMap) {
        String extFromMimeType;
        String fileExtension = MimeTypeMap.getFileExtensionFromUrl((String)fileName);
        if (fileExtension.isEmpty() && (extFromMimeType = mimeTypeMap.getExtensionFromMimeType(mimeType)) != null && !extFromMimeType.isEmpty()) {
            return String.format("%s.%s", fileName, extFromMimeType);
        }
        return fileName;
    }

    private Point getImageHeightAndWidth(Cursor cursor) {
        int imageHeight = cursor.getInt(cursor.getColumnIndexOrThrow("height"));
        int imageWidth = cursor.getInt(cursor.getColumnIndexOrThrow("width"));
        return new Point(imageWidth, imageHeight);
    }

    @Override
    public boolean isLoading() {
        return this.loading;
    }

    private Cursor createMediaCursor(int offset) {
        String selection = "media_type=1";
        if (this.shouldShowVideos) {
            selection = selection + " OR media_type=3";
        }
        String[] projection = new String[]{"_id", "date_added", "media_type", "mime_type", "title", "height", "width", "_size", "duration"};
        if (Build.VERSION.SDK_INT >= 26) {
            Bundle bundle = new Bundle();
            bundle.putStringArray("android:query-arg-sort-columns", new String[]{"date_added"});
            bundle.putInt("android:query-arg-sort-direction", 1);
            bundle.putInt("android:query-arg-limit", 50);
            bundle.putInt("android:query-arg-offset", offset);
            bundle.putString("android:query-arg-sql-selection", selection);
            return this.context.getContentResolver().query(this.getContentUri(), projection, bundle, null);
        }
        return this.context.getContentResolver().query(this.getContentUri(), projection, selection, null, "date_added DESC LIMIT 50 OFFSET " + offset);
    }

    private Uri getContentUri() {
        return MediaStore.Files.getContentUri((String)"external");
    }
}

