/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.input.gallery;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.Fragment;
import com.intercom.composer.ImageLoader;
import com.intercom.input.gallery.GalleryImage;
import com.intercom.input.gallery.R;

public abstract class GalleryLightBoxFragment
extends Fragment
implements View.OnClickListener {
    @VisibleForTesting
    GalleryImage galleryImage;
    private ImageLoader imageLoader;

    public static Bundle createArgs(GalleryImage galleryImage) {
        Bundle args = new Bundle();
        args.putParcelable("gallery_image", (Parcelable)galleryImage);
        return args;
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        Bundle arguments = this.getArguments();
        this.galleryImage = (GalleryImage)arguments.getParcelable("gallery_image");
        Injector injector = this.getInjector(this);
        this.imageLoader = injector.getImageLoader(this);
    }

    protected abstract Injector getInjector(GalleryLightBoxFragment var1);

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.intercom_composer_gallery_lightbox_fragment, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        ImageView imageView = (ImageView)view.findViewById(R.id.lightbox_image);
        this.imageLoader.loadImageIntoView(this.galleryImage, imageView);
        if (this.galleryImage.isVideo()) {
            View shadow = view.findViewById(R.id.video_duration_shadow);
            LinearLayout videoDetailsLayout = (LinearLayout)view.findViewById(R.id.video_details_layout);
            shadow.setVisibility(0);
            videoDetailsLayout.setVisibility(0);
            TextView fileName = (TextView)view.findViewById(R.id.file_name);
            TextView duration = (TextView)view.findViewById(R.id.video_duration);
            fileName.setText((CharSequence)this.galleryImage.getFileName());
            duration.setText((CharSequence)this.galleryImage.getDuration());
        }
        view.findViewById(R.id.lightbox_send_button).setOnClickListener((View.OnClickListener)this);
        view.findViewById(R.id.lightbox_close_button).setOnClickListener((View.OnClickListener)this);
    }

    public void onClick(View v) {
        if (v.getId() == R.id.lightbox_send_button) {
            Intent intent = new Intent();
            intent.putExtra("gallery_image", (Parcelable)this.galleryImage);
            this.getActivity().setResult(-1, intent);
        }
        this.getActivity().onBackPressed();
    }

    public static interface Injector {
        public ImageLoader getImageLoader(GalleryLightBoxFragment var1);
    }
}

