/*
 * Decompiled with CFR 0.152.
 */
package com.interaso.webpush;

import com.interaso.webpush.CryptoKt;
import com.interaso.webpush.VapidKeys;
import com.interaso.webpush.WebPush;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006JO\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00182\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u00a2\u0006\u0002\u0010\u001cJO\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00182\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u00a2\u0006\u0002\u0010\u001dR\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/interaso/webpush/WebPushService;", "", "subject", "", "vapidKeys", "Lcom/interaso/webpush/VapidKeys;", "(Ljava/lang/String;Lcom/interaso/webpush/VapidKeys;)V", "httpClient", "Ljava/net/http/HttpClient;", "kotlin.jvm.PlatformType", "getSubject", "()Ljava/lang/String;", "getVapidKeys", "()Lcom/interaso/webpush/VapidKeys;", "webPush", "Lcom/interaso/webpush/WebPush;", "send", "Lcom/interaso/webpush/WebPush$SubscriptionState;", "payload", "", "endpoint", "p256dh", "auth", "ttl", "", "topic", "urgency", "Lcom/interaso/webpush/WebPush$Urgency;", "([BLjava/lang/String;[B[BLjava/lang/Integer;Ljava/lang/String;Lcom/interaso/webpush/WebPush$Urgency;)Lcom/interaso/webpush/WebPush$SubscriptionState;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Lcom/interaso/webpush/WebPush$Urgency;)Lcom/interaso/webpush/WebPush$SubscriptionState;", "webpush"})
@SourceDebugExtension(value={"SMAP\nWebPushService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebPushService.kt\ncom/interaso/webpush/WebPushService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,88:1\n1#2:89\n215#3,2:90\n*S KotlinDebug\n*F\n+ 1 WebPushService.kt\ncom/interaso/webpush/WebPushService\n*L\n77#1:90,2\n*E\n"})
public final class WebPushService {
    @NotNull
    private final String subject;
    @NotNull
    private final VapidKeys vapidKeys;
    @NotNull
    private final WebPush webPush;
    private final HttpClient httpClient;

    public WebPushService(@NotNull String subject, @NotNull VapidKeys vapidKeys) {
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Intrinsics.checkNotNullParameter((Object)vapidKeys, (String)"vapidKeys");
        this.subject = subject;
        this.vapidKeys = vapidKeys;
        this.webPush = new WebPush(this.subject, this.vapidKeys);
        this.httpClient = HttpClient.newBuilder().build();
    }

    @NotNull
    public final String getSubject() {
        return this.subject;
    }

    @NotNull
    public final VapidKeys getVapidKeys() {
        return this.vapidKeys;
    }

    @NotNull
    public final WebPush.SubscriptionState send(@NotNull String payload, @NotNull String endpoint, @NotNull String p256dh, @NotNull String auth, @Nullable Integer ttl, @Nullable String topic, @Nullable WebPush.Urgency urgency) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)p256dh, (String)"p256dh");
        Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
        String string = payload;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return this.send(byArray, endpoint, CryptoKt.decodeBase64(p256dh), CryptoKt.decodeBase64(auth), ttl, topic, urgency);
    }

    public static /* synthetic */ WebPush.SubscriptionState send$default(WebPushService webPushService, String string, String string2, String string3, String string4, Integer n, String string5, WebPush.Urgency urgency, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = null;
        }
        if ((n2 & 0x20) != 0) {
            string5 = null;
        }
        if ((n2 & 0x40) != 0) {
            urgency = null;
        }
        return webPushService.send(string, string2, string3, string4, n, string5, urgency);
    }

    @NotNull
    public final WebPush.SubscriptionState send(@NotNull byte[] payload, @NotNull String endpoint, @NotNull byte[] p256dh, @NotNull byte[] auth, @Nullable Integer ttl, @Nullable String topic, @Nullable WebPush.Urgency urgency) {
        HttpRequest.Builder builder;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)p256dh, (String)"p256dh");
        Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
        byte[] body = this.webPush.getBody(payload, p256dh, auth);
        Map<String, String> headers = this.webPush.getHeaders(endpoint, ttl, topic, urgency);
        HttpRequest.Builder $this$send_u24lambda_u241 = builder = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofByteArray(body)).uri(URI.create(endpoint));
        boolean bl = false;
        Map<String, String> $this$forEach$iv = headers;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> it = element$iv = iterator.next();
            boolean bl2 = false;
            $this$send_u24lambda_u241.setHeader(it.getKey(), it.getValue());
        }
        HttpRequest request = builder.build();
        HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        return this.webPush.getSubscriptionState(response.statusCode(), response.body());
    }

    public static /* synthetic */ WebPush.SubscriptionState send$default(WebPushService webPushService, byte[] byArray, String string, byte[] byArray2, byte[] byArray3, Integer n, String string2, WebPush.Urgency urgency, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = null;
        }
        if ((n2 & 0x20) != 0) {
            string2 = null;
        }
        if ((n2 & 0x40) != 0) {
            urgency = null;
        }
        return webPushService.send(byArray, string, byArray2, byArray3, n, string2, urgency);
    }
}

