/*
 * Decompiled with CFR 0.152.
 */
package com.intele.chimera.client.request;

import com.intele.chimera.client.request.GasSettings;
import com.intele.chimera.client.request.SendWindow;
import com.intele.chimera.gw.xsd.smsgateway.request._2013._02.Message;
import com.intele.chimera.gw.xsd.smsgateway.request._2013._02.OriginatorSettings;
import com.intele.chimera.gw.xsd.smsgateway.request._2013._02.OriginatorTypeEnum;
import com.intele.chimera.gw.xsd.smsgateway.request._2013._02.Parameter;
import com.intele.chimera.gw.xsd.smsgateway.request._2013._02.Settings;
import java.util.List;

public class Sms {
    private final Message message = new Message();

    private Sms(Builder builder) {
        this.message.setClientReference(builder.clientReference);
        this.message.setContent(builder.content);
        this.message.setPrice(builder.price);
        this.message.setRecipient(builder.recipient);
        if (builder.hasSettings()) {
            Settings settings = new Settings();
            settings.setAge(builder.age);
            settings.setDifferentiator(builder.differentiator);
            if (builder.gasSettings != null) {
                settings.setGasSettings(builder.gasSettings.getGasSettings());
            }
            settings.setInvoiceNode(builder.invoiceNode);
            settings.setNewSession(builder.newSession);
            settings.setOriginatorSettings(builder.originatorSettings);
            settings.setPriority(builder.priority);
            settings.setSafeRemoveNonGsmCharacters(builder.safeRemoveNonGsmCharacters);
            if (builder.sendWindow != null) {
                settings.setSendWindow(builder.sendWindow.getSendWindow());
            }
            settings.setSessionId(builder.sessionId);
            settings.setValidity(builder.validity);
            if (builder.parameters != null) {
                for (Parameter p : builder.parameters) {
                    settings.getParameter().add(p);
                }
            }
            this.message.setSettings(settings);
        }
    }

    public Message getMessage() {
        return this.message;
    }

    public static class Builder {
        private String recipient;
        private String content;
        private Integer price;
        private String clientReference;
        private Integer priority;
        private Integer validity;
        private String differentiator;
        private Integer age;
        private Boolean newSession;
        private String sessionId;
        private String invoiceNode;
        private Boolean safeRemoveNonGsmCharacters;
        private List<Parameter> parameters;
        private OriginatorSettings originatorSettings;
        private GasSettings gasSettings;
        private SendWindow sendWindow;

        public Builder(String recipient, String content) {
            this.recipient = recipient;
            this.content = content;
        }

        public Builder withPrice(int price) {
            this.price = price;
            return this;
        }

        public Builder withClientReference(String clientReference) {
            this.clientReference = clientReference;
            return this;
        }

        public Builder withPriority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder withValidity(int validity) {
            this.validity = validity;
            return this;
        }

        public Builder withDifferentiator(String differentiator) {
            this.differentiator = differentiator;
            return this;
        }

        public Builder withAge(int age) {
            this.age = age;
            return this;
        }

        public Builder withNewSession(boolean newSession) {
            this.newSession = newSession;
            return this;
        }

        public Builder withSessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public Builder withInvoiceNode(String invoiceNode) {
            this.invoiceNode = invoiceNode;
            return this;
        }

        public Builder withSafeRemoveNonGsmCharacters(boolean safeRemoveNonGsmCharacters) {
            this.safeRemoveNonGsmCharacters = safeRemoveNonGsmCharacters;
            return this;
        }

        public Builder withParameters(List<Parameter> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder withOriginatorSettings(OriginatorTypeEnum originatorType, String originator) {
            this.originatorSettings = new OriginatorSettings();
            this.originatorSettings.setOriginator(originator);
            this.originatorSettings.setOriginatorType(originatorType);
            return this;
        }

        public Builder withGasSettings(GasSettings gasSettings) {
            this.gasSettings = gasSettings;
            return this;
        }

        public Builder withSendWindow(SendWindow sendWindow) {
            this.sendWindow = sendWindow;
            return this;
        }

        public Sms build() {
            return new Sms(this);
        }

        private boolean hasSettings() {
            return this.priority != null || this.validity != null || this.differentiator != null || this.age != null || this.newSession != null || this.sessionId != null || this.invoiceNode != null || this.safeRemoveNonGsmCharacters != null || this.parameters != null || this.originatorSettings != null || this.gasSettings != null || this.sendWindow != null;
        }
    }
}

