/*
 * Decompiled with CFR 0.152.
 */
package com.intele.chimera.client;

import com.intele.chimera.client.GatewayClient;
import com.intele.chimera.client.impl.GatewayClientImpl;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;

public class GatewayClientBuilder {
    public static final String DEFAULT_TARGET_SERVER = "https://smsgw.intele.com";
    public static final String DEFAULT_TARGET_SERVER_PATH = "/gw/rs/sendMessages";
    public static final MediaType DEFAULT_MEDIA_TYPE = MediaType.APPLICATION_XML_TYPE;
    private Client client;
    private String target;
    private MediaType mediaType;
    private Configuration configuration;

    public GatewayClientBuilder withClient(Client client) {
        if (this.configuration != null) {
            throw new IllegalArgumentException("Client cannot be set when a configuration has been provided. Instead set the configuration directly on the provided client.");
        }
        this.client = client;
        return this;
    }

    public GatewayClientBuilder withTargetServer(String targetServer) {
        if (targetServer == null) {
            throw new IllegalArgumentException("Target server cannot be null.");
        }
        StringBuilder b = new StringBuilder();
        if (targetServer.endsWith("/")) {
            b.append(targetServer.substring(0, targetServer.length() - 1));
        } else {
            b.append(targetServer);
        }
        b.append(DEFAULT_TARGET_SERVER_PATH);
        this.target = b.toString();
        return this;
    }

    public GatewayClientBuilder withMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    public GatewayClientBuilder withConfiguration(Configuration configuration) {
        if (this.client != null) {
            throw new IllegalArgumentException("Configuration cannot be set when a client has been provided. Instead set the configuration directly on the provided client.");
        }
        this.configuration = configuration;
        return this;
    }

    public GatewayClient build() {
        this.initializeVariables();
        return new GatewayClientImpl(this.client, this.target, this.mediaType);
    }

    private void initializeVariables() {
        if (this.client == null) {
            this.client = this.configuration != null ? ClientBuilder.newClient((Configuration)this.configuration) : ClientBuilder.newClient();
        }
        if (this.target == null) {
            this.target = "https://smsgw.intele.com/gw/rs/sendMessages";
        }
        if (this.mediaType == null) {
            this.mediaType = DEFAULT_MEDIA_TYPE;
        }
    }
}

