/*
 * Decompiled with CFR 0.152.
 */
package com.instana.android.performance.mem;

import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.res.Configuration;
import com.instana.android.Instana;
import com.instana.android.core.InstanaLifeCycle;
import com.instana.android.core.event.CustomEventService;
import com.instana.android.core.util.ConstantsAndUtil;
import com.instana.android.core.util.Logger;
import com.instana.android.performance.PerformanceMonitor;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/instana/android/performance/mem/LowMemoryMonitor;", "Landroid/content/ComponentCallbacks2;", "Lcom/instana/android/performance/PerformanceMonitor;", "app", "Landroid/app/Application;", "lifeCycle", "Lcom/instana/android/core/InstanaLifeCycle;", "(Landroid/app/Application;Lcom/instana/android/core/InstanaLifeCycle;)V", "<set-?>", "", "enabled", "getEnabled", "()Z", "setEnabled", "(Z)V", "enabled$delegate", "Lkotlin/properties/ReadWriteProperty;", "onConfigurationChanged", "", "newConfig", "Landroid/content/res/Configuration;", "onLowMemory", "onTrimMemory", "level", "", "sendLowMemoryEvent", "activityName", "", "Companion", "runtime_release"})
public final class LowMemoryMonitor
implements ComponentCallbacks2,
PerformanceMonitor {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Application app;
    @NotNull
    private final InstanaLifeCycle lifeCycle;
    @NotNull
    private final ReadWriteProperty enabled$delegate;
    public static final long MB = 0x100000L;

    public LowMemoryMonitor(@NotNull Application app, @NotNull InstanaLifeCycle lifeCycle) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)lifeCycle, (String)"lifeCycle");
        this.app = app;
        this.lifeCycle = lifeCycle;
        Delegates delegates = Delegates.INSTANCE;
        Boolean initialValue$iv = false;
        boolean $i$f$observable = false;
        this.enabled$delegate = (ReadWriteProperty)new ObservableProperty<Boolean>((Object)initialValue$iv, this){
            final /* synthetic */ Object $initialValue;
            final /* synthetic */ LowMemoryMonitor this$0;
            {
                this.$initialValue = $initialValue;
                this.this$0 = lowMemoryMonitor;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                void newValue2;
                void oldValue2;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                boolean bl = (Boolean)newValue;
                boolean bl2 = (Boolean)oldValue;
                KProperty $noName_0 = property;
                boolean bl3 = false;
                if (oldValue2 != newValue2) {
                    if (newValue2 != false) {
                        LowMemoryMonitor.access$getApp$p(this.this$0).registerComponentCallbacks((ComponentCallbacks)this.this$0);
                    } else if (newValue2 == false) {
                        LowMemoryMonitor.access$getApp$p(this.this$0).unregisterComponentCallbacks((ComponentCallbacks)this.this$0);
                    }
                }
                Logger.i(Intrinsics.stringPlus((String)"LowMemoryMonitor enabled: ", (Object)((boolean)newValue2)));
            }
        };
    }

    @Override
    public boolean getEnabled() {
        return (Boolean)this.enabled$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)bl);
    }

    public void onLowMemory() {
    }

    public void onConfigurationChanged(@NotNull Configuration newConfig) {
        Intrinsics.checkNotNullParameter((Object)newConfig, (String)"newConfig");
    }

    public void onTrimMemory(int level) {
        if (level == 15) {
            String string = this.lifeCycle.getActivityName();
            if (string == null) {
                string = "";
            }
            String activityName = string;
            this.sendLowMemoryEvent(activityName);
        }
    }

    private final void sendLowMemoryEvent(String activityName) {
        Logger.d(Intrinsics.stringPlus((String)"LowMemory detected with: `activityName` ", (Object)activityName));
        long maxMem = ConstantsAndUtil.INSTANCE.getRuntime().maxMemory();
        long usedMem = ConstantsAndUtil.INSTANCE.getRuntime().totalMemory() - ConstantsAndUtil.INSTANCE.getRuntime().freeMemory();
        long availableMem = maxMem - usedMem;
        long maxInMb = maxMem / 0x100000L;
        long availableInMb = availableMem / 0x100000L;
        long usedInMb = usedMem / 0x100000L;
        CustomEventService customEventService = Instana.INSTANCE.getCustomEvents$runtime_release();
        if (customEventService != null) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"activityName", (Object)activityName), TuplesKt.to((Object)"maxMb", (Object)String.valueOf(maxInMb)), TuplesKt.to((Object)"availableMb", (Object)String.valueOf(availableInMb)), TuplesKt.to((Object)"usedMb", (Object)String.valueOf(usedInMb))};
            customEventService.submit("LowMemory", System.currentTimeMillis(), 0L, MapsKt.mapOf((Pair[])pairArray), Instana.getView(), null, null);
        }
    }

    public static final /* synthetic */ Application access$getApp$p(LowMemoryMonitor $this) {
        return $this.app;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(LowMemoryMonitor.class, "enabled", "getEnabled()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/instana/android/performance/mem/LowMemoryMonitor$Companion;", "", "()V", "MB", "", "runtime_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

