/*
 * Decompiled with CFR 0.152.
 */
package com.instana.android.performance.frame;

import android.os.SystemClock;
import android.view.Choreographer;
import com.instana.android.Instana;
import com.instana.android.core.InstanaLifeCycle;
import com.instana.android.core.event.CustomEventService;
import com.instana.android.core.util.Logger;
import com.instana.android.performance.PerformanceMonitor;
import com.instana.android.performance.PerformanceMonitorConfig;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 &2\u00020\u00012\u00020\u0002:\u0001&B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001f\u001a\u00020\u0015H\u0002J\b\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u0015H\u0016J\u0010\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020\u0015H\u0002R+\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u0012\u001a\u0004\b\u0017\u0010\u000e\"\u0004\b\u0018\u0010\u0010R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/instana/android/performance/frame/FrameSkipMonitor;", "Landroid/view/Choreographer$FrameCallback;", "Lcom/instana/android/performance/PerformanceMonitor;", "performanceMonitorConfig", "Lcom/instana/android/performance/PerformanceMonitorConfig;", "lifeCycle", "Lcom/instana/android/core/InstanaLifeCycle;", "choreographer", "Landroid/view/Choreographer;", "(Lcom/instana/android/performance/PerformanceMonitorConfig;Lcom/instana/android/core/InstanaLifeCycle;Landroid/view/Choreographer;)V", "<set-?>", "", "appInBackground", "getAppInBackground", "()Z", "setAppInBackground", "(Z)V", "appInBackground$delegate", "Lkotlin/properties/ReadWriteProperty;", "dipActive", "duration", "", "enabled", "getEnabled", "setEnabled", "enabled$delegate", "frames", "", "lastFrameTime", "Ljava/lang/Long;", "startTime", "calculateFPS", "checkConditionsAndSendEvent", "", "doFrame", "frameTimeNanos", "sendFrameDipEvent", "averageFrameRate", "Companion", "runtime_release"})
public final class FrameSkipMonitor
implements Choreographer.FrameCallback,
PerformanceMonitor {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final PerformanceMonitorConfig performanceMonitorConfig;
    @NotNull
    private final InstanaLifeCycle lifeCycle;
    @NotNull
    private final Choreographer choreographer;
    @NotNull
    private final ReadWriteProperty enabled$delegate;
    @NotNull
    private final ReadWriteProperty appInBackground$delegate;
    private boolean dipActive;
    @Nullable
    private Long lastFrameTime;
    private long startTime;
    private long duration;
    @NotNull
    private List<Long> frames;
    private static final long START_DELAY_TIME_MS = 4000L;

    public FrameSkipMonitor(@NotNull PerformanceMonitorConfig performanceMonitorConfig, @NotNull InstanaLifeCycle lifeCycle, @NotNull Choreographer choreographer) {
        Intrinsics.checkNotNullParameter((Object)performanceMonitorConfig, (String)"performanceMonitorConfig");
        Intrinsics.checkNotNullParameter((Object)lifeCycle, (String)"lifeCycle");
        Intrinsics.checkNotNullParameter((Object)choreographer, (String)"choreographer");
        this.performanceMonitorConfig = performanceMonitorConfig;
        this.lifeCycle = lifeCycle;
        this.choreographer = choreographer;
        Delegates delegates = Delegates.INSTANCE;
        Boolean initialValue$iv = false;
        boolean $i$f$observable = false;
        this.enabled$delegate = (ReadWriteProperty)new ObservableProperty<Boolean>((Object)initialValue$iv, this){
            final /* synthetic */ Object $initialValue;
            final /* synthetic */ FrameSkipMonitor this$0;
            {
                this.$initialValue = $initialValue;
                this.this$0 = frameSkipMonitor;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                void newValue2;
                void oldValue2;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                boolean bl = (Boolean)newValue;
                boolean bl2 = (Boolean)oldValue;
                KProperty $noName_0 = property;
                boolean bl3 = false;
                if (oldValue2 != newValue2) {
                    if (newValue2 != false) {
                        FrameSkipMonitor.access$getChoreographer$p(this.this$0).postFrameCallbackDelayed((Choreographer.FrameCallback)this.this$0, 4000L);
                    } else if (newValue2 == false) {
                        FrameSkipMonitor.access$getChoreographer$p(this.this$0).removeFrameCallback((Choreographer.FrameCallback)this.this$0);
                    }
                }
                Logger.i(Intrinsics.stringPlus((String)"FrameSkipMonitor enabled: ", (Object)((boolean)newValue2)));
            }
        };
        Delegates this_$iv = Delegates.INSTANCE;
        initialValue$iv = false;
        $i$f$observable = false;
        this.appInBackground$delegate = (ReadWriteProperty)new ObservableProperty<Boolean>((Object)initialValue$iv, this){
            final /* synthetic */ Object $initialValue;
            final /* synthetic */ FrameSkipMonitor this$0;
            {
                this.$initialValue = $initialValue;
                this.this$0 = frameSkipMonitor;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                void newValue2;
                void oldValue2;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                boolean bl = (Boolean)newValue;
                boolean bl2 = (Boolean)oldValue;
                KProperty $noName_0 = property;
                boolean bl3 = false;
                if (oldValue2 != newValue2 && this.this$0.getEnabled()) {
                    if (newValue2 == false) {
                        FrameSkipMonitor.access$getChoreographer$p(this.this$0).postFrameCallbackDelayed((Choreographer.FrameCallback)this.this$0, 4000L);
                    } else if (newValue2 != false) {
                        FrameSkipMonitor.access$getChoreographer$p(this.this$0).removeFrameCallback((Choreographer.FrameCallback)this.this$0);
                    }
                }
            }
        };
        this.frames = new ArrayList();
    }

    public /* synthetic */ FrameSkipMonitor(PerformanceMonitorConfig performanceMonitorConfig, InstanaLifeCycle instanaLifeCycle, Choreographer choreographer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            Choreographer choreographer2 = Choreographer.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)choreographer2, (String)"getInstance()");
            choreographer = choreographer2;
        }
        this(performanceMonitorConfig, instanaLifeCycle, choreographer);
    }

    @Override
    public boolean getEnabled() {
        return (Boolean)this.enabled$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)bl);
    }

    public final boolean getAppInBackground() {
        return (Boolean)this.appInBackground$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    public final void setAppInBackground(boolean bl) {
        this.appInBackground$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)bl);
    }

    public void doFrame(long frameTimeNanos) {
        Long l;
        if (this.lastFrameTime != null) {
            long frameRate = this.calculateFPS();
            if ((int)frameRate < this.performanceMonitorConfig.getFrameRateDipThreshold()) {
                this.frames.add(frameRate);
                if (!this.dipActive) {
                    this.startTime = System.currentTimeMillis();
                    this.dipActive = true;
                }
            } else if (this.dipActive) {
                this.duration = System.currentTimeMillis() - this.startTime;
                this.dipActive = false;
                this.checkConditionsAndSendEvent();
                this.frames.clear();
            }
            l = SystemClock.elapsedRealtime();
        } else {
            l = this.lastFrameTime = Long.valueOf(SystemClock.elapsedRealtime());
        }
        if (this.getEnabled()) {
            this.choreographer.postFrameCallback((Choreographer.FrameCallback)this);
        }
    }

    private final void checkConditionsAndSendEvent() {
        long averageFrameRate = (long)CollectionsKt.averageOfLong((Iterable)this.frames);
        if (averageFrameRate != 0L) {
            this.sendFrameDipEvent(averageFrameRate);
        }
    }

    private final void sendFrameDipEvent(long averageFrameRate) {
        String string = this.lifeCycle.getActivityName();
        if (string == null) {
            string = "";
        }
        String activityName = string;
        Logger.d("FrameDip detected with: `activityName` " + activityName + ", `avgFrameRate` " + averageFrameRate);
        CustomEventService customEventService = Instana.INSTANCE.getCustomEvents$runtime_release();
        if (customEventService != null) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"activityName", (Object)activityName), TuplesKt.to((Object)"avgFrameRate", (Object)String.valueOf(averageFrameRate))};
            customEventService.submit("FrameDip", this.startTime, this.duration, MapsKt.mapOf((Pair[])pairArray), Instana.getView(), null, null);
        }
    }

    private final long calculateFPS() {
        long l = SystemClock.elapsedRealtime();
        Long l2 = this.lastFrameTime;
        Intrinsics.checkNotNull((Object)l2);
        long elapsedTime = l - l2;
        return elapsedTime == 0L ? (long)this.performanceMonitorConfig.getFrameRateDipThreshold() : (long)1000 / elapsedTime;
    }

    public static final /* synthetic */ Choreographer access$getChoreographer$p(FrameSkipMonitor $this) {
        return $this.choreographer;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(FrameSkipMonitor.class, "enabled", "getEnabled()Z", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(FrameSkipMonitor.class, "appInBackground", "getAppInBackground()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/instana/android/performance/frame/FrameSkipMonitor$Companion;", "", "()V", "START_DELAY_TIME_MS", "", "runtime_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

