/*
 * Decompiled with CFR 0.152.
 */
package com.instana.android.performance.anr;

import com.instana.android.core.util.Logger;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J3\u0010\u000b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/instana/android/performance/anr/AnrException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "thread", "Ljava/lang/Thread;", "(Ljava/lang/Thread;)V", "logProcessMap", "", "printProcessMap", "ps", "Ljava/io/PrintStream;", "printThread", "l", "Ljava/util/Locale;", "stack", "", "Ljava/lang/StackTraceElement;", "(Ljava/io/PrintStream;Ljava/util/Locale;Ljava/lang/Thread;[Ljava/lang/StackTraceElement;)V", "runtime_release"})
public final class AnrException
extends Exception {
    public AnrException(@NotNull Thread thread) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        super("ANR detected");
        this.setStackTrace(thread.getStackTrace());
    }

    public final void logProcessMap() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos);
        this.printProcessMap(ps);
        byte[] byArray = bos.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"bos.toByteArray()");
        Logger.i(new String(byArray, Charsets.UTF_8));
    }

    private final void printProcessMap(PrintStream ps) {
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        ps.println("Process map:");
        for (Thread thread : stackTraces.keySet()) {
            Object object = stackTraces.get(thread);
            if (!(object == null ? false : !(((StackTraceElement[])object).length == 0))) continue;
            object = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getDefault()");
            Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"thread");
            StackTraceElement[] stackTraceElementArray = stackTraces.get(thread);
            Intrinsics.checkNotNull((Object)stackTraceElementArray);
            this.printThread(ps, (Locale)object, thread, stackTraceElementArray);
            ps.println();
        }
    }

    private final void printThread(PrintStream ps, Locale l, Thread thread, StackTraceElement[] stack) {
        String string = "\t%s (%s)";
        Object[] objectArray = new Object[]{thread.getName(), thread.getState()};
        String string2 = String.format(l, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
        ps.println(string2);
        for (StackTraceElement element : stack) {
            String string3 = "\t\t%s.%s(%s:%d)";
            Object[] objectArray2 = new Object[]{element.getClassName(), element.getMethodName(), element.getFileName(), element.getLineNumber()};
            String string4 = String.format(l, string3, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(locale, format, *args)");
            ps.println(string4);
        }
    }
}

