/*
 * Decompiled with CFR 0.152.
 */
package com.instana.android.performance;

import android.app.Application;
import com.instana.android.core.InstanaLifeCycle;
import com.instana.android.core.util.Logger;
import com.instana.android.performance.PerformanceMonitor;
import com.instana.android.performance.PerformanceMonitorConfig;
import com.instana.android.performance.anr.ANRMonitor;
import com.instana.android.performance.frame.FrameSkipMonitor;
import com.instana.android.performance.mem.LowMemoryMonitor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/instana/android/performance/PerformanceService;", "Lcom/instana/android/core/InstanaLifeCycle$AppStateCallback;", "app", "Landroid/app/Application;", "performanceMonitorConfig", "Lcom/instana/android/performance/PerformanceMonitorConfig;", "lifeCycle", "Lcom/instana/android/core/InstanaLifeCycle;", "(Landroid/app/Application;Lcom/instana/android/performance/PerformanceMonitorConfig;Lcom/instana/android/core/InstanaLifeCycle;)V", "anrMonitor", "Lcom/instana/android/performance/PerformanceMonitor;", "getAnrMonitor", "()Lcom/instana/android/performance/PerformanceMonitor;", "frameSkipMonitor", "getFrameSkipMonitor", "lowMemoryMonitor", "getLowMemoryMonitor", "onAppInBackground", "", "onAppInForeground", "runtime_release"})
public final class PerformanceService
implements InstanaLifeCycle.AppStateCallback {
    @NotNull
    private final PerformanceMonitor lowMemoryMonitor;
    @NotNull
    private final PerformanceMonitor frameSkipMonitor;
    @NotNull
    private final PerformanceMonitor anrMonitor;

    public PerformanceService(@NotNull Application app, @NotNull PerformanceMonitorConfig performanceMonitorConfig, @NotNull InstanaLifeCycle lifeCycle) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)performanceMonitorConfig, (String)"performanceMonitorConfig");
        Intrinsics.checkNotNullParameter((Object)lifeCycle, (String)"lifeCycle");
        this.lowMemoryMonitor = new LowMemoryMonitor(app, lifeCycle);
        this.frameSkipMonitor = new FrameSkipMonitor(performanceMonitorConfig, lifeCycle, null, 4, null);
        this.anrMonitor = new ANRMonitor(performanceMonitorConfig, lifeCycle);
        lifeCycle.registerCallback(this);
    }

    @NotNull
    public final PerformanceMonitor getLowMemoryMonitor() {
        return this.lowMemoryMonitor;
    }

    @NotNull
    public final PerformanceMonitor getFrameSkipMonitor() {
        return this.frameSkipMonitor;
    }

    @NotNull
    public final PerformanceMonitor getAnrMonitor() {
        return this.anrMonitor;
    }

    @Override
    public void onAppInBackground() {
        Logger.d("Detected app is on background");
        ((FrameSkipMonitor)this.frameSkipMonitor).setAppInBackground(true);
    }

    @Override
    public void onAppInForeground() {
        Logger.d("Detected app is on foreground");
        ((FrameSkipMonitor)this.frameSkipMonitor).setAppInBackground(false);
    }
}

