/*
 * Decompiled with CFR 0.152.
 */
package com.instana.android.instrumentation.urlConnection;

import com.instana.android.Instana;
import com.instana.android.core.util.ConstantsAndUtil;
import com.instana.android.core.util.Logger;
import com.instana.android.core.util.URLConnectionExtensionsKt;
import com.instana.android.instrumentation.HTTPMarker;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/instana/android/instrumentation/urlConnection/UrlConnectionInstrumentation;", "", "()V", "Companion", "runtime_release"})
public final class UrlConnectionInstrumentation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ConcurrentHashMap<String, HTTPMarker> httpMarkers = new ConcurrentHashMap();

    @JvmStatic
    public static final void openConnection(@NotNull URLConnection connection) {
        Companion.openConnection(connection);
    }

    @JvmStatic
    public static final void disconnect(@NotNull HttpURLConnection connection) {
        Companion.disconnect(connection);
    }

    @JvmStatic
    public static final void handleException(@NotNull HttpURLConnection connection, @NotNull IOException exception) {
        Companion.handleException(connection, exception);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000fH\u0007R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/instana/android/instrumentation/urlConnection/UrlConnectionInstrumentation$Companion;", "", "()V", "httpMarkers", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/instana/android/instrumentation/HTTPMarker;", "disconnect", "", "connection", "Ljava/net/HttpURLConnection;", "handleException", "exception", "Ljava/io/IOException;", "openConnection", "Ljava/net/URLConnection;", "runtime_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void openConnection(@NotNull URLConnection connection) {
            HTTPMarker marker;
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            Logger.i("HttpURLConnection: intercepting openConnection");
            String header = connection.getRequestProperty("X-INSTANA-ANDROID");
            String string = connection.getURL().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"connection.url.toString()");
            String url = string;
            String redactedUrl = ConstantsAndUtil.INSTANCE.redactQueryParams(url);
            if (ConstantsAndUtil.INSTANCE.isAutoEnabled() && !ConstantsAndUtil.INSTANCE.checkTag(header) && !ConstantsAndUtil.INSTANCE.isLibraryCallBoolean(url) && !ConstantsAndUtil.INSTANCE.isBlacklistedURL(url) && (marker = Instana.startCapture$default(redactedUrl, null, null, 6, null)) != null) {
                connection.setRequestProperty("X-INSTANA-ANDROID", marker.headerValue());
                Map<String, String> requestHeaders = ConstantsAndUtil.INSTANCE.getCapturedRequestHeaders$runtime_release(URLConnectionExtensionsKt.getRequestHeadersMap(connection));
                marker.getHeaders().putAll(requestHeaders);
                Map map = httpMarkers;
                String string2 = marker.headerValue();
                map.put(string2, marker);
            }
        }

        @JvmStatic
        public final void disconnect(@NotNull HttpURLConnection connection) {
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            Logger.i("HttpURLConnection: intercepting disconnect");
            String header = connection.getRequestProperty("X-INSTANA-ANDROID");
            String string = connection.getURL().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"connection.url.toString()");
            String url = string;
            if (ConstantsAndUtil.INSTANCE.isAutoEnabled() && !ConstantsAndUtil.INSTANCE.isLibraryCallBoolean(url) && ConstantsAndUtil.INSTANCE.checkTag(header)) {
                HTTPMarker hTTPMarker = (HTTPMarker)httpMarkers.get(header);
                if (hTTPMarker != null) {
                    hTTPMarker.finish(connection);
                }
                httpMarkers.remove(header);
            }
        }

        @JvmStatic
        public final void handleException(@NotNull HttpURLConnection connection, @NotNull IOException exception) {
            HTTPMarker marker;
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            Logger.i("HttpURLConnection: intercepting exception");
            String string = connection.getRequestProperty("X-INSTANA-ANDROID");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"connection.getRequestProperty(TRACKING_HEADER_KEY)");
            String header = string;
            String string2 = connection.getURL().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"connection.url.toString()");
            String url = string2;
            if (ConstantsAndUtil.INSTANCE.isAutoEnabled() && ConstantsAndUtil.INSTANCE.hasTrackingHeader(header) && !ConstantsAndUtil.INSTANCE.isLibraryCallBoolean(url) && ConstantsAndUtil.INSTANCE.checkTag(header) && (marker = (HTTPMarker)httpMarkers.get(header)) != null) {
                marker.finish(connection, (Throwable)exception);
                httpMarkers.remove(header);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

