/*
 * Decompiled with CFR 0.152.
 */
package com.instana.android.instrumentation.okhttp3;

import com.instana.android.core.util.Logger;
import com.instana.android.instrumentation.okhttp3.OkHttp3GlobalInterceptor;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/instana/android/instrumentation/okhttp3/OkHttp3Instrumentation;", "", "()V", "Companion", "runtime_release"})
public final class OkHttp3Instrumentation {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    public static final void clientBuilderInterceptor(@NotNull OkHttpClient.Builder builder) {
        Companion.clientBuilderInterceptor(builder);
    }

    @JvmStatic
    public static final void cancelCall(@NotNull Call call) {
        Companion.cancelCall(call);
    }

    @JvmStatic
    public static final void cancelAllCall(@NotNull Dispatcher dispatcher) {
        Companion.cancelAllCall(dispatcher);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\r"}, d2={"Lcom/instana/android/instrumentation/okhttp3/OkHttp3Instrumentation$Companion;", "", "()V", "cancelAllCall", "", "dispatcher", "Lokhttp3/Dispatcher;", "cancelCall", "call", "Lokhttp3/Call;", "clientBuilderInterceptor", "builder", "Lokhttp3/OkHttpClient$Builder;", "runtime_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void clientBuilderInterceptor(@NotNull OkHttpClient.Builder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Logger.i("OkHttp3: builder detected");
            if (!builder.interceptors().contains(OkHttp3GlobalInterceptor.INSTANCE)) {
                builder.addInterceptor((Interceptor)OkHttp3GlobalInterceptor.INSTANCE);
                Logger.i("OkHttp3: added interceptor to builder");
            } else {
                Logger.i("OkHttp3: interceptor was already present in builder");
            }
        }

        @JvmStatic
        public final void cancelCall(@NotNull Call call) {
            Intrinsics.checkNotNullParameter((Object)call, (String)"call");
            Logger.i("OkHttp3: intercepted single-call cancel");
            Request request = call.request();
            Intrinsics.checkNotNullExpressionValue((Object)request, (String)"call.request()");
            OkHttp3GlobalInterceptor.INSTANCE.cancel(request);
        }

        @JvmStatic
        public final void cancelAllCall(@NotNull Dispatcher dispatcher) {
            Request request;
            Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
            Logger.i("OkHttp3: intercepted dispatcher all-call cancel");
            for (Call call : dispatcher.runningCalls()) {
                request = call.request();
                Intrinsics.checkNotNullExpressionValue((Object)request, (String)"call.request()");
                OkHttp3GlobalInterceptor.INSTANCE.cancel(request);
            }
            for (Call call : dispatcher.queuedCalls()) {
                request = call.request();
                Intrinsics.checkNotNullExpressionValue((Object)request, (String)"call.request()");
                OkHttp3GlobalInterceptor.INSTANCE.cancel(request);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

