/*
 * Decompiled with CFR 0.152.
 */
package com.instana.android.instrumentation;

import android.content.Context;
import com.instana.android.Instana;
import com.instana.android.core.InstanaConfig;
import com.instana.android.core.InstanaWorkManager;
import com.instana.android.core.event.models.AppProfile;
import com.instana.android.core.event.models.Beacon;
import com.instana.android.core.event.models.ConnectionProfile;
import com.instana.android.core.event.models.ConnectionType;
import com.instana.android.core.event.models.DeviceProfile;
import com.instana.android.core.event.models.EffectiveConnectionType;
import com.instana.android.core.event.models.UserProfile;
import com.instana.android.core.util.ConstantsAndUtil;
import com.instana.android.core.util.HttpURLConnectionExtensionsKt;
import com.instana.android.core.util.Logger;
import com.instana.android.core.util.MaxCapacityMap;
import com.instana.android.core.util.OkHttp3ExtensionsKt;
import com.instana.android.core.util.StopWatch;
import com.instana.android.core.util.URLConnectionExtensionsKt;
import com.instana.android.instrumentation.HTTPCaptureConfig;
import com.instana.android.instrumentation.HTTPMarkerData;
import com.instana.android.instrumentation.InstrumentationService;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0007\u0018\u0000 82\u00020\u0001:\u000289BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0014\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u000e\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"J\u000e\u0010 \u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$J\u0016\u0010 \u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\u0016\u0010 \u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(2\u0006\u0010%\u001a\u00020&J\u000e\u0010 \u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*J\u0012\u0010+\u001a\u0004\u0018\u00010\u00032\u0006\u0010#\u001a\u00020$H\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010\u00032\u0006\u0010)\u001a\u00020*H\u0002J\b\u0010,\u001a\u00020-H\u0016J\u0006\u0010.\u001a\u00020\u0003Ji\u0010/\u001a\u00020\u001c2\n\b\u0002\u00100\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u00101\u001a\u0004\u0018\u00010-2\n\b\u0002\u00102\u001a\u0004\u0018\u0001032\n\b\u0002\u00104\u001a\u0004\u0018\u0001032\n\b\u0002\u00105\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u00106\u001a\u0004\u0018\u00010\u00032\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0012H\u0002\u00a2\u0006\u0002\u00107R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/instana/android/instrumentation/HTTPMarker;", "", "url", "", "viewName", "requestHeaders", "", "context", "Landroid/content/Context;", "manager", "Lcom/instana/android/core/InstanaWorkManager;", "config", "Lcom/instana/android/core/InstanaConfig;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Landroid/content/Context;Lcom/instana/android/core/InstanaWorkManager;Lcom/instana/android/core/InstanaConfig;)V", "carrierName", "connectionProfile", "Lcom/instana/android/core/event/models/ConnectionProfile;", "headers", "Lcom/instana/android/core/util/MaxCapacityMap;", "getHeaders", "()Lcom/instana/android/core/util/MaxCapacityMap;", "markerId", "sessionId", "status", "Lcom/instana/android/instrumentation/HTTPMarker$MarkerStatus;", "stopWatch", "Lcom/instana/android/core/util/StopWatch;", "cancel", "", "equals", "", "other", "finish", "httpMarkerData", "Lcom/instana/android/instrumentation/HTTPMarkerData;", "connection", "Ljava/net/HttpURLConnection;", "error", "", "request", "Lokhttp3/Request;", "response", "Lokhttp3/Response;", "getBackendTraceId", "hashCode", "", "headerValue", "sendBeacon", "connectionMethod", "responseCode", "encodedResponseSizeBytes", "", "decodedResponseSizeBytes", "backendTraceId", "errorMessage", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/String;Ljava/lang/String;Lcom/instana/android/core/util/MaxCapacityMap;)V", "Companion", "MarkerStatus", "runtime_release"})
public final class HTTPMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String url;
    @Nullable
    private final String viewName;
    @NotNull
    private final Context context;
    @NotNull
    private final InstanaWorkManager manager;
    @NotNull
    private final InstanaConfig config;
    @NotNull
    private final StopWatch stopWatch;
    @NotNull
    private final String markerId;
    @Nullable
    private String carrierName;
    @NotNull
    private ConnectionProfile connectionProfile;
    @Nullable
    private final String sessionId;
    @NotNull
    private MarkerStatus status;
    @NotNull
    private final MaxCapacityMap<String, String> headers;
    @NotNull
    private static final String backendTraceIdHeaderKey = "Server-Timing";
    @NotNull
    private static final Regex backendTraceIdParser = new Regex("^.* ?intid;desc=([^,]+)?.*$");

    /*
     * WARNING - void declaration
     */
    public HTTPMarker(@NotNull String url, @Nullable String viewName, @Nullable Map<String, String> requestHeaders, @NotNull Context context, @NotNull InstanaWorkManager manager, @NotNull InstanaConfig config) {
        Map map;
        EffectiveConnectionType effectiveConnectionType;
        ConnectionType connectionType;
        InstrumentationService $this$_init__u24lambda_u2d1;
        String string;
        ConnectionType connectionType2;
        InstrumentationService $this$_init__u24lambda_u2d0;
        HTTPMarker hTTPMarker;
        String string2;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.url = url;
        this.viewName = viewName;
        this.context = context;
        this.manager = manager;
        this.config = config;
        this.stopWatch = new StopWatch();
        String string3 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"randomUUID().toString()");
        this.markerId = string3;
        this.headers = new MaxCapacityMap(64);
        this.status = MarkerStatus.STARTED;
        this.stopWatch.start();
        this.sessionId = Instana.getSessionId();
        HTTPMarker hTTPMarker2 = this;
        InstrumentationService instrumentationService = Instana.INSTANCE.getInstrumentationService$runtime_release();
        if (instrumentationService == null) {
            string2 = null;
        } else {
            InstrumentationService instrumentationService2 = instrumentationService;
            hTTPMarker = hTTPMarker2;
            boolean bl = false;
            string2 = ConstantsAndUtil.INSTANCE.getCarrierName(this.context, $this$_init__u24lambda_u2d0.getConnectivityManager(), $this$_init__u24lambda_u2d0.getTelephonyManager());
            hTTPMarker2 = hTTPMarker;
        }
        InstrumentationService instrumentationService3 = Instana.INSTANCE.getInstrumentationService$runtime_release();
        if (instrumentationService3 == null) {
            connectionType2 = null;
        } else {
            $this$_init__u24lambda_u2d0 = instrumentationService3;
            string = string2;
            hTTPMarker = hTTPMarker2;
            boolean bl = false;
            connectionType = ConstantsAndUtil.INSTANCE.getConnectionType(this.context, $this$_init__u24lambda_u2d1.getConnectivityManager());
            hTTPMarker2 = hTTPMarker;
            string2 = string;
            connectionType2 = connectionType;
        }
        InstrumentationService instrumentationService4 = Instana.INSTANCE.getInstrumentationService$runtime_release();
        if (instrumentationService4 == null) {
            effectiveConnectionType = null;
        } else {
            void $this$_init__u24lambda_u2d2;
            $this$_init__u24lambda_u2d1 = instrumentationService4;
            connectionType = connectionType2;
            string = string2;
            hTTPMarker = hTTPMarker2;
            boolean bl = false;
            EffectiveConnectionType effectiveConnectionType2 = ConstantsAndUtil.INSTANCE.getCellularConnectionType(this.context, $this$_init__u24lambda_u2d2.getConnectivityManager(), $this$_init__u24lambda_u2d2.getTelephonyManager());
            hTTPMarker2 = hTTPMarker;
            string2 = string;
            connectionType2 = connectionType;
            effectiveConnectionType = effectiveConnectionType2;
        }
        EffectiveConnectionType effectiveConnectionType3 = effectiveConnectionType;
        ConnectionType connectionType3 = connectionType2;
        String string4 = string2;
        hTTPMarker2.connectionProfile = new ConnectionProfile(string4, connectionType3, effectiveConnectionType3);
        InstrumentationService instrumentationService5 = Instana.INSTANCE.getInstrumentationService$runtime_release();
        if (instrumentationService5 != null) {
            InstrumentationService $this$_init__u24lambda_u2d3 = instrumentationService5;
            boolean bl = false;
            this.carrierName = $this$_init__u24lambda_u2d3.getTelephonyManager().getNetworkOperatorName();
            if (Intrinsics.areEqual((Object)this.carrierName, (Object)"")) {
                this.carrierName = null;
            }
            $this$_init__u24lambda_u2d3.addTag(this.markerId);
        }
        if ((map = requestHeaders) == null) {
            map = MapsKt.emptyMap();
        }
        this.headers.putAll(ConstantsAndUtil.INSTANCE.getCapturedRequestHeaders$runtime_release(map));
    }

    @NotNull
    public final MaxCapacityMap<String, String> getHeaders() {
        return this.headers;
    }

    @NotNull
    public final String headerValue() {
        return this.markerId;
    }

    public final void cancel() {
        if (this.config.getHttpCaptureConfig() == HTTPCaptureConfig.NONE) {
            return;
        }
        MarkerStatus[] markerStatusArray = new MarkerStatus[]{MarkerStatus.ENDING, MarkerStatus.ENDED};
        if (ArraysKt.contains((Object[])markerStatusArray, (Object)((Object)this.status))) {
            Logger.e("Can't cancel HTTPMarker. HTTPMarker was already cancelled");
            return;
        }
        this.status = MarkerStatus.ENDING;
        this.stopWatch.stop();
        String errorMessage = "Cancelled request";
        this.sendBeacon(null, null, null, null, null, errorMessage, this.headers);
    }

    public final void finish(@NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (this.config.getHttpCaptureConfig() == HTTPCaptureConfig.NONE) {
            return;
        }
        Headers headers = new Headers[]{MarkerStatus.ENDING, MarkerStatus.ENDED};
        if (ArraysKt.contains((Object[])headers, (Object)((Object)this.status))) {
            Logger.e("Can't finish HTTPMarker. HTTPMarker was already finished");
            return;
        }
        this.status = MarkerStatus.ENDING;
        this.stopWatch.stop();
        headers = response.headers();
        Intrinsics.checkNotNullExpressionValue((Object)headers, (String)"response.headers()");
        this.headers.putAll(ConstantsAndUtil.INSTANCE.getCapturedResponseHeaders$runtime_release(OkHttp3ExtensionsKt.toMap(headers)));
        String method = response.request().method();
        RequestBody requestBody = response.request().body();
        Long requestSize = requestBody == null ? null : Long.valueOf(requestBody.contentLength());
        ResponseBody responseBody = response.body();
        Long encodedResponseSize = responseBody == null ? null : Long.valueOf(responseBody.contentLength());
        Long decodedResponseSize = OkHttp3ExtensionsKt.decodedContentLength(response);
        this.sendBeacon(method, response.code(), encodedResponseSize, decodedResponseSize, this.getBackendTraceId(response), null, this.headers);
    }

    public final void finish(@NotNull Request request, @NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        if (this.config.getHttpCaptureConfig() == HTTPCaptureConfig.NONE) {
            return;
        }
        MarkerStatus[] markerStatusArray = new MarkerStatus[]{MarkerStatus.ENDING, MarkerStatus.ENDED};
        if (ArraysKt.contains((Object[])markerStatusArray, (Object)((Object)this.status))) {
            Logger.e("Can't finish HTTPMarker. HTTPMarker was already finished");
            return;
        }
        this.status = MarkerStatus.ENDING;
        this.stopWatch.stop();
        String method = request.method();
        RequestBody requestBody = request.body();
        Long requestSize = requestBody == null ? null : Long.valueOf(requestBody.contentLength());
        this.sendBeacon(method, null, null, null, null, error.toString(), this.headers);
    }

    public final void finish(@NotNull HttpURLConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        if (this.config.getHttpCaptureConfig() == HTTPCaptureConfig.NONE) {
            return;
        }
        MarkerStatus[] markerStatusArray = new MarkerStatus[]{MarkerStatus.ENDING, MarkerStatus.ENDED};
        if (ArraysKt.contains((Object[])markerStatusArray, (Object)((Object)this.status))) {
            Logger.e("Can't finish HTTPMarker. HTTPMarker was already finished");
            return;
        }
        this.status = MarkerStatus.ENDING;
        this.stopWatch.stop();
        this.headers.putAll(ConstantsAndUtil.INSTANCE.getCapturedResponseHeaders$runtime_release(URLConnectionExtensionsKt.getResponseHeadersMap(connection)));
        String method = connection.getRequestMethod();
        Long encodedResponseSize = HttpURLConnectionExtensionsKt.encodedResponseSizeOrNull(connection);
        Integer n = HttpURLConnectionExtensionsKt.decodedResponseSizeOrNull(connection);
        Long decodedResponseSize = n == null ? null : Long.valueOf(n.intValue());
        Integer responseCode = HttpURLConnectionExtensionsKt.responseCodeOrNull(connection);
        String errorMessage = HttpURLConnectionExtensionsKt.errorMessageOrNull(connection);
        this.sendBeacon(method, responseCode, encodedResponseSize, decodedResponseSize, this.getBackendTraceId(connection), errorMessage, this.headers);
    }

    public final void finish(@NotNull HttpURLConnection connection, @NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        if (this.config.getHttpCaptureConfig() == HTTPCaptureConfig.NONE) {
            return;
        }
        MarkerStatus[] markerStatusArray = new MarkerStatus[]{MarkerStatus.ENDING, MarkerStatus.ENDED};
        if (ArraysKt.contains((Object[])markerStatusArray, (Object)((Object)this.status))) {
            Logger.e("Can't finish HTTPMarker. HTTPMarker was already finished");
            return;
        }
        this.status = MarkerStatus.ENDING;
        this.stopWatch.stop();
        this.headers.putAll(ConstantsAndUtil.INSTANCE.getCapturedRequestHeaders$runtime_release(URLConnectionExtensionsKt.getRequestHeadersMap(connection)));
        String method = connection.getRequestMethod();
        Integer responseCode = HttpURLConnectionExtensionsKt.responseCodeOrNull(connection);
        String errorMessage = error.getMessage();
        this.sendBeacon(method, responseCode, null, null, this.getBackendTraceId(connection), errorMessage, this.headers);
    }

    public final void finish(@NotNull HTTPMarkerData httpMarkerData) {
        Intrinsics.checkNotNullParameter((Object)httpMarkerData, (String)"httpMarkerData");
        if (this.config.getHttpCaptureConfig() == HTTPCaptureConfig.NONE) {
            return;
        }
        MarkerStatus[] markerStatusArray = new MarkerStatus[]{MarkerStatus.ENDING, MarkerStatus.ENDED};
        if (ArraysKt.contains((Object[])markerStatusArray, (Object)((Object)this.status))) {
            Logger.e("Can't finish HTTPMarker. HTTPMarker was already finished");
            return;
        }
        this.status = MarkerStatus.ENDED;
        this.stopWatch.stop();
        Map map = httpMarkerData.getHeaders();
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        this.headers.putAll(ConstantsAndUtil.INSTANCE.getCapturedResponseHeaders$runtime_release(map));
        this.sendBeacon(httpMarkerData.getRequestMethod(), httpMarkerData.getResponseStatusCode(), httpMarkerData.getResponseSizeEncodedBytes(), httpMarkerData.getResponseSizeDecodedBytes(), httpMarkerData.getBackendTraceId(), httpMarkerData.getErrorMessage(), this.headers);
    }

    private final void sendBeacon(String connectionMethod, Integer responseCode, Long encodedResponseSizeBytes, Long decodedResponseSizeBytes, String backendTraceId, String errorMessage, MaxCapacityMap<String, String> headers) {
        if (this.sessionId == null) {
            Logger.e("Tried to end HTTPMarker with null sessionId");
            return;
        }
        this.status = MarkerStatus.ENDED;
        InstrumentationService instrumentationService = Instana.INSTANCE.getInstrumentationService$runtime_release();
        if (instrumentationService != null) {
            instrumentationService.removeTag(this.markerId);
        }
        Beacon.Companion companion = Beacon.Companion;
        String string = this.config.getKey();
        AppProfile appProfile = Instana.INSTANCE.getAppProfile$runtime_release();
        DeviceProfile deviceProfile = Instana.INSTANCE.getDeviceProfile$runtime_release();
        ConnectionProfile connectionProfile = this.connectionProfile;
        UserProfile userProfile = Instana.INSTANCE.getUserProfile$runtime_release();
        String string2 = this.sessionId;
        String string3 = this.viewName;
        Map<String, String> map = Instana.getMeta().getAll();
        long l = this.stopWatch.getTotalTimeMillis();
        String string4 = this.url;
        Map<String, String> map2 = headers.getAll();
        Beacon beacon = companion.newHttpRequest(string, appProfile, deviceProfile, connectionProfile, userProfile, string2, string3, map, l, connectionMethod, string4, map2, backendTraceId, responseCode, null, encodedResponseSizeBytes, decodedResponseSizeBytes, errorMessage);
        Logger.i(Intrinsics.stringPlus((String)"HttpRequest finished with: `url` ", (Object)this.url));
        this.manager.queue(beacon);
    }

    static /* synthetic */ void sendBeacon$default(HTTPMarker hTTPMarker, String string, Integer n, Long l, Long l2, String string2, String string3, MaxCapacityMap maxCapacityMap, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = null;
        }
        if ((n2 & 2) != 0) {
            n = null;
        }
        if ((n2 & 4) != 0) {
            l = null;
        }
        if ((n2 & 8) != 0) {
            l2 = null;
        }
        if ((n2 & 0x10) != 0) {
            string2 = null;
        }
        if ((n2 & 0x20) != 0) {
            string3 = null;
        }
        hTTPMarker.sendBeacon(string, n, l, l2, string2, string3, maxCapacityMap);
    }

    private final String getBackendTraceId(HttpURLConnection connection) {
        String string;
        String string2 = connection.getHeaderField(backendTraceIdHeaderKey);
        if (string2 == null) {
            string = null;
        } else {
            String it = string2;
            boolean bl = false;
            MatchResult matchResult = backendTraceIdParser.matchEntire((CharSequence)it);
            if (matchResult == null) {
                string = null;
            } else {
                List list = matchResult.getGroupValues();
                string = list == null ? null : (String)list.get(1);
            }
        }
        return string;
    }

    private final String getBackendTraceId(Response response) {
        String string;
        String string2 = response.header(backendTraceIdHeaderKey);
        if (string2 == null) {
            string = null;
        } else {
            String it = string2;
            boolean bl = false;
            MatchResult matchResult = backendTraceIdParser.matchEntire((CharSequence)it);
            if (matchResult == null) {
                string = null;
            } else {
                List list = matchResult.getGroupValues();
                string = list == null ? null : (String)list.get(1);
            }
        }
        return string;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object == null ? null : object.getClass())) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.instana.android.instrumentation.HTTPMarker");
        }
        HTTPMarker cfr_ignored_0 = (HTTPMarker)object2;
        return Intrinsics.areEqual((Object)this.markerId, (Object)((HTTPMarker)other).markerId);
    }

    public int hashCode() {
        return this.markerId.hashCode();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/instana/android/instrumentation/HTTPMarker$MarkerStatus;", "", "(Ljava/lang/String;I)V", "STARTED", "ENDING", "ENDED", "runtime_release"})
    private static final class MarkerStatus
    extends Enum<MarkerStatus> {
        public static final /* enum */ MarkerStatus STARTED = new MarkerStatus();
        public static final /* enum */ MarkerStatus ENDING = new MarkerStatus();
        public static final /* enum */ MarkerStatus ENDED = new MarkerStatus();
        private static final /* synthetic */ MarkerStatus[] $VALUES;

        public static MarkerStatus[] values() {
            return (MarkerStatus[])$VALUES.clone();
        }

        public static MarkerStatus valueOf(String value) {
            return Enum.valueOf(MarkerStatus.class, value);
        }

        static {
            $VALUES = markerStatusArray = new MarkerStatus[]{MarkerStatus.STARTED, MarkerStatus.ENDING, MarkerStatus.ENDED};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/instana/android/instrumentation/HTTPMarker$Companion;", "", "()V", "backendTraceIdHeaderKey", "", "backendTraceIdParser", "Lkotlin/text/Regex;", "runtime_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

