/*
 * Decompiled with CFR 0.152.
 */
package com.instana.android.crash;

import android.app.Application;
import android.content.Context;
import android.net.ConnectivityManager;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.instana.android.Instana;
import com.instana.android.core.InstanaConfig;
import com.instana.android.core.InstanaWorkManager;
import com.instana.android.core.event.models.AppProfile;
import com.instana.android.core.event.models.Beacon;
import com.instana.android.core.event.models.ConnectionProfile;
import com.instana.android.core.event.models.DeviceProfile;
import com.instana.android.core.event.models.UserProfile;
import com.instana.android.core.util.ConstantsAndUtil;
import com.instana.android.core.util.MaxCapacityMap;
import com.instana.android.core.util.ThreadUtil;
import com.instana.android.crash.ExceptionHandler;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingDeque;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u001c\u0010\u0015\u001a\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0010J\u001a\u0010\u001d\u001a\u00020\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/instana/android/crash/CrashService;", "", "app", "Landroid/app/Application;", "manager", "Lcom/instana/android/core/InstanaWorkManager;", "config", "Lcom/instana/android/core/InstanaConfig;", "cm", "Landroid/net/ConnectivityManager;", "tm", "Landroid/telephony/TelephonyManager;", "defaultThreadHandler", "Ljava/lang/Thread$UncaughtExceptionHandler;", "(Landroid/app/Application;Lcom/instana/android/core/InstanaWorkManager;Lcom/instana/android/core/InstanaConfig;Landroid/net/ConnectivityManager;Landroid/telephony/TelephonyManager;Ljava/lang/Thread$UncaughtExceptionHandler;)V", "appKey", "", "breadCrumbs", "Ljava/util/Queue;", "handler", "Lcom/instana/android/crash/ExceptionHandler;", "dumpAllThreads", "crashedThread", "Ljava/lang/Thread;", "throwable", "", "leave", "", "breadCrumb", "submitCrash", "thread", "runtime_release"})
public final class CrashService {
    @NotNull
    private final Application app;
    @NotNull
    private final InstanaWorkManager manager;
    @NotNull
    private final InstanaConfig config;
    @NotNull
    private final ConnectivityManager cm;
    @NotNull
    private final TelephonyManager tm;
    @NotNull
    private final String appKey;
    @NotNull
    private Queue<String> breadCrumbs;
    @Nullable
    private ExceptionHandler handler;

    public CrashService(@NotNull Application app, @NotNull InstanaWorkManager manager, @NotNull InstanaConfig config, @NotNull ConnectivityManager cm, @NotNull TelephonyManager tm, @Nullable Thread.UncaughtExceptionHandler defaultThreadHandler) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)cm, (String)"cm");
        Intrinsics.checkNotNullParameter((Object)tm, (String)"tm");
        this.app = app;
        this.manager = manager;
        this.config = config;
        this.cm = cm;
        this.tm = tm;
        this.appKey = this.config.getKey();
        this.breadCrumbs = new LinkedBlockingDeque();
        if (defaultThreadHandler != null) {
            this.handler = new ExceptionHandler(this, defaultThreadHandler);
        }
        if (this.config.getEnableCrashReporting()) {
            ExceptionHandler exceptionHandler = this.handler;
            if (exceptionHandler != null) {
                exceptionHandler.enable();
            }
        } else {
            ExceptionHandler exceptionHandler = this.handler;
            if (exceptionHandler != null) {
                exceptionHandler.disable();
            }
        }
    }

    public /* synthetic */ CrashService(Application application, InstanaWorkManager instanaWorkManager, InstanaConfig instanaConfig, ConnectivityManager connectivityManager, TelephonyManager telephonyManager, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        }
        this(application, instanaWorkManager, instanaConfig, connectivityManager, telephonyManager, uncaughtExceptionHandler);
    }

    public final void leave(@NotNull String breadCrumb) {
        Intrinsics.checkNotNullParameter((Object)breadCrumb, (String)"breadCrumb");
        this.breadCrumbs.add(breadCrumb);
        if (this.breadCrumbs.size() > this.config.getBreadcrumbsBufferSize()) {
            this.breadCrumbs.poll();
        }
    }

    public final void submitCrash(@Nullable Thread thread, @Nullable Throwable throwable) {
        String string;
        String string2;
        String string3 = Log.getStackTraceString((Throwable)throwable);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getStackTraceString(throwable)");
        String stackTrace = string3;
        String allStackTraces = this.dumpAllThreads(thread, throwable);
        MaxCapacityMap<String, String> mergedMeta = Instana.getMeta();
        ConnectionProfile connectionProfile = new ConnectionProfile(ConstantsAndUtil.INSTANCE.getCarrierName((Context)this.app, this.cm, this.tm), ConstantsAndUtil.INSTANCE.getConnectionType((Context)this.app, this.cm), ConstantsAndUtil.INSTANCE.getCellularConnectionType((Context)this.app, this.cm, this.tm));
        Throwable throwable2 = throwable;
        if (throwable2 == null ? false : ((string2 = throwable2.getMessage()) == null ? false : !StringsKt.isBlank((CharSequence)string2))) {
            string = throwable.getClass().getName() + " (" + throwable.getMessage() + ')';
        } else {
            Throwable throwable3 = throwable;
            if (throwable3 == null) {
                string = null;
            } else {
                Class<?> clazz = throwable3.getClass();
                string = clazz == null ? null : clazz.getName();
            }
        }
        String errorMessage = string;
        AppProfile appProfile = Instana.INSTANCE.getAppProfile$runtime_release();
        DeviceProfile deviceProfile = Instana.INSTANCE.getDeviceProfile$runtime_release();
        UserProfile userProfile = Instana.INSTANCE.getUserProfile$runtime_release();
        String string4 = Instana.getSessionId();
        if (string4 == null) {
            string4 = "";
        }
        Beacon beacon = Beacon.Companion.newCrash(this.appKey, appProfile, deviceProfile, connectionProfile, userProfile, string4, null, mergedMeta.getAll(), errorMessage, stackTrace, allStackTraces);
        this.manager.queueAndFlushBlocking(beacon);
        this.breadCrumbs.clear();
    }

    private final String dumpAllThreads(Thread crashedThread, Throwable throwable) {
        StackTraceElement[] stackTraceElementArray;
        Map<Thread, StackTraceElement[]> map;
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        if (!stackTraces.containsKey(crashedThread)) {
            Intrinsics.checkNotNullExpressionValue(stackTraces, (String)"stackTraces");
            map = stackTraces;
            Thread thread = crashedThread;
            stackTraceElementArray = thread == null ? null : thread.getStackTrace();
            map.put(crashedThread, stackTraceElementArray);
        }
        if (throwable != null) {
            Intrinsics.checkNotNullExpressionValue(stackTraces, (String)"stackTraces");
            map = stackTraces;
            stackTraceElementArray = throwable.getStackTrace();
            map.put(crashedThread, stackTraceElementArray);
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Intrinsics.checkNotNullExpressionValue(stackTraces, (String)"stackTraces");
        for (Map.Entry<Thread, StackTraceElement[]> entry : stackTraces.entrySet()) {
            Thread t = entry.getKey();
            StackTraceElement[] u = entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)t, (String)"t");
            Intrinsics.checkNotNullExpressionValue((Object)u, (String)"u");
            ThreadUtil.INSTANCE.println(pw, t, u);
        }
        pw.flush();
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sw.toString()");
        return string;
    }
}

