/*
 * Decompiled with CFR 0.152.
 */
package com.instana.android.core.util;

import android.os.Build;
import com.instana.android.core.util.StreamExtensionsKt;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0011\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u00a2\u0006\u0002\u0010\u0003\u001a\u0011\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u0002\u00a2\u0006\u0002\u0010\u0006\u001a\f\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u0002\u001a\n\u0010\t\u001a\u00020\n*\u00020\u0002\u001a\u0011\u0010\u000b\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\f"}, d2={"decodedResponseSizeOrNull", "", "Ljava/net/HttpURLConnection;", "(Ljava/net/HttpURLConnection;)Ljava/lang/Integer;", "encodedResponseSizeOrNull", "", "(Ljava/net/HttpURLConnection;)Ljava/lang/Long;", "errorMessageOrNull", "", "isSuccessful", "", "responseCodeOrNull", "runtime_release"})
public final class HttpURLConnectionExtensionsKt {
    public static final boolean isSuccessful(@NotNull HttpURLConnection $this$isSuccessful) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$isSuccessful, (String)"<this>");
        try {
            n = $this$isSuccessful.getResponseCode();
            n = 200 <= n ? (n < 300 ? 1 : 0) : 0;
        }
        catch (Exception ignored) {
            n = 0;
        }
        return n != 0;
    }

    @Nullable
    public static final Long encodedResponseSizeOrNull(@NotNull HttpURLConnection $this$encodedResponseSizeOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$encodedResponseSizeOrNull, (String)"<this>");
        Long size = Build.VERSION.SDK_INT >= 24 ? Long.valueOf($this$encodedResponseSizeOrNull.getContentLengthLong()) : Long.valueOf($this$encodedResponseSizeOrNull.getContentLength());
        long l = -1L;
        if (size == l) {
            size = null;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final Integer decodedResponseSizeOrNull(@NotNull HttpURLConnection $this$decodedResponseSizeOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$decodedResponseSizeOrNull, (String)"<this>");
        if (StringsKt.equals((String)"gzip", (String)$this$decodedResponseSizeOrNull.getContentEncoding(), (boolean)true)) {
            try {
                Closeable closeable = $this$decodedResponseSizeOrNull.getInputStream();
                Intrinsics.checkNotNullExpressionValue((Object)closeable, (String)"inputStream");
                closeable = new GZIPInputStream(StreamExtensionsKt.clone(closeable));
                Throwable throwable = null;
                try {
                    GZIPInputStream it = (GZIPInputStream)closeable;
                    boolean bl = false;
                    Integer n = ByteStreamsKt.readBytes((InputStream)it).length;
                    return n;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    public static final Integer responseCodeOrNull(@NotNull HttpURLConnection $this$responseCodeOrNull) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)$this$responseCodeOrNull, (String)"<this>");
        try {
            n = $this$responseCodeOrNull.getResponseCode();
        }
        catch (Exception ignored) {
            n = null;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final String errorMessageOrNull(@NotNull HttpURLConnection $this$errorMessageOrNull) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$errorMessageOrNull, (String)"<this>");
        if (HttpURLConnectionExtensionsKt.isSuccessful($this$errorMessageOrNull)) {
            string = null;
        } else if (HttpURLConnectionExtensionsKt.responseCodeOrNull($this$errorMessageOrNull) == null) {
            String string2;
            try {
                $this$errorMessageOrNull.getResponseCode();
                string2 = null;
            }
            catch (Exception e) {
                string2 = Intrinsics.stringPlus((String)"responseCode - ", (Object)e);
            }
            string = string2;
        } else if (ComparisonsKt.compareValues((Comparable)HttpURLConnectionExtensionsKt.encodedResponseSizeOrNull($this$errorMessageOrNull), (Comparable)Long.valueOf(0L)) > 0) {
            String string3;
            try {
                String string4;
                InputStream inputStream = $this$errorMessageOrNull.getErrorStream();
                if (inputStream == null) {
                    string4 = null;
                } else {
                    Closeable e = inputStream;
                    Throwable throwable = null;
                    try {
                        InputStream it = (InputStream)e;
                        boolean bl = false;
                        String string5 = StreamExtensionsKt.readCopy(it);
                        string4 = string5;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)e, (Throwable)throwable);
                    }
                }
                string3 = string4;
            }
            catch (Exception e) {
                string3 = Intrinsics.stringPlus((String)"errorStream - ", (Object)e);
            }
            string = string3;
        } else {
            string = null;
        }
        return string;
    }
}

