/*
 * Decompiled with CFR 0.152.
 */
package com.instana.android.core.event.worker;

import android.content.Context;
import androidx.work.Constraints;
import androidx.work.CoroutineWorker;
import androidx.work.Data;
import androidx.work.ListenableWorker;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkerParameters;
import com.instana.android.Instana;
import com.instana.android.core.InstanaConfig;
import com.instana.android.core.util.ConstantsAndUtil;
import com.instana.android.core.util.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0007\u001a\u00020\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ*\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2={"Lcom/instana/android/core/event/worker/EventWorker;", "Landroidx/work/CoroutineWorker;", "context", "Landroid/content/Context;", "params", "Landroidx/work/WorkerParameters;", "(Landroid/content/Context;Landroidx/work/WorkerParameters;)V", "doWork", "Landroidx/work/ListenableWorker$Result;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "readAllFiles", "Lkotlin/Pair;", "", "", "Ljava/io/File;", "directory", "limit", "", "send", "", "data", "Companion", "runtime_release"})
public class EventWorker
extends CoroutineWorker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WorkerParameters params;
    private static final int batchLimit = 100;
    @Nullable
    private static final MediaType TEXT_PLAIN = MediaType.parse((String)"text/plain; charset=utf-8");
    @NotNull
    private static final String DIRECTORY_ABS_PATH = "dir_abs_path";

    public EventWorker(@NotNull Context context, @NotNull WorkerParameters params) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        super(context, params);
        this.params = params;
    }

    @Nullable
    public Object doWork(@NotNull Continuation<? super ListenableWorker.Result> $completion) {
        return EventWorker.doWork$suspendImpl(this, $completion);
    }

    static /* synthetic */ Object doWork$suspendImpl(EventWorker this_, Continuation $completion) {
        ListenableWorker.Result result;
        String directoryAbsPath = this_.params.getInputData().getString(DIRECTORY_ABS_PATH);
        CharSequence charSequence = directoryAbsPath;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            Logger.e(Intrinsics.stringPlus((String)"Tried to flush beacons with invalid directory path: ", (Object)directoryAbsPath));
            charSequence = ListenableWorker.Result.failure();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"failure()");
            return charSequence;
        }
        File directory = new File(directoryAbsPath);
        Pair<String, File[]> pair = this_.readAllFiles(directory, 100);
        String data = (String)pair.component1();
        File[] files = (File[])pair.component2();
        if (StringsKt.isBlank((CharSequence)data)) {
            ListenableWorker.Result result2 = ListenableWorker.Result.success();
            Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"success()");
            result = result2;
        } else if (this_.send(data)) {
            ListenableWorker.Result result3;
            File[] $this$forEach$iv = files;
            boolean $i$f$forEach = false;
            for (File element$iv : $this$forEach$iv) {
                File it = element$iv;
                boolean bl = false;
                it.delete();
            }
            Logger.i(Intrinsics.stringPlus((String)"Beacon-batch sent with: `size` ", (Object)Boxing.boxInt((int)files.length)));
            if (files.length == 100) {
                Logger.i("Detected more beacons in queue. Creating a new beacon-batch");
                result3 = ListenableWorker.Result.retry();
            } else {
                result3 = ListenableWorker.Result.success();
            }
            ListenableWorker.Result result4 = result3;
            Intrinsics.checkNotNullExpressionValue((Object)result4, (String)"{\n                files.\u2026          }\n            }");
            result = result4;
        } else {
            ListenableWorker.Result result5 = ListenableWorker.Result.retry();
            Intrinsics.checkNotNullExpressionValue((Object)result5, (String)"retry()");
            result = result5;
        }
        return result;
    }

    private final Pair<String, File[]> readAllFiles(File directory, int limit) {
        Object[] objectArray;
        Object[] objectArray2 = directory.listFiles();
        if (objectArray2 == null) {
            boolean $i$f$emptyArray = false;
            objectArray = new File[]{};
        } else {
            objectArray = objectArray2;
        }
        Object[] files = objectArray;
        StringBuffer sb = new StringBuffer();
        Iterable $this$forEach$iv = ArraysKt.take((Object[])files, (int)limit);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            sb.append(Intrinsics.stringPlus((String)FilesKt.readText((File)it, (Charset)Charsets.UTF_8), (Object)"\n"));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return TuplesKt.to((Object)string, (Object)files);
    }

    private final boolean send(String data) {
        boolean bl;
        String reportingURL;
        InstanaConfig instanaConfig = Instana.getConfig();
        String string = reportingURL = instanaConfig == null ? null : instanaConfig.getReportingURL();
        if (reportingURL == null) {
            Logger.w("Instana hasn't been initialized. Dropping beacon.");
            return true;
        }
        try {
            RequestBody requestBody = RequestBody.create((MediaType)TEXT_PLAIN, (String)data);
            Request request = new Request.Builder().url(reportingURL).addHeader("Content-Type", "application/json").addHeader("Accept-Encoding", "gzip").post(requestBody).build();
            Response response = ConstantsAndUtil.INSTANCE.getClient().newCall(request).execute();
            if (!response.isSuccessful()) {
                if (response.code() == 400) {
                    Logger.e("Failed to flush beacons to Instana with: Unknown key. reportingURL '" + reportingURL + "', errorMessage '" + response.message() + '\'');
                    return true;
                }
                Logger.e("Failed to flush beacons to Instana with: reportingURL '" + reportingURL + "', responseCode '" + response.code() + "', errorMessage '" + response.message() + '\'');
            }
            bl = response.isSuccessful();
        }
        catch (IOException e) {
            Logger.e("Failed to flush beacons to Instana", e);
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/instana/android/core/event/worker/EventWorker$Companion;", "", "()V", "DIRECTORY_ABS_PATH", "", "TEXT_PLAIN", "Lokhttp3/MediaType;", "batchLimit", "", "createWorkRequest", "Landroidx/work/OneTimeWorkRequest;", "constraints", "Landroidx/work/Constraints;", "directory", "Ljava/io/File;", "initialDelayMs", "", "tag", "runtime_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OneTimeWorkRequest createWorkRequest(@NotNull Constraints constraints, @NotNull File directory, long initialDelayMs, @NotNull String tag) {
            Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Data data = new Data.Builder().putString(EventWorker.DIRECTORY_ABS_PATH, directory.getAbsolutePath()).build();
            Intrinsics.checkNotNullExpressionValue((Object)data, (String)"Builder()\n              \u2026\n                .build()");
            Data data2 = data;
            data = ((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(EventWorker.class).setInputData(data2)).setConstraints(constraints)).setInitialDelay(initialDelayMs, TimeUnit.MILLISECONDS)).addTag(tag)).build();
            Intrinsics.checkNotNullExpressionValue((Object)data, (String)"Builder(EventWorker::cla\u2026\n                .build()");
            return (OneTimeWorkRequest)data;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

