/*
 * Decompiled with CFR 0.152.
 */
package com.instana.android.core.event;

import android.content.Context;
import android.net.ConnectivityManager;
import android.telephony.TelephonyManager;
import com.instana.android.Instana;
import com.instana.android.core.InstanaConfig;
import com.instana.android.core.InstanaWorkManager;
import com.instana.android.core.event.models.AppProfile;
import com.instana.android.core.event.models.Beacon;
import com.instana.android.core.event.models.ConnectionProfile;
import com.instana.android.core.event.models.DeviceProfile;
import com.instana.android.core.event.models.UserProfile;
import com.instana.android.core.util.ConstantsAndUtil;
import com.instana.android.core.util.Logger;
import com.instana.android.core.util.MaxCapacityMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJP\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/instana/android/core/event/CustomEventService;", "", "context", "Landroid/content/Context;", "manager", "Lcom/instana/android/core/InstanaWorkManager;", "cm", "Landroid/net/ConnectivityManager;", "tm", "Landroid/telephony/TelephonyManager;", "config", "Lcom/instana/android/core/InstanaConfig;", "(Landroid/content/Context;Lcom/instana/android/core/InstanaWorkManager;Landroid/net/ConnectivityManager;Landroid/telephony/TelephonyManager;Lcom/instana/android/core/InstanaConfig;)V", "appKey", "", "submit", "", "eventName", "startTime", "", "duration", "meta", "", "viewName", "backendTracingID", "error", "", "runtime_release"})
public final class CustomEventService {
    @NotNull
    private final Context context;
    @NotNull
    private final InstanaWorkManager manager;
    @NotNull
    private final ConnectivityManager cm;
    @NotNull
    private final TelephonyManager tm;
    @NotNull
    private final String appKey;

    public CustomEventService(@NotNull Context context, @NotNull InstanaWorkManager manager, @NotNull ConnectivityManager cm, @NotNull TelephonyManager tm, @NotNull InstanaConfig config) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)cm, (String)"cm");
        Intrinsics.checkNotNullParameter((Object)tm, (String)"tm");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.context = context;
        this.manager = manager;
        this.cm = cm;
        this.tm = tm;
        this.appKey = config.getKey();
    }

    public final void submit(@NotNull String eventName, long startTime, long duration, @NotNull Map<String, String> meta, @Nullable String viewName, @Nullable String backendTracingID, @Nullable Throwable error) {
        MaxCapacityMap<String, String> maxCapacityMap;
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        String sessionId = Instana.getSessionId();
        if (sessionId == null) {
            Logger.e("Tried send CustomEvent with null sessionId");
            return;
        }
        MaxCapacityMap<String, String> $this$submit_u24lambda_u2d0 = maxCapacityMap = Instana.getMeta().clone();
        boolean bl = false;
        $this$submit_u24lambda_u2d0.putAll(meta);
        MaxCapacityMap<String, String> mergedMeta = maxCapacityMap;
        ConnectionProfile connectionProfile = new ConnectionProfile(ConstantsAndUtil.INSTANCE.getCarrierName(this.context, this.cm, this.tm), ConstantsAndUtil.INSTANCE.getConnectionType(this.context, this.cm), ConstantsAndUtil.INSTANCE.getCellularConnectionType(this.context, this.cm, this.tm));
        Throwable throwable = error;
        String errorMessage = throwable == null ? null : throwable.getMessage();
        Beacon.Companion companion = Beacon.Companion;
        String string = this.appKey;
        AppProfile appProfile = Instana.INSTANCE.getAppProfile$runtime_release();
        DeviceProfile deviceProfile = Instana.INSTANCE.getDeviceProfile$runtime_release();
        UserProfile userProfile = Instana.INSTANCE.getUserProfile$runtime_release();
        Map<String, String> map = mergedMeta.getAll();
        Beacon beacon = companion.newCustomEvent(string, appProfile, deviceProfile, connectionProfile, userProfile, sessionId, viewName, map, startTime, duration, backendTracingID, errorMessage, eventName);
        this.manager.queue(beacon);
    }
}

