/*
 * Decompiled with CFR 0.152.
 */
package com.instana.android.core;

import android.content.Context;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.work.Configuration;
import androidx.work.Constraints;
import androidx.work.ExistingWorkPolicy;
import androidx.work.NetworkType;
import androidx.work.Operation;
import androidx.work.WorkManager;
import com.instana.android.Instana;
import com.instana.android.core.InstanaConfig;
import com.instana.android.core.SuspendReportingType;
import com.instana.android.core.event.models.Beacon;
import com.instana.android.core.event.worker.EventWorker;
import com.instana.android.core.util.Debouncer;
import com.instana.android.core.util.FileExtensionsKt;
import com.instana.android.core.util.Logger;
import com.instana.android.core.util.RateLimiter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u0003H\u0002J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010)\u001a\u00020*2\u0006\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020(H\u0002J\b\u0010+\u001a\u00020\bH\u0002J\u000f\u0010,\u001a\u0004\u0018\u00010(H\u0001\u00a2\u0006\u0002\b-J\u000e\u0010.\u001a\u00020%2\u0006\u0010/\u001a\u00020\u0013J\u000e\u00100\u001a\u00020%2\u0006\u0010/\u001a\u00020\u0013J\u0016\u00101\u001a\u00020%2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/instana/android/core/InstanaWorkManager;", "", "config", "Lcom/instana/android/core/InstanaConfig;", "context", "Landroid/content/Context;", "(Lcom/instana/android/core/InstanaConfig;Landroid/content/Context;)V", "beaconsDirectory", "Ljava/io/File;", "beaconsDirectoryName", "", "constraints", "Landroidx/work/Constraints;", "flushDebouncer", "Lcom/instana/android/core/util/Debouncer;", "flushDelayMs", "", "initialDelayQueue", "Ljava/util/Queue;", "Lcom/instana/android/core/event/models/Beacon;", "getInitialDelayQueue$runtime_release", "()Ljava/util/Queue;", "setInitialDelayQueue$runtime_release", "(Ljava/util/Queue;)V", "initialExecutorFuture", "Ljava/util/concurrent/ScheduledFuture;", "isInitialDelayComplete", "", "isInitialDelayComplete$runtime_release", "()Z", "setInitialDelayComplete$runtime_release", "(Z)V", "rateLimiter", "Lcom/instana/android/core/util/RateLimiter;", "configureWorkManager", "instanaConfig", "flush", "", "directory", "manager", "Landroidx/work/WorkManager;", "flushInternal", "Landroidx/work/Operation;", "getBeaconsDirectory", "getWorkManager", "getWorkManager$runtime_release", "queue", "beacon", "queueAndFlushBlocking", "updateQueueItems", "runtime_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class InstanaWorkManager {
    @NotNull
    private final Context context;
    @NotNull
    private final String beaconsDirectoryName;
    private final long flushDelayMs;
    @NotNull
    private final RateLimiter rateLimiter;
    @NotNull
    private final Debouncer flushDebouncer;
    @NotNull
    private final Constraints constraints;
    @Nullable
    private File beaconsDirectory;
    @NotNull
    private Queue<Beacon> initialDelayQueue;
    private boolean isInitialDelayComplete;
    @NotNull
    private final ScheduledFuture<?> initialExecutorFuture;

    public InstanaWorkManager(@NotNull InstanaConfig config, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.beaconsDirectoryName = "instanaBeacons";
        this.flushDelayMs = 1000L;
        this.rateLimiter = new RateLimiter(128, 32);
        this.flushDebouncer = new Debouncer(2000L);
        this.initialDelayQueue = new LinkedBlockingDeque();
        this.constraints = this.configureWorkManager(config);
        ScheduledFuture<?> scheduledFuture = Executors.newScheduledThreadPool(1).schedule(() -> InstanaWorkManager._init_$lambda-1(this), config.getInitialBeaconDelayMs(), TimeUnit.MILLISECONDS);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture, (String)"newScheduledThreadPool(1\u2026s, TimeUnit.MILLISECONDS)");
        this.initialExecutorFuture = scheduledFuture;
    }

    @NotNull
    public final Queue<Beacon> getInitialDelayQueue$runtime_release() {
        return this.initialDelayQueue;
    }

    public final void setInitialDelayQueue$runtime_release(@NotNull Queue<Beacon> queue2) {
        Intrinsics.checkNotNullParameter(queue2, (String)"<set-?>");
        this.initialDelayQueue = queue2;
    }

    public final boolean isInitialDelayComplete$runtime_release() {
        return this.isInitialDelayComplete;
    }

    public final void setInitialDelayComplete$runtime_release(boolean bl) {
        this.isInitialDelayComplete = bl;
    }

    private final void updateQueueItems(Queue<Beacon> queue2) {
        Logger.d("Updating " + queue2.size() + " queue items");
        for (Beacon item : queue2) {
            Logger.d(Intrinsics.stringPlus((String)"Updating queue item with: `beaconId` ", (Object)item.getBeaconId()));
            if (Instana.INSTANCE.getUserProfile$runtime_release().getUserName() != null) {
                String $this$updateQueueItems_u24lambda_u2d2;
                boolean bl = false;
                item.setUserName($this$updateQueueItems_u24lambda_u2d2);
            }
            if (Instana.INSTANCE.getUserProfile$runtime_release().getUserId() != null) {
                String $this$updateQueueItems_u24lambda_u2d3;
                boolean bl = false;
                item.setUserId($this$updateQueueItems_u24lambda_u2d3);
            }
            if (Instana.INSTANCE.getUserProfile$runtime_release().getUserEmail() != null) {
                String $this$updateQueueItems_u24lambda_u2d4;
                boolean bl = false;
                item.setUserEmail($this$updateQueueItems_u24lambda_u2d4);
            }
            if (item.getView() == null && Instana.INSTANCE.getFirstView$runtime_release() != null) {
                String $this$updateQueueItems_u24lambda_u2d5;
                boolean bl = false;
                item.setView($this$updateQueueItems_u24lambda_u2d5);
            }
            if (item.getRooted() == null) {
                Boolean bl = Instana.INSTANCE.getDeviceProfile$runtime_release().getRooted();
                if (bl != null) {
                    boolean $this$updateQueueItems_u24lambda_u2d6 = bl;
                    boolean bl2 = false;
                    item.setRooted($this$updateQueueItems_u24lambda_u2d6);
                }
            }
            if (item.getGooglePlayServicesMissing() == null) {
                Boolean bl = Instana.getGooglePlayServicesMissing();
                if (bl != null) {
                    boolean $this$updateQueueItems_u24lambda_u2d7 = bl;
                    boolean bl3 = false;
                    item.setGooglePlayServicesMissing($this$updateQueueItems_u24lambda_u2d7);
                }
            }
            for (Map.Entry<String, String> it : Instana.getMeta().getAll().entrySet()) {
                if (item.getMeta(it.getKey()) != null) continue;
                item.setMeta(it.getKey(), it.getValue());
            }
        }
    }

    private final File getBeaconsDirectory() {
        File directory = this.beaconsDirectory;
        if (directory == null) {
            File file;
            File $this$getBeaconsDirectory_u24lambda_u2d8 = file = new File(this.context.getFilesDir(), this.beaconsDirectoryName);
            boolean bl = false;
            $this$getBeaconsDirectory_u24lambda_u2d8.mkdirs();
            this.beaconsDirectory = directory = file;
        }
        return directory;
    }

    @VisibleForTesting
    @Nullable
    public final WorkManager getWorkManager$runtime_release() {
        try {
            return WorkManager.getInstance((Context)this.context);
        }
        catch (IllegalStateException e) {
            Logger.e("WorkManager has not been properly initialized. Please check your code and your dependencies for similar issues", e);
            Logger.e("Instana Agent will now try to initialize WorkManager with the default configuration");
            Configuration configuration = new Configuration.Builder().build();
            Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"Builder()\n            .build()");
            Configuration config = configuration;
            try {
                WorkManager.initialize((Context)this.context, (Configuration)config);
                configuration = WorkManager.getInstance((Context)this.context);
            }
            catch (Throwable e2) {
                Logger.e("Instana Agent failed to initialize WorkManager. Beacons will not be sent until the issue is solved", e2);
                configuration = null;
            }
            return configuration;
        }
    }

    private final Constraints configureWorkManager(InstanaConfig instanaConfig) {
        NetworkType networkType = null;
        boolean lowBattery = false;
        switch (WhenMappings.$EnumSwitchMapping$0[instanaConfig.getSuspendReporting().ordinal()]) {
            case 1: {
                networkType = NetworkType.CONNECTED;
                lowBattery = false;
                break;
            }
            case 2: {
                networkType = NetworkType.CONNECTED;
                lowBattery = true;
                break;
            }
            case 3: {
                networkType = NetworkType.UNMETERED;
                lowBattery = false;
                break;
            }
            case 4: {
                networkType = NetworkType.UNMETERED;
                lowBattery = true;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Constraints constraints = new Constraints.Builder().setRequiredNetworkType(networkType).setRequiresBatteryNotLow(lowBattery).setRequiresCharging(false).build();
        Intrinsics.checkNotNullExpressionValue((Object)constraints, (String)"Builder()\n            .s\u2026lse)\n            .build()");
        return constraints;
    }

    private final void flush(File directory, WorkManager manager) {
        Logger.i("Scheduling beacons for flushing");
        if (FileExtensionsKt.isDirectoryEmpty(directory)) {
            return;
        }
        this.flushDebouncer.enqueue((Function0<Unit>)((Function0)new Function0<Unit>(this, directory, manager){
            final /* synthetic */ InstanaWorkManager this$0;
            final /* synthetic */ File $directory;
            final /* synthetic */ WorkManager $manager;
            {
                this.this$0 = $receiver;
                this.$directory = $directory;
                this.$manager = $manager;
                super(0);
            }

            public final void invoke() {
                InstanaWorkManager.access$flushInternal(this.this$0, this.$directory, this.$manager);
            }
        }));
    }

    private final Operation flushInternal(File directory, WorkManager manager) {
        String tag = directory.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)tag, (String)"tag");
        Operation operation = manager.enqueueUniqueWork(tag, ExistingWorkPolicy.REPLACE, EventWorker.Companion.createWorkRequest(this.constraints, directory, this.flushDelayMs, tag));
        Intrinsics.checkNotNullExpressionValue((Object)operation, (String)"manager.enqueueUniqueWor\u2026g\n            )\n        )");
        return operation;
    }

    public final synchronized void queue(@NotNull Beacon beacon) {
        Intrinsics.checkNotNullParameter((Object)beacon, (String)"beacon");
        String beaconId = beacon.getBeaconId();
        Logger.d(Intrinsics.stringPlus((String)"Queueing beacon with: `beaconId` ", (Object)beaconId));
        if (!this.isInitialDelayComplete) {
            this.initialDelayQueue.add(beacon);
        } else {
            CharSequence charSequence = beaconId;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                Logger.e(Intrinsics.stringPlus((String)"Tried to queue beacon with no beaconId: ", (Object)beacon));
            } else if (this.rateLimiter.isRateExceeded(1)) {
                Logger.e(Intrinsics.stringPlus((String)"Max beacon-generation rate exceeded. Dropping beacon: ", (Object)beacon));
            } else {
                BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, beaconId, beacon, null){
                    int label;
                    final /* synthetic */ InstanaWorkManager this$0;
                    final /* synthetic */ String $beaconId;
                    final /* synthetic */ Beacon $beacon;
                    {
                        this.this$0 = $receiver;
                        this.$beaconId = $beaconId;
                        this.$beacon = $beacon;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$beaconId, this.$beacon, null){
                                    int label;
                                    final /* synthetic */ InstanaWorkManager this$0;
                                    final /* synthetic */ String $beaconId;
                                    final /* synthetic */ Beacon $beacon;
                                    {
                                        this.this$0 = $receiver;
                                        this.$beaconId = $beaconId;
                                        this.$beacon = $beacon;
                                        super(2, $completion);
                                    }

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                try {
                                                    File file = new File(InstanaWorkManager.access$getBeaconsDirectory(this.this$0), this.$beaconId);
                                                    FilesKt.writeText((File)file, (String)this.$beacon.toString(), (Charset)Charsets.UTF_8);
                                                    WorkManager workManager = this.this$0.getWorkManager$runtime_release();
                                                    if (workManager != null) {
                                                        WorkManager workManager2 = workManager;
                                                        InstanaWorkManager instanaWorkManager = this.this$0;
                                                        WorkManager $this$invokeSuspend_u24lambda_u2d0 = workManager2;
                                                        boolean bl = false;
                                                        InstanaWorkManager.access$flush(instanaWorkManager, InstanaWorkManager.access$getBeaconsDirectory(instanaWorkManager), $this$invokeSuspend_u24lambda_u2d0);
                                                    }
                                                }
                                                catch (IOException e) {
                                                    Logger.e(Intrinsics.stringPlus((String)"Failed to persist beacon in file-system. Dropping beacon: ", (Object)this.$beacon), e);
                                                }
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        }
    }

    public final synchronized void queueAndFlushBlocking(@NotNull Beacon beacon) {
        Intrinsics.checkNotNullParameter((Object)beacon, (String)"beacon");
        String beaconId = beacon.getBeaconId();
        Logger.d(Intrinsics.stringPlus((String)"Blocking Queue beacon with: `beaconId` ", (Object)beaconId));
        CharSequence charSequence = beaconId;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            Logger.e(Intrinsics.stringPlus((String)"Tried to queue beacon with no beaconId: ", (Object)beacon));
            return;
        }
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Object>, Object>(this, beaconId, beacon, null){
            int label;
            final /* synthetic */ InstanaWorkManager this$0;
            final /* synthetic */ String $beaconId;
            final /* synthetic */ Beacon $beacon;
            {
                this.this$0 = $receiver;
                this.$beaconId = $beaconId;
                this.$beacon = $beacon;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Object>, Object>(this.this$0, this.$beaconId, this.$beacon, null){
                            int label;
                            final /* synthetic */ InstanaWorkManager this$0;
                            final /* synthetic */ String $beaconId;
                            final /* synthetic */ Beacon $beacon;
                            {
                                this.this$0 = $receiver;
                                this.$beaconId = $beaconId;
                                this.$beacon = $beacon;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        Unit unit;
                                        ResultKt.throwOnFailure((Object)object);
                                        try {
                                            File file = new File(InstanaWorkManager.access$getBeaconsDirectory(this.this$0), this.$beaconId);
                                            FilesKt.writeText((File)file, (String)this.$beacon.toString(), (Charset)Charsets.UTF_8);
                                        }
                                        catch (IOException e) {
                                            Logger.e(Intrinsics.stringPlus((String)"Failed to persist beacon in file-system. Dropping beacon: ", (Object)this.$beacon), e);
                                        }
                                        try {
                                            if (!InstanaWorkManager.access$getInitialExecutorFuture$p(this.this$0).isDone()) {
                                                InstanaWorkManager.access$getInitialExecutorFuture$p(this.this$0).get();
                                            }
                                        }
                                        catch (IOException e) {
                                            Logger.e("Failed to flush initial beacons", e);
                                        }
                                        try {
                                            Operation.State.SUCCESS sUCCESS;
                                            WorkManager workManager = this.this$0.getWorkManager$runtime_release();
                                            if (workManager == null) {
                                                sUCCESS = null;
                                            } else {
                                                WorkManager workManager2 = workManager;
                                                InstanaWorkManager instanaWorkManager = this.this$0;
                                                WorkManager $this$invokeSuspend_u24lambda_u2d0 = workManager2;
                                                boolean bl = false;
                                                Logger.i("Enqueue beacon flushing task");
                                                sUCCESS = (Operation.State.SUCCESS)InstanaWorkManager.access$flushInternal(instanaWorkManager, InstanaWorkManager.access$getBeaconsDirectory(instanaWorkManager), $this$invokeSuspend_u24lambda_u2d0).getResult().get(1500L, TimeUnit.MILLISECONDS);
                                            }
                                            unit = sUCCESS;
                                        }
                                        catch (IOException e) {
                                            Logger.e("Failed to enqueue flushing task", e);
                                            unit = Unit.INSTANCE;
                                        }
                                        return unit;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<Object> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<Object> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private static final void _init_$lambda-1(InstanaWorkManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.isInitialDelayComplete = true;
        this$0.updateQueueItems(this$0.initialDelayQueue);
        for (Beacon it : this$0.initialDelayQueue) {
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this$0.queue(it);
        }
        WorkManager workManager = this$0.getWorkManager$runtime_release();
        if (workManager != null) {
            WorkManager $this$lambda_u2d1_u24lambda_u2d0 = workManager;
            boolean bl = false;
            this$0.flush(this$0.getBeaconsDirectory(), $this$lambda_u2d1_u24lambda_u2d0);
        }
    }

    public static final /* synthetic */ Operation access$flushInternal(InstanaWorkManager $this, File directory, WorkManager manager) {
        return $this.flushInternal(directory, manager);
    }

    public static final /* synthetic */ File access$getBeaconsDirectory(InstanaWorkManager $this) {
        return $this.getBeaconsDirectory();
    }

    public static final /* synthetic */ void access$flush(InstanaWorkManager $this, File directory, WorkManager manager) {
        $this.flush(directory, manager);
    }

    public static final /* synthetic */ ScheduledFuture access$getInitialExecutorFuture$p(InstanaWorkManager $this) {
        return $this.initialExecutorFuture;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SuspendReportingType.values().length];
            nArray[SuspendReportingType.NEVER.ordinal()] = 1;
            nArray[SuspendReportingType.LOW_BATTERY.ordinal()] = 2;
            nArray[SuspendReportingType.CELLULAR_CONNECTION.ordinal()] = 3;
            nArray[SuspendReportingType.LOW_BATTERY_OR_CELLULAR_CONNECTION.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

