/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.featuresrequest.cache;

import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.instabug.featuresrequest.models.FeatureRequest;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.ArrayList;
import java.util.List;

public class NewFeatureRequestsCacheManager {
    public static final String NEW_FEATURES_DISK_CACHE_FILE_NAME = "/new_feature_requests.cache";
    public static final String NEW_FEATURES_DISK_CACHE_KEY = "new_feature_requests_disk_cache";
    public static final String NEW_FEATURES_MEMORY_CACHE_KEY = "new_feature_requests._memory_cache";

    @Nullable
    public static InMemoryCache<Long, FeatureRequest> getCache() throws IllegalArgumentException {
        if (!CacheManager.getInstance().cacheExists(NEW_FEATURES_MEMORY_CACHE_KEY)) {
            InstabugSDKLogger.d(NewFeatureRequestsCacheManager.class, (String)("In-memory new_feature_requests cache not found, loading it from disk " + CacheManager.getInstance().getCache(NEW_FEATURES_MEMORY_CACHE_KEY)));
            CacheManager.getInstance().migrateCache(NEW_FEATURES_DISK_CACHE_KEY, NEW_FEATURES_MEMORY_CACHE_KEY, (CacheManager.KeyExtractor)new CacheManager.KeyExtractor<Long, FeatureRequest>(){

                public Long a(FeatureRequest featureRequest) {
                    return featureRequest.getFeatureId();
                }

                public /* synthetic */ Object extractKey(Object object) {
                    return this.a((FeatureRequest)object);
                }
            });
            Cache cache = CacheManager.getInstance().getCache(NEW_FEATURES_MEMORY_CACHE_KEY);
            if (cache != null) {
                InstabugSDKLogger.d(NewFeatureRequestsCacheManager.class, (String)("In-memory new_feature_requests cache restored from disk, " + cache.getValues().size() + " elements restored"));
            }
        }
        InstabugSDKLogger.d(NewFeatureRequestsCacheManager.class, (String)"In-memory new_feature_requests cache found");
        return (InMemoryCache)CacheManager.getInstance().getCache(NEW_FEATURES_MEMORY_CACHE_KEY);
    }

    @VisibleForTesting
    static void tearDown() {
        CacheManager.getInstance().deleteCache(NEW_FEATURES_MEMORY_CACHE_KEY);
        CacheManager.getInstance().deleteCache(NEW_FEATURES_DISK_CACHE_KEY);
    }

    public static void saveCacheToDisk() {
        final Cache cache = CacheManager.getInstance().getCache(NEW_FEATURES_MEMORY_CACHE_KEY);
        final Cache cache2 = CacheManager.getInstance().getCache(NEW_FEATURES_DISK_CACHE_KEY);
        if (cache != null && cache2 != null) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    CacheManager.getInstance().migrateCache(cache, cache2, (CacheManager.KeyExtractor)new CacheManager.KeyExtractor<String, FeatureRequest>(){

                        public String a(FeatureRequest featureRequest) {
                            return String.valueOf(featureRequest.getFeatureId());
                        }

                        public /* synthetic */ Object extractKey(Object object) {
                            return this.a((FeatureRequest)object);
                        }
                    });
                }
            });
            thread.start();
        }
    }

    public static void addNewFeatureRequest(FeatureRequest featureRequest) {
        InMemoryCache<Long, FeatureRequest> inMemoryCache = NewFeatureRequestsCacheManager.getCache();
        if (inMemoryCache != null) {
            inMemoryCache.put((Object)featureRequest.getFeatureId(), (Object)featureRequest);
        }
    }

    @Nullable
    public static FeatureRequest getNewFeatureRequest(long l) {
        InMemoryCache<Long, FeatureRequest> inMemoryCache = NewFeatureRequestsCacheManager.getCache();
        if (inMemoryCache != null) {
            return (FeatureRequest)inMemoryCache.get((Object)l);
        }
        return null;
    }

    @Nullable
    public static FeatureRequest deleteNewFeatureRequest(FeatureRequest featureRequest) {
        InMemoryCache<Long, FeatureRequest> inMemoryCache = NewFeatureRequestsCacheManager.getCache();
        if (inMemoryCache != null) {
            return (FeatureRequest)inMemoryCache.delete((Object)featureRequest.getFeatureId());
        }
        return null;
    }

    public static List<FeatureRequest> getNewFeatureRequests() {
        InMemoryCache<Long, FeatureRequest> inMemoryCache = NewFeatureRequestsCacheManager.getCache();
        if (inMemoryCache != null) {
            return inMemoryCache.getValues();
        }
        return new ArrayList<FeatureRequest>();
    }
}

