/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.featuresrequest.ui.featuresmain;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.google.android.material.tabs.TabLayout;
import com.instabug.featuresrequest.R;
import com.instabug.featuresrequest.listeners.OnSortActionChangedListener;
import com.instabug.featuresrequest.listeners.OnTapSelectedListener;
import com.instabug.featuresrequest.settings.FeaturesRequestSettings;
import com.instabug.featuresrequest.ui.custom.DynamicToolbarFragment;
import com.instabug.featuresrequest.ui.custom.ToolbarActionButton;
import com.instabug.featuresrequest.ui.featuresmain.FeaturesMainContract$View;
import com.instabug.featuresrequest.ui.featuresmain.FeaturesMainPresenter;
import com.instabug.featuresrequest.ui.featuresmain.FeaturesMainViewPagerAdapter;
import com.instabug.featuresrequest.ui.featuresmain.SortingSpinnerAdapter;
import com.instabug.featuresrequest.ui.featuresmain.mainallfeatures.MainAllFeaturesFragment;
import com.instabug.featuresrequest.ui.featuresmain.mainmyfeatures.MainMyFeaturesFragment;
import com.instabug.featuresrequest.ui.newfeature.AddNewFeatureFragment;
import com.instabug.featuresrequest.utils.StringsUtils;
import com.instabug.featuresrequest.utils.ViewUtilsKt;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.PlaceHolderUtils;
import com.instabug.library.util.UiUtils;
import java.util.ArrayList;
import java.util.Iterator;

@SuppressLint(value={"ERADICATE_FIELD_NOT_INITIALIZED"})
public class FeaturesMainFragment
extends DynamicToolbarFragment<FeaturesMainPresenter>
implements FeaturesMainContract$View,
View.OnClickListener,
OnTapSelectedListener {
    @Nullable
    TabLayout tabLayout;
    private FeaturesMainViewPagerAdapter featuresMainPagerAdapter;
    @Nullable
    private LinearLayout tabsContainer;
    @Nullable
    private ViewPager mViewPager;
    protected Boolean sortByTopVotedFeatures = Boolean.FALSE;
    private int mSortByAction = 1;
    private ArrayList<OnSortActionChangedListener> onSortActionChangedListeners;
    private MainAllFeaturesFragment mainAllFeaturesFragment;
    private MainMyFeaturesFragment mainMyFeaturesFragment;

    private void initSortingViews() {
        SortingSpinnerAdapter sortingSpinnerAdapter;
        ArrayList<String> arrayList;
        ContextThemeWrapper contextThemeWrapper;
        if (this.getContext() == null) {
            return;
        }
        FeaturesMainFragment featuresMainFragment = this;
        FrameLayout frameLayout = (FrameLayout)featuresMainFragment.findViewById(R.id.sortingActionsLayoutRoot);
        Spinner spinner = (Spinner)featuresMainFragment.findViewById(R.id.spinnerSortActions);
        if (Instabug.getTheme() == InstabugColorTheme.InstabugColorThemeLight) {
            ContextThemeWrapper contextThemeWrapper2;
            contextThemeWrapper = contextThemeWrapper2;
            contextThemeWrapper2 = new ContextThemeWrapper(this.getContext(), R.style.InstabugSdkTheme_Light);
        } else {
            ContextThemeWrapper contextThemeWrapper3;
            contextThemeWrapper = contextThemeWrapper3;
            contextThemeWrapper3 = new ContextThemeWrapper(this.getContext(), R.style.InstabugSdkTheme_Dark);
        }
        Spinner spinner2 = spinner;
        UiUtils.avoidDropdownFocus((Spinner)spinner2);
        ArrayList<String> arrayList2 = arrayList;
        arrayList2();
        arrayList2.add(StringsUtils.trimSortingStrings(this.getLocalizedString(R.string.sort_by_top_rated)));
        arrayList.add(StringsUtils.trimSortingStrings(this.getLocalizedString(R.string.sort_by_recently_updated)));
        final SortingSpinnerAdapter sortingSpinnerAdapter2 = sortingSpinnerAdapter;
        spinner2.setAdapter((SpinnerAdapter)new SortingSpinnerAdapter((Context)contextThemeWrapper, R.layout.sorting_spinner_item, R.layout.sorting_spinner_drop_down_item, arrayList2));
        spinner2.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> object, View object2, int n, long l) {
                1 v0 = this;
                v0.sortingSpinnerAdapter2.setSelectedPosition(n);
                object = v0.FeaturesMainFragment.this;
                object2 = n == 0;
                1 v1 = this;
                object.sortByTopVotedFeatures = object2;
                FeaturesMainFragment.access$002(v1.FeaturesMainFragment.this, n);
                FeaturesRequestSettings.setLastSortByAction(v1.FeaturesMainFragment.this.mSortByAction);
                FeaturesMainFragment featuresMainFragment = v1.FeaturesMainFragment.this;
                featuresMainFragment.publishSortEvent(featuresMainFragment.sortByTopVotedFeatures);
            }

            public void onNothingSelected(AdapterView<?> adapterView) {
            }
        });
        if (this.sortByTopVotedFeatures.booleanValue()) {
            spinner.setSelection(0);
        } else {
            spinner.setSelection(1);
        }
        if (frameLayout != null) {
            frameLayout.setOnClickListener((View.OnClickListener)this);
        }
        if (this.sortByTopVotedFeatures.booleanValue()) {
            spinner.setSelection(0);
        } else {
            spinner.setSelection(1);
        }
    }

    private void initTabs() {
        TabLayout tabLayout = (TabLayout)this.findViewById(R.id.tab_layout);
        FeaturesMainFragment featuresMainFragment = this;
        LinearLayout linearLayout = (LinearLayout)featuresMainFragment.findViewById(R.id.tabsContainer);
        final ViewPager viewPager = (ViewPager)featuresMainFragment.findViewById(R.id.pager);
        if (tabLayout != null && linearLayout != null && viewPager != null) {
            if (Build.VERSION.SDK_INT > 34) {
                ViewUtilsKt.addSystemWindowInsetToPadding((View)linearLayout, true, false, true, false);
            }
            TabLayout tabLayout2 = tabLayout;
            ViewPager viewPager2 = viewPager;
            TabLayout tabLayout3 = tabLayout;
            tabLayout3.addTab(tabLayout3.newTab().setText((CharSequence)this.getLocalizedString(R.string.features_rq_main_fragment_tab1)));
            tabLayout3.addTab(tabLayout3.newTab().setText((CharSequence)this.getLocalizedString(R.string.features_rq_main_fragment_tab2)));
            tabLayout3.setBackgroundColor(SettingsManager.getInstance().getPrimaryColor());
            tabLayout3.setTabMode(0);
            linearLayout.setBackgroundColor(SettingsManager.getInstance().getPrimaryColor());
            viewPager2.setAdapter((PagerAdapter)this.featuresMainPagerAdapter);
            viewPager2.addOnPageChangeListener((ViewPager.OnPageChangeListener)new TabLayout.TabLayoutOnPageChangeListener(tabLayout));
            tabLayout2.addOnTabSelectedListener((TabLayout.BaseOnTabSelectedListener)new TabLayout.BaseOnTabSelectedListener<TabLayout.Tab>(){

                public void onTabSelected(TabLayout.Tab tab) {
                    viewPager.setCurrentItem(tab.getPosition());
                }

                public void onTabUnselected(TabLayout.Tab tab) {
                }

                public void onTabReselected(TabLayout.Tab tab) {
                }
            });
            this.tabLayout = tabLayout2;
            this.tabsContainer = linearLayout;
            this.mViewPager = viewPager;
            return;
        }
    }

    private void handleThemeColors() {
        FeaturesMainFragment featuresMainFragment = this;
        TabLayout tabLayout = featuresMainFragment.tabLayout;
        if (featuresMainFragment.tabsContainer != null && tabLayout != null) {
            if (Instabug.getTheme() == InstabugColorTheme.InstabugColorThemeLight) {
                this.tabsContainer.setBackgroundColor(SettingsManager.getInstance().getPrimaryColor());
                tabLayout.setBackgroundColor(SettingsManager.getInstance().getPrimaryColor());
            } else {
                FeaturesMainFragment featuresMainFragment2 = this;
                featuresMainFragment2.tabsContainer.setBackgroundColor(this.getResources().getColor(R.color.ib_fr_toolbar_dark_color));
                tabLayout.setBackgroundColor(featuresMainFragment2.getResources().getColor(R.color.ib_fr_toolbar_dark_color));
            }
            this.tabLayout = tabLayout;
            return;
        }
    }

    static /* synthetic */ int access$002(FeaturesMainFragment featuresMainFragment, int n) {
        featuresMainFragment.mSortByAction = n;
        return n;
    }

    public void onCreate(@Nullable Bundle object) {
        ArrayList arrayList;
        FeaturesMainPresenter featuresMainPresenter;
        FeaturesMainFragment featuresMainFragment = this;
        super.onCreate(object);
        featuresMainFragment.setRetainInstance(true);
        object = featuresMainPresenter;
        featuresMainPresenter = new FeaturesMainPresenter(this);
        featuresMainFragment.presenter = object;
        object = arrayList;
        arrayList = new ArrayList();
        featuresMainFragment.onSortActionChangedListeners = object;
        this.mSortByAction = FeaturesRequestSettings.getLastSortByAction();
        this.sortByTopVotedFeatures = this.mSortByAction == 0;
    }

    @Override
    protected ToolbarActionButton getToolbarCloseActionButton() {
        int n = R.drawable.ibg_core_ic_close;
        int n2 = R.string.close;
        ToolbarActionButton.OnToolbarButtonClick onToolbarButtonClick = () -> {
            FeaturesMainFragment featuresMainFragment = featuresMainFragment.presenter;
            if (featuresMainFragment != null) {
                ((FeaturesMainPresenter)((Object)((Object)featuresMainFragment))).onCloseButtonClicked();
            }
        };
        ToolbarActionButton.ViewType viewType = ToolbarActionButton.ViewType.ICON;
        return new ToolbarActionButton(n, n2, onToolbarButtonClick, viewType);
    }

    @Override
    protected void addToolbarActionButtons() {
        int n = R.drawable.ibg_fr_ic_add_white_36dp;
        ToolbarActionButton.OnToolbarButtonClick onToolbarButtonClick = () -> {
            FeaturesMainFragment featuresMainFragment = featuresMainFragment.presenter;
            if (featuresMainFragment != null) {
                ((FeaturesMainPresenter)((Object)((Object)featuresMainFragment))).onAddFeatureButtonClicked();
            }
        };
        ToolbarActionButton.ViewType viewType = ToolbarActionButton.ViewType.ICON;
        this.toolbarActionButtons.add(new ToolbarActionButton(n, -1, onToolbarButtonClick, viewType));
    }

    @Override
    @Nullable
    protected String getTitle() {
        return PlaceHolderUtils.getPlaceHolder((InstabugCustomTextPlaceHolder.Key)InstabugCustomTextPlaceHolder.Key.FEATURES_REQUEST, (String)this.getLocalizedString(R.string.instabug_str_features_request_header));
    }

    @Override
    protected int getContentLayout() {
        return R.layout.ib_fr_features_main_fragment;
    }

    @Override
    protected void initContentViews(View view, @Nullable Bundle bundle) {
        FeaturesMainFragment featuresMainFragment = this;
        featuresMainFragment.featuresMainPagerAdapter = new FeaturesMainViewPagerAdapter(this.getChildFragmentManager(), this);
        featuresMainFragment.initTabs();
        featuresMainFragment.initSortingViews();
        featuresMainFragment.handleThemeColors();
    }

    @SuppressLint(value={"STARVATION"})
    public void onClick(View view) {
        if (view.getId() == R.id.sortingActionsLayoutRoot) {
            this.showSortingActionMenu(view);
        }
    }

    @Override
    public void navigateToAddNewFeatureScreen() {
        if (this.getActivity() == null) {
            return;
        }
        this.getActivity().getSupportFragmentManager().beginTransaction().add(R.id.instabug_fragment_container, (Fragment)new AddNewFeatureFragment()).addToBackStack("search_features").commit();
    }

    @Override
    public void closeFeatureRequestsMainScreen() {
        this.finishActivity();
    }

    public void showSortingActionMenu(View view) {
        if ((this = (Spinner)this.findViewById(R.id.spinnerSortActions)) != null) {
            this.performClick();
        }
    }

    @Override
    public Fragment onTapSelected(int n) {
        if (n != 1) {
            if (this.mainAllFeaturesFragment == null) {
                MainAllFeaturesFragment mainAllFeaturesFragment;
                FeaturesMainFragment featuresMainFragment = this;
                featuresMainFragment.mainAllFeaturesFragment = mainAllFeaturesFragment = MainAllFeaturesFragment.newInstance(featuresMainFragment.sortByTopVotedFeatures);
                featuresMainFragment.onSortActionChangedListeners.add(mainAllFeaturesFragment);
            }
            return this.mainAllFeaturesFragment;
        }
        if (this.mainMyFeaturesFragment == null) {
            MainMyFeaturesFragment mainMyFeaturesFragment;
            FeaturesMainFragment featuresMainFragment = this;
            featuresMainFragment.mainMyFeaturesFragment = mainMyFeaturesFragment = MainMyFeaturesFragment.newInstance(featuresMainFragment.sortByTopVotedFeatures);
            featuresMainFragment.onSortActionChangedListeners.add(mainMyFeaturesFragment);
        }
        return this.mainMyFeaturesFragment;
    }

    void publishSortEvent(boolean bl) {
        Iterator<OnSortActionChangedListener> iterator = ((FeaturesMainFragment)((Object)iterator)).onSortActionChangedListeners.iterator();
        while (iterator.hasNext()) {
            ((OnSortActionChangedListener)iterator.next()).onSortActionChanged(bl);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.onSortActionChangedListeners = null;
    }

    public void refreshMyFeatures() {
        ViewPager viewPager = this.mViewPager;
        if (viewPager != null) {
            viewPager.setCurrentItem(1);
        }
        FeaturesMainFragment featuresMainFragment = this;
        ((MainAllFeaturesFragment)featuresMainFragment.featuresMainPagerAdapter.getItem(0)).onRefresh();
        ((MainMyFeaturesFragment)featuresMainFragment.featuresMainPagerAdapter.getItem(1)).onRefresh();
    }
}

