/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.featuresrequest.ui.featuredetails;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.fragment.app.Fragment;
import com.instabug.featuresrequest.R;
import com.instabug.featuresrequest.models.FeatureRequest;
import com.instabug.featuresrequest.models.StatusChange;
import com.instabug.featuresrequest.models.TimelineObject;
import com.instabug.featuresrequest.models.TimelineResponse;
import com.instabug.featuresrequest.ui.addcomment.AddCommentFragment;
import com.instabug.featuresrequest.ui.base.featureslist.OnVoteChangeListener;
import com.instabug.featuresrequest.ui.custom.DynamicToolbarFragment;
import com.instabug.featuresrequest.ui.custom.ToolbarActionButton;
import com.instabug.featuresrequest.ui.featuredetails.FeaturesRequestsDetailsContract$View;
import com.instabug.featuresrequest.ui.featuredetails.FeaturesRequestsDetailsPresenter;
import com.instabug.featuresrequest.ui.featuredetails.TimelineAdapter;
import com.instabug.featuresrequest.utils.DateUtils;
import com.instabug.featuresrequest.utils.ListviewUtils;
import com.instabug.featuresrequest.utils.StatusBinder;
import com.instabug.featuresrequest.utils.TextViewUtils;
import com.instabug.featuresrequest.utils.ViewUtilsKt;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.core.ui.BaseContract;
import com.instabug.library.core.ui.InstabugBaseFragment;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.AttrResolver;
import com.instabug.library.view.ViewUtils;
import java.io.Serializable;
import java.util.ArrayList;

@SuppressLint(value={"ERADICATE_FIELD_NOT_INITIALIZED"})
public class FeatureRequestsDetailsFragment
extends DynamicToolbarFragment<FeaturesRequestsDetailsPresenter>
implements FeaturesRequestsDetailsContract$View {
    @Nullable
    private LinearLayout voteActionLayout;
    @Nullable
    private FeatureRequest featureRequest;
    @Nullable
    private TextView voteTextCount;
    @Nullable
    private TextView featureTitle;
    @Nullable
    private TextView featureStatus;
    @Nullable
    private TextView ownerName;
    @Nullable
    private TextView date;
    @Nullable
    private TextView commentsCount;
    @Nullable
    private ImageView voteIcon;
    @Nullable
    private TextView featureDescription;
    @Nullable
    private LinearLayout noCommentsLayout;
    @Nullable
    private LinearLayout addCommentLayoutContainer;
    @Nullable
    private ListView commentsList;
    private boolean isDescriptionExpanded = false;
    @Nullable
    private TimelineAdapter adapter;
    @NonNull
    private ArrayList<TimelineObject> comments;
    private OnVoteChangeListener onVoteChangeListener;
    private boolean isVoteChanged;

    public FeatureRequestsDetailsFragment() {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        v1.comments = arrayList2;
        v1.isVoteChanged = false;
    }

    public static FeatureRequestsDetailsFragment newInstance(FeatureRequest featureRequest, OnVoteChangeListener onVoteChangeListener) {
        Bundle bundle;
        Bundle bundle2 = bundle;
        new Bundle().putSerializable("key_feature", (Serializable)featureRequest);
        FeatureRequestsDetailsFragment featureRequestsDetailsFragment = new FeatureRequestsDetailsFragment();
        featureRequestsDetailsFragment.setVoteChangeListener(onVoteChangeListener);
        featureRequestsDetailsFragment.setArguments(bundle2);
        return featureRequestsDetailsFragment;
    }

    private void setVoteChangeListener(OnVoteChangeListener onVoteChangeListener) {
        this.onVoteChangeListener = onVoteChangeListener;
    }

    private void handleVote(final FeatureRequest featureRequest) {
        Object object = this.voteActionLayout;
        if (object != null) {
            Runnable runnable;
            LinearLayout linearLayout = object;
            object = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    if (FeatureRequestsDetailsFragment.this.isAdded() && !FeatureRequestsDetailsFragment.this.isRemoving() && FeatureRequestsDetailsFragment.this.getContext() != null && FeatureRequestsDetailsFragment.this.voteActionLayout != null) {
                        TextView textView = FeatureRequestsDetailsFragment.this.voteTextCount;
                        if (FeatureRequestsDetailsFragment.this.voteIcon != null && textView != null) {
                            FeatureRequestsDetailsFragment.this.voteIcon.setImageResource(R.drawable.ibg_fr_ic_vote_arrow_white);
                            GradientDrawable gradientDrawable = (GradientDrawable)FeatureRequestsDetailsFragment.this.voteActionLayout.getBackground();
                            Integer n = featureRequest.getLikesCount();
                            textView.setText((CharSequence)FeatureRequestsDetailsFragment.this.getLocalizedString(R.string.feature_request_votes_count, new Object[]{n}));
                            if (Instabug.getTheme() == InstabugColorTheme.InstabugColorThemeLight) {
                                if (featureRequest.isLiked()) {
                                    GradientDrawable gradientDrawable2 = gradientDrawable;
                                    gradientDrawable2.setStroke(ViewUtils.convertDpToPx((Context)FeatureRequestsDetailsFragment.this.getContext(), (float)2.0f), ContextCompat.getColor((Context)FeatureRequestsDetailsFragment.this.getContext(), (int)17170443));
                                    gradientDrawable2.setColor(ContextCompat.getColor((Context)FeatureRequestsDetailsFragment.this.getContext(), (int)17170443));
                                    textView.setTextColor(SettingsManager.getInstance().getPrimaryColor());
                                    DrawableCompat.setTint((Drawable)FeatureRequestsDetailsFragment.this.voteIcon.getDrawable(), (int)SettingsManager.getInstance().getPrimaryColor());
                                } else {
                                    GradientDrawable gradientDrawable3 = gradientDrawable;
                                    gradientDrawable3.setStroke(ViewUtils.convertDpToPx((Context)FeatureRequestsDetailsFragment.this.getContext(), (float)2.0f), ContextCompat.getColor((Context)FeatureRequestsDetailsFragment.this.getContext(), (int)R.color.ib_fr_toolbar_vote_btn_stroke_color));
                                    gradientDrawable3.setColor(ContextCompat.getColor((Context)FeatureRequestsDetailsFragment.this.getContext(), (int)17170445));
                                    textView.setTextColor(ContextCompat.getColor((Context)FeatureRequestsDetailsFragment.this.getContext(), (int)17170443));
                                    DrawableCompat.setTint((Drawable)FeatureRequestsDetailsFragment.this.voteIcon.getDrawable(), (int)ContextCompat.getColor((Context)FeatureRequestsDetailsFragment.this.getContext(), (int)17170443));
                                }
                            } else if (featureRequest.isLiked()) {
                                GradientDrawable gradientDrawable4 = gradientDrawable;
                                gradientDrawable4.setStroke(ViewUtils.convertDpToPx((Context)FeatureRequestsDetailsFragment.this.getContext(), (float)2.0f), SettingsManager.getInstance().getPrimaryColor());
                                gradientDrawable4.setColor(SettingsManager.getInstance().getPrimaryColor());
                                textView.setTextColor(ContextCompat.getColor((Context)FeatureRequestsDetailsFragment.this.getContext(), (int)17170443));
                                DrawableCompat.setTint((Drawable)FeatureRequestsDetailsFragment.this.voteIcon.getDrawable(), (int)ContextCompat.getColor((Context)FeatureRequestsDetailsFragment.this.getContext(), (int)17170443));
                            } else {
                                GradientDrawable gradientDrawable5 = gradientDrawable;
                                gradientDrawable5.setStroke(ViewUtils.convertDpToPx((Context)FeatureRequestsDetailsFragment.this.getContext(), (float)2.0f), SettingsManager.getInstance().getPrimaryColor());
                                gradientDrawable5.setColor(ContextCompat.getColor((Context)FeatureRequestsDetailsFragment.this.getContext(), (int)17170445));
                                textView.setTextColor(SettingsManager.getInstance().getPrimaryColor());
                                DrawableCompat.setTint((Drawable)FeatureRequestsDetailsFragment.this.voteIcon.getDrawable(), (int)SettingsManager.getInstance().getPrimaryColor());
                            }
                            FeatureRequestsDetailsFragment.access$202(FeatureRequestsDetailsFragment.this, textView);
                            if (FeatureRequestsDetailsFragment.this.voteActionLayout != null) {
                                if (Build.VERSION.SDK_INT >= 16) {
                                    FeatureRequestsDetailsFragment.this.voteActionLayout.setBackground((Drawable)gradientDrawable);
                                } else {
                                    FeatureRequestsDetailsFragment.this.voteActionLayout.setBackgroundDrawable((Drawable)gradientDrawable);
                                }
                            }
                        }
                    }
                }
            };
            linearLayout.post((Runnable)object);
        }
    }

    static /* synthetic */ boolean access$002(FeatureRequestsDetailsFragment featureRequestsDetailsFragment, boolean bl) {
        featureRequestsDetailsFragment.isDescriptionExpanded = bl;
        return bl;
    }

    static /* synthetic */ TextView access$202(FeatureRequestsDetailsFragment featureRequestsDetailsFragment, TextView textView) {
        featureRequestsDetailsFragment.voteTextCount = textView;
        return textView;
    }

    public void onCreate(@Nullable Bundle object) {
        FeaturesRequestsDetailsPresenter featuresRequestsDetailsPresenter;
        FeatureRequestsDetailsFragment featureRequestsDetailsFragment = this;
        super.onCreate(object);
        if (featureRequestsDetailsFragment.getArguments() != null) {
            this.featureRequest = (FeatureRequest)this.getArguments().getSerializable("key_feature");
        }
        object = featuresRequestsDetailsPresenter;
        featuresRequestsDetailsPresenter = new FeaturesRequestsDetailsPresenter(this);
        this.presenter = object;
    }

    @Override
    protected ToolbarActionButton getToolbarCloseActionButton() {
        int n = R.drawable.ibg_core_ic_back;
        int n2 = R.string.feature_request_go_back;
        ToolbarActionButton.OnToolbarButtonClick onToolbarButtonClick = () -> {
            FeatureRequestsDetailsFragment featureRequestsDetailsFragment = featureRequestsDetailsFragment.presenter;
            if (featureRequestsDetailsFragment != null) {
                ((FeaturesRequestsDetailsPresenter)((Object)featureRequestsDetailsFragment)).onBackBtnClicked();
            }
        };
        ToolbarActionButton.ViewType viewType = ToolbarActionButton.ViewType.ICON;
        return new ToolbarActionButton(n, n2, onToolbarButtonClick, viewType);
    }

    @Override
    protected void addToolbarActionButtons() {
        int n = R.string.ib_feature_rq_str_votes;
        ToolbarActionButton.OnToolbarButtonClick onToolbarButtonClick = () -> {
            ((FeatureRequestsDetailsFragment)this).isVoteChanged = true;
            BaseContract.Presenter presenter = ((InstabugBaseFragment)this).presenter;
            if (presenter != null && (this = ((FeatureRequestsDetailsFragment)this).featureRequest) != null) {
                ((FeaturesRequestsDetailsPresenter)presenter).onVoteButtonClick((FeatureRequest)this);
            }
        };
        ToolbarActionButton.ViewType viewType = ToolbarActionButton.ViewType.VOTE;
        this.toolbarActionButtons.add(new ToolbarActionButton(-1, n, onToolbarButtonClick, viewType));
    }

    @Override
    protected String getTitle() {
        return this.getLocalizedString(R.string.feature_requests_details);
    }

    @Override
    protected int getContentLayout() {
        return R.layout.ib_fr_features_details_fragment;
    }

    @Override
    protected void initContentViews(View object, @Nullable Bundle bundle) {
        TimelineAdapter timelineAdapter;
        bundle = this.toolbar;
        FeaturesRequestsDetailsPresenter featuresRequestsDetailsPresenter = (FeaturesRequestsDetailsPresenter)this.presenter;
        if (bundle != null) {
            Bundle bundle2 = bundle;
            this.voteActionLayout = (LinearLayout)bundle2.findViewById(R.id.ib_feature_request_toolbar_vote_action_layout);
            this.voteTextCount = (TextView)bundle2.findViewById(R.id.ib_toolbar_vote_count);
            this.voteIcon = (ImageView)bundle2.findViewById(R.id.ib_toolbar_vote_icon);
        }
        View view = object;
        this.featureDescription = (TextView)view.findViewById(R.id.ib_fr_tv_feature_details_desc);
        this.featureTitle = (TextView)view.findViewById(R.id.ib_fr_details_title);
        this.featureStatus = (TextView)view.findViewById(R.id.instabug_txt_feature_request_status);
        this.date = (TextView)view.findViewById(R.id.ib_txt_feature_request_date);
        this.ownerName = (TextView)view.findViewById(R.id.ib_txt_feature_request_owner);
        object = (TextView)view.findViewById(R.id.tv_add_comment);
        this.commentsCount = (TextView)view.findViewById(R.id.ib_features_request_comment_count);
        this.noCommentsLayout = (LinearLayout)view.findViewById(R.id.ib_fr_details_no_comments_layout);
        ImageView imageView = (ImageView)view.findViewById(R.id.ib_fr_details_no_comments_icon);
        this.commentsList = (ListView)view.findViewById(R.id.instabug_feature_details_comments_list);
        this.addCommentLayoutContainer = (LinearLayout)view.findViewById(R.id.addCommentLayoutContainer);
        this.toolbar = bundle;
        if (Build.VERSION.SDK_INT > 34 && (bundle = (LinearLayout)this.findViewById(R.id.ib_fr_tv_feature_details_main_layout)) != null) {
            ViewUtilsKt.addSystemWindowInsetToPadding((View)bundle, true, false, true, true);
        }
        if (imageView != null && this.getContext() != null) {
            imageView.setColorFilter(AttrResolver.getColor((Context)this.getContext(), (int)R.attr.ib_fr_no_comments_icon_color));
        }
        if (object != null) {
            object.setOnClickListener((View.OnClickListener)this);
        }
        object = timelineAdapter;
        timelineAdapter = new TimelineAdapter(this.comments, this);
        this.adapter = object;
        bundle = this.commentsList;
        if (bundle != null) {
            bundle.setAdapter((ListAdapter)object);
        }
        if (featuresRequestsDetailsPresenter != null && (object = this.featureRequest) != null) {
            this.fillData((FeatureRequest)object);
            featuresRequestsDetailsPresenter.getFeatureTimeline(this.featureRequest.getFeatureId());
            this.presenter = featuresRequestsDetailsPresenter;
            return;
        }
    }

    public void fillData(FeatureRequest featureRequest) {
        Object object;
        Object[] objectArray;
        this.featureRequest = featureRequest;
        TextView textView = this.featureTitle;
        if (textView != null) {
            textView.setText((CharSequence)featureRequest.getTitle());
        }
        if (this.featureDescription != null) {
            if (featureRequest.getDescription() != null && !featureRequest.getDescription().equalsIgnoreCase("null") && !TextUtils.isEmpty((CharSequence)featureRequest.getDescription())) {
                this.featureDescription.setVisibility(0);
                TextViewUtils.makeTextViewResizable(this.featureDescription, featureRequest.getDescription(), this.getLocalizedString(R.string.feature_request_str_more), this.getLocalizedString(R.string.feature_request_str_less), this.isDescriptionExpanded ^ true, new Runnable(){

                    @Override
                    public void run() {
                        FeatureRequestsDetailsFragment featureRequestsDetailsFragment = FeatureRequestsDetailsFragment.this;
                        FeatureRequestsDetailsFragment.access$002(featureRequestsDetailsFragment, featureRequestsDetailsFragment.isDescriptionExpanded ^ true);
                    }
                });
            } else {
                this.featureDescription.setVisibility(8);
            }
        }
        if (this.addCommentLayoutContainer != null && this.voteActionLayout != null) {
            if (featureRequest.isCompleted()) {
                this.addCommentLayoutContainer.setVisibility(8);
                this.voteActionLayout.setEnabled(false);
            } else {
                this.addCommentLayoutContainer.setVisibility(0);
                this.voteActionLayout.setEnabled(true);
            }
        }
        if (this.getContext() == null) {
            return;
        }
        textView = this.ownerName;
        if (textView != null) {
            if (featureRequest.getCreatorName() != null && !featureRequest.getCreatorName().equalsIgnoreCase("null") && !TextUtils.isEmpty((CharSequence)featureRequest.getCreatorName())) {
                int n = R.string.feature_request_owner;
                objectArray = featureRequest.getCreatorName();
                Object[] objectArray2 = new Object[1];
                Object[] objectArray3 = objectArray2;
                objectArray2[0] = objectArray;
                object = this.getLocalizedString(n, objectArray3);
            } else {
                object = this.getLocalizedString(R.string.feature_request_owner_anonymous);
            }
            textView.setText((CharSequence)object);
        }
        if ((textView = this.commentsCount) != null) {
            int n = R.string.feature_request_comments_count;
            object = featureRequest.getCommentsCount();
            Object[] objectArray4 = new Object[1];
            objectArray = objectArray4;
            objectArray4[0] = object;
            textView.setText((CharSequence)this.getLocalizedString(n, objectArray));
        }
        StatusBinder.bind(featureRequest.getStatus(), featureRequest.getColorCode(), this.featureStatus, this.getContext());
        TextView textView2 = this.date;
        if (textView2 != null) {
            textView2.setText((CharSequence)DateUtils.getTimeAgo(this.getContext(), featureRequest.getDate()));
        }
        this.handleVote(featureRequest);
    }

    @Override
    public void handleBackBtnClicked() {
        if (this.getActivity() != null) {
            this.getActivity().onBackPressed();
        }
    }

    public void onClick(View view) {
        if (view.getId() == R.id.tv_add_comment && this.getActivity() != null && this.featureRequest != null) {
            this.getActivity().getSupportFragmentManager().beginTransaction().add(R.id.instabug_fragment_container, (Fragment)AddCommentFragment.newInstance(this.featureRequest.getFeatureId())).addToBackStack("add_comment").commit();
        }
    }

    @Override
    public void showNoCommentsLayout() {
        FeatureRequestsDetailsFragment featureRequestsDetailsFragment = featureRequestsDetailsFragment.noCommentsLayout;
        if (featureRequestsDetailsFragment != null) {
            featureRequestsDetailsFragment.setVisibility(0);
        }
    }

    @Override
    public void updateVote(FeatureRequest featureRequest) {
        this.handleVote(featureRequest);
    }

    public void onDestroy() {
        FeatureRequestsDetailsFragment featureRequestsDetailsFragment = this;
        super.onDestroy();
        OnVoteChangeListener onVoteChangeListener = featureRequestsDetailsFragment.onVoteChangeListener;
        if (onVoteChangeListener != null && this.isVoteChanged) {
            onVoteChangeListener.onVoteChange();
        }
    }

    @Override
    public void showComments(TimelineResponse timelineResponse) {
        ListView listView = this.commentsList;
        if (listView != null) {
            TimelineAdapter timelineAdapter;
            FeatureRequestsDetailsFragment featureRequestsDetailsFragment = this;
            FeatureRequestsDetailsFragment featureRequestsDetailsFragment2 = this;
            featureRequestsDetailsFragment2.comments = new ArrayList();
            featureRequestsDetailsFragment2.adapter = null;
            TimelineAdapter timelineAdapter2 = timelineAdapter;
            featureRequestsDetailsFragment2.adapter = new TimelineAdapter(this.comments, this);
            listView.setAdapter((ListAdapter)timelineAdapter2);
            featureRequestsDetailsFragment.comments.addAll(timelineResponse.getTimelineObjects());
            featureRequestsDetailsFragment.adapter.notifyDataSetChanged();
            timelineResponse = featureRequestsDetailsFragment.noCommentsLayout;
            if (timelineResponse != null) {
                timelineResponse.setVisibility(8);
            }
            ListView listView2 = listView;
            listView2.invalidate();
            ListviewUtils.setListViewHeightBasedOnChildren(listView2);
        }
        this.commentsList = listView;
    }

    @Override
    public void handelCompletedFeaturesActions() {
        if (this.comments.size() > 0) {
            for (int i = 0; i < this.comments.size() - 1; ++i) {
                TimelineObject timelineObject = this.comments.get(i);
                if (!(timelineObject instanceof StatusChange) || this.addCommentLayoutContainer == null || this.voteActionLayout == null) continue;
                if (((StatusChange)timelineObject).getNewStatus() == FeatureRequest.Status.Completed) {
                    FeatureRequestsDetailsFragment featureRequestsDetailsFragment = this;
                    featureRequestsDetailsFragment.addCommentLayoutContainer.setVisibility(8);
                    featureRequestsDetailsFragment.voteActionLayout.setEnabled(false);
                    break;
                }
                FeatureRequestsDetailsFragment featureRequestsDetailsFragment = this;
                featureRequestsDetailsFragment.addCommentLayoutContainer.setVisibility(0);
                featureRequestsDetailsFragment.voteActionLayout.setEnabled(true);
                break;
            }
        }
    }

    @Override
    public void updateListHeight() {
        ListviewUtils.setListViewHeightBasedOnChildren(this.commentsList);
    }

    public void onNewCommentAdded() {
        BaseContract.Presenter presenter;
        FeatureRequest featureRequest = this.featureRequest;
        if (featureRequest != null && (presenter = this.presenter) != null) {
            FeaturesRequestsDetailsPresenter featuresRequestsDetailsPresenter = (FeaturesRequestsDetailsPresenter)presenter;
            FeatureRequestsDetailsFragment featureRequestsDetailsFragment = this;
            FeatureRequest featureRequest2 = featureRequest;
            featureRequest2.setCommentsCount(featureRequest2.getCommentsCount() + 1);
            featureRequestsDetailsFragment.fillData(featureRequestsDetailsFragment.featureRequest);
            featuresRequestsDetailsPresenter.getFeatureTimeline(featureRequestsDetailsFragment.featureRequest.getFeatureId());
            this.presenter = featuresRequestsDetailsPresenter;
            return;
        }
    }
}

