/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.featuresrequest.ui.base.featureslist;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.instabug.featuresrequest.R;
import com.instabug.featuresrequest.cache.FeatureRequestsDBHelper;
import com.instabug.featuresrequest.eventbus.FeatureRequestsEventBus;
import com.instabug.featuresrequest.models.FeatureRequest;
import com.instabug.featuresrequest.models.FeatureRequestResponse;
import com.instabug.featuresrequest.network.service.FeaturesRequestService;
import com.instabug.featuresrequest.network.service.FeaturesRequestVoteJob;
import com.instabug.featuresrequest.settings.FeaturesRequestSettings;
import com.instabug.featuresrequest.ui.base.FeaturesListBo;
import com.instabug.featuresrequest.ui.base.featureslist.FeatureHolder;
import com.instabug.featuresrequest.ui.base.featureslist.FeaturesListContract$View;
import com.instabug.featuresrequest.utils.FeaturesRequestUtils;
import com.instabug.library.Instabug;
import com.instabug.library.core.ui.BaseContract;
import com.instabug.library.core.ui.BasePresenter;
import com.instabug.library.networkv2.NetworkManager;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import io.reactivexport.disposables.CompositeDisposable;
import io.reactivexport.functions.Consumer;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class FeaturesListPresenter
extends BasePresenter<FeaturesListContract$View>
implements BaseContract.Presenter {
    @Nullable
    private final FeaturesListContract$View viewInstance;
    FeaturesListBo featuresListBo;
    private CompositeDisposable disposables;

    public FeaturesListPresenter(FeaturesListContract$View featuresListContract$View, FeaturesListBo featuresListBo, boolean bl) {
        FeaturesListPresenter featuresListPresenter = this;
        FeaturesListBo featuresListBo2 = featuresListBo;
        FeaturesListPresenter featuresListPresenter2 = this;
        super((BaseContract.View)featuresListContract$View);
        featuresListPresenter2.viewInstance = (FeaturesListContract$View)featuresListPresenter2.view.get();
        this.featuresListBo = featuresListBo;
        int n = featuresListBo2.getPage();
        boolean bl2 = FeaturesRequestSettings.shouldSortByTopRated();
        featuresListPresenter.addDataToBo(featuresListBo2, n, false, bl2, bl, true);
        featuresListPresenter.subscribeToVoteEvents();
    }

    private void submitVote() {
        Object object = object.viewInstance;
        if (object != null && ((Fragment)object.getViewContext()).getContext() != null) {
            FeaturesRequestVoteJob.getInstance().start();
        }
    }

    private void subscribeToVoteEvents() {
        CompositeDisposable compositeDisposable = this.disposables;
        if (compositeDisposable == null || compositeDisposable.isDisposed()) {
            CompositeDisposable compositeDisposable2;
            compositeDisposable = compositeDisposable2;
            compositeDisposable2 = new CompositeDisposable();
            this.disposables = compositeDisposable;
        }
        this.disposables.add(FeatureRequestsEventBus.getInstance().subscribe((Consumer)new Consumer<FeatureRequest>(){

            public void accept(FeatureRequest featureRequest) {
                if (FeaturesListPresenter.this.featuresListBo.getFeatures() != null && !FeaturesListPresenter.this.featuresListBo.getFeatures().isEmpty()) {
                    new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (FeaturesListPresenter.this.viewInstance != null) {
                                FeaturesListPresenter.this.viewInstance.updateItemsOrder();
                            }
                        }
                    }, 1000L);
                    return;
                }
            }
        }));
    }

    public void addDataToBo(final FeaturesListBo featuresListBo, int n, boolean bl, boolean bl2, boolean bl3, final boolean bl4) {
        PoolProvider.postIOTask(() -> {
            if (FeaturesRequestUtils.isFeaturesRequestFeatureEnabled() && Instabug.getApplicationContext() != null) {
                Request.Callbacks<JSONObject, Throwable> callbacks;
                if (n == 1) {
                    PoolProvider.postMainThreadTask(() -> {
                        FeaturesListContract$View featuresListContract$View = ((FeaturesListPresenter)((Object)((Object)((Object)featuresListContract$View)))).viewInstance;
                        if (featuresListContract$View != null) {
                            featuresListContract$View.setRefreshing(true);
                        }
                    });
                }
                Request.Callbacks<JSONObject, Throwable> callbacks2 = callbacks;
                callbacks = new Request.Callbacks<JSONObject, Throwable>(){

                    public void onSucceeded(@Nullable JSONObject object) {
                        if (object == null) {
                            JSONException jSONException;
                            1 v0 = jSONException2;
                            JSONException jSONException2 = jSONException;
                            jSONException = new JSONException("response json is null");
                            v0.onFailed(jSONException2);
                            return;
                        }
                        object = FeatureRequestResponse.fromJson(object);
                        try {
                            PoolProvider.postMainThreadTask((Runnable)new Runnable(){
                                final /* synthetic */ FeatureRequestResponse val$featureRequestResponse;
                                {
                                    this.val$featureRequestResponse = featureRequestResponse;
                                }

                                @Override
                                public void run() {
                                    if (this.val$featureRequestResponse.getFeatureRequestList() != null && this.val$featureRequestResponse.getFeatureRequestList().size() > 0) {
                                        1 var1_1 = this;
                                        if (var1_1.bl4) {
                                            var1_1.featuresListBo.destroy();
                                        }
                                        1 v0 = this;
                                        v0.featuresListBo.addFeatures(this.val$featureRequestResponse.getFeatureRequestList());
                                        if (v0.val$featureRequestResponse.hasNextPage()) {
                                            featuresListBo.incrementPageNumber();
                                        } else {
                                            featuresListBo.setHasNextPage(false);
                                        }
                                    }
                                    FeaturesListPresenter.this.onRequestFinish();
                                }
                            });
                        }
                        catch (JSONException jSONException) {
                            jSONException2.onFailed(jSONException);
                        }
                    }

                    public void onFailed(Throwable throwable) {
                        String string2 = "IBG-FR";
                        String string3 = throwable.getMessage() != null ? throwable.getMessage() : "Error While fetching features Requests";
                        InstabugSDKLogger.e((String)string2, (String)string3, (Throwable)throwable);
                        PoolProvider.postMainThreadTask((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                FeaturesListPresenter.this.onRequestFinishedWithError();
                            }
                        });
                    }
                };
                FeaturesRequestService.getInstance().fetchFeaturesRequests(n, bl, bl2, bl3, callbacks2);
            } else {
                PoolProvider.postMainThreadTask(() -> {
                    if (this.viewInstance == null) {
                        return;
                    }
                    if (featuresListBo.getFeaturesCount() == 0) {
                        this.viewInstance.showErrorView();
                    } else {
                        this.viewInstance.hideLoadMore();
                    }
                });
            }
        });
    }

    protected void onRequestFinish() {
        FeaturesListContract$View featuresListContract$View = this.viewInstance;
        if (featuresListContract$View != null && ((Fragment)featuresListContract$View.getViewContext()).isAdded() && ((Fragment)this.viewInstance.getViewContext()).getContext() != null) {
            FeaturesListPresenter featuresListPresenter = this;
            featuresListPresenter.viewInstance.setRefreshing(false);
            if (featuresListPresenter.getFeaturesCount() == 0) {
                if (NetworkManager.isOnline()) {
                    this.viewInstance.showEmptyView();
                } else {
                    this.viewInstance.showErrorView();
                }
            } else {
                this.viewInstance.showFeatures();
            }
            return;
        }
    }

    protected void onRequestFinishedWithError() {
        FeaturesListContract$View featuresListContract$View = this.viewInstance;
        if (featuresListContract$View == null) {
            return;
        }
        featuresListContract$View.setRefreshing(false);
        if (this.getFeaturesCount() == 0) {
            this.viewInstance.showErrorView();
        } else {
            FeaturesListPresenter featuresListPresenter = this;
            featuresListPresenter.viewInstance.showToast(R.string.feature_requests_error_state_title);
            featuresListPresenter.viewInstance.hideLoadMore();
        }
    }

    public void onFeatureClicked(int n) {
        FeaturesListContract$View featuresListContract$View = this.viewInstance;
        if (featuresListContract$View != null) {
            featuresListContract$View.navigateToTheDetailsScreen(this.featuresListBo.getFeatureByIndex(n));
        }
    }

    public void onUpVoteFeatureClicked(FeatureRequest featureRequest) {
        FeatureRequest featureRequest2 = featureRequest;
        featureRequest2.setUserVoteStatus(FeatureRequest.UserVoteStatus.USER_VOTED_UP);
        try {
            FeatureRequestsDBHelper.insert(featureRequest2);
        }
        catch (JSONException jSONException) {}
        FeaturesListPresenter featuresListPresenter = featuresListContract$View;
        featuresListPresenter.submitVote();
        FeatureRequestsEventBus.getInstance().post(featureRequest);
        FeaturesListContract$View featuresListContract$View = featuresListPresenter.viewInstance;
        if (featuresListContract$View != null) {
            featuresListContract$View.notifyDataSetChanged();
        }
    }

    public void onUnVoteFeatureClicked(FeatureRequest featureRequest) {
        FeatureRequest featureRequest2 = featureRequest;
        featureRequest2.setUserVoteStatus(FeatureRequest.UserVoteStatus.USER_UN_VOTED);
        try {
            FeatureRequestsDBHelper.insert(featureRequest2);
        }
        catch (JSONException jSONException) {}
        FeaturesListPresenter featuresListPresenter = featuresListContract$View;
        featuresListPresenter.submitVote();
        FeatureRequestsEventBus.getInstance().post(featureRequest);
        FeaturesListContract$View featuresListContract$View = featuresListPresenter.viewInstance;
        if (featuresListContract$View != null) {
            featuresListContract$View.notifyDataSetChanged();
        }
    }

    public void onLoadMoreTriggered() {
        if (this.viewInstance != null && this.featuresListBo.getPage() != 1) {
            if (this.featuresListBo.hasNextPage()) {
                FeaturesListPresenter featuresListPresenter = this;
                featuresListPresenter.viewInstance.showFooterView();
                FeaturesListBo featuresListBo = featuresListPresenter.featuresListBo;
                int n = featuresListBo.getPage();
                boolean bl = FeaturesRequestSettings.shouldSortByTopRated();
                boolean bl2 = this.viewInstance.shouldShowMyPosts();
                featuresListPresenter.addDataToBo(featuresListBo, n, false, bl, bl2, false);
            } else {
                this.viewInstance.hideFooterView();
            }
        }
    }

    public void handlePbiFooter() {
        FeaturesListContract$View featuresListContract$View = ((FeaturesListPresenter)((Object)featuresListContract$View)).viewInstance;
        if (featuresListContract$View != null) {
            featuresListContract$View.handlePoweredByFooter();
        }
    }

    public int getFeaturesCount() {
        return this.featuresListBo.getFeaturesCount();
    }

    public void onPullToRefreshTriggered() {
        FeaturesListPresenter featuresListPresenter = this;
        featuresListPresenter.featuresListBo.setHasNextPage(true);
        if (featuresListPresenter.viewInstance != null && Instabug.getApplicationContext() != null) {
            if (NetworkManager.isOnline()) {
                FeaturesListPresenter featuresListPresenter2 = this;
                featuresListPresenter2.viewInstance.hideEmptyView();
                featuresListPresenter2.viewInstance.hideErrorView();
                boolean bl = FeaturesRequestSettings.shouldSortByTopRated();
                boolean bl2 = this.viewInstance.shouldShowMyPosts();
                featuresListPresenter2.addDataToBo(featuresListPresenter2.featuresListBo, 1, false, bl, bl2, true);
            } else if (this.featuresListBo.getFeaturesCount() == 0) {
                if (NetworkManager.isOnline()) {
                    this.viewInstance.showEmptyView();
                } else {
                    this.viewInstance.showErrorView();
                }
            } else {
                FeaturesListPresenter featuresListPresenter3 = this;
                featuresListPresenter3.viewInstance.showErrorToastMessage();
                featuresListPresenter3.viewInstance.hideFooterView();
            }
        }
    }

    public void onBindFeatureViewItemAtPosition(int n, FeatureHolder featureHolder) {
        FeatureHolder featureHolder2 = featureHolder;
        FeatureRequest featureRequest = ((FeaturesListPresenter)((Object)featureRequest)).featuresListBo.getFeatureByIndex(n);
        featureHolder2.setFeatureTitle(featureRequest.getTitle());
        featureHolder2.setFeatureStateColor(featureRequest);
        featureHolder2.setCommentsCount(featureRequest.getCommentsCount());
        featureHolder2.setVotesCount(featureRequest.getLikesCount());
        featureHolder2.setCreationDate(featureRequest.getDate());
        featureHolder2.setVoteButtonStyle(featureRequest.isLiked());
        featureHolder2.setVoteButtonListener(featureRequest);
    }

    public void onEmptyViewPositiveButtonClicked() {
        FeaturesListContract$View featuresListContract$View = ((FeaturesListPresenter)((Object)featuresListContract$View)).viewInstance;
        if (featuresListContract$View != null) {
            featuresListContract$View.navigateToAddNewFeatureScreen();
        }
    }

    public void onDestroy() {
        CompositeDisposable compositeDisposable = this.disposables;
        if (compositeDisposable != null) {
            compositeDisposable.dispose();
        }
        this.featuresListBo.destroy();
    }

    public void onSortActionChanged() {
        this.onPullToRefreshTriggered();
    }

    public void onErrorStateClicked() {
        FeaturesListContract$View featuresListContract$View = this.viewInstance;
        if (featuresListContract$View != null) {
            featuresListContract$View.hideErrorView();
            this.onPullToRefreshTriggered();
        }
    }

    public boolean hasNext() {
        return this.featuresListBo.hasNextPage();
    }
}

