/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.featuresrequest.ui.addcomment;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Patterns;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.google.android.material.textfield.TextInputEditText;
import com.google.android.material.textfield.TextInputLayout;
import com.instabug.featuresrequest.R;
import com.instabug.featuresrequest.models.NewComment;
import com.instabug.featuresrequest.settings.FeaturesRequestSettings;
import com.instabug.featuresrequest.ui.FeaturesRequestActivity;
import com.instabug.featuresrequest.ui.addcomment.AddCommentContract$View;
import com.instabug.featuresrequest.ui.addcomment.AddCommentPresenter;
import com.instabug.featuresrequest.ui.custom.DynamicToolbarFragment;
import com.instabug.featuresrequest.ui.custom.ToolbarActionButton;
import com.instabug.featuresrequest.utils.TextInputLayoutHelper;
import com.instabug.featuresrequest.utils.ViewUtilsKt;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.AttrResolver;
import com.instabug.library.util.KeyboardUtils;
import com.instabug.library.util.SimpleTextWatcher;
import com.instabug.library.view.IBGProgressDialog;
import com.instabug.library.view.ViewUtils;

@SuppressLint(value={"ERADICATE_FIELD_NOT_INITIALIZED"})
public class AddCommentFragment
extends DynamicToolbarFragment<AddCommentPresenter>
implements AddCommentContract$View {
    private AddCommentPresenter presenter;
    private long featureId;
    @Nullable
    private TextInputLayout commentInputLayout;
    @Nullable
    private TextInputLayout nameInputLayout;
    @Nullable
    private TextInputLayout emailInputLayout;
    @Nullable
    private TextInputEditText commentEditTextLayout;
    @Nullable
    private TextInputEditText nameEditTextLayout;
    @Nullable
    private TextInputEditText emailEditTextLayout;
    @Nullable
    private View underLineComment;
    @Nullable
    private View underLineName;
    @Nullable
    private View underLineEmail;
    @Nullable
    private IBGProgressDialog preparingProgressDialog;
    @Nullable
    private TextView emailDisclaimer;
    @Nullable
    private TextView toolbarPostTextView;

    private void hideUserName() {
        TextInputLayout textInputLayout = this.nameInputLayout;
        if (textInputLayout != null) {
            textInputLayout.setVisibility(8);
        }
        if ((this = this.underLineName) != null) {
            this.setVisibility(8);
        }
    }

    private void hideEmail() {
        TextInputLayout textInputLayout = this.emailInputLayout;
        if (textInputLayout != null) {
            textInputLayout.setVisibility(8);
        }
        if ((textInputLayout = this.underLineEmail) != null) {
            textInputLayout.setVisibility(8);
        }
        if ((this = this.emailDisclaimer) != null) {
            this.setVisibility(8);
        }
    }

    private void handleEditTextFocusChange() {
        final TextInputEditText textInputEditText = this.commentEditTextLayout;
        if (textInputEditText == null) {
            return;
        }
        textInputEditText.setOnFocusChangeListener((view, bl) -> {
            AddCommentFragment addCommentFragment = this;
            view = addCommentFragment.underLineComment;
            TextInputLayout textInputLayout = addCommentFragment.commentInputLayout;
            if (addCommentFragment.getContext() != null && view != null) {
                if (bl) {
                    view.getLayoutParams().height = ViewUtils.convertDpToPx((Context)this.getContext(), (float)2.0f);
                    if (textInputLayout != null && textInputLayout.isErrorEnabled()) {
                        TextInputLayoutHelper.setUpperHintColor(textInputLayout, ContextCompat.getColor((Context)this.getContext(), (int)R.color.ib_fr_add_comment_error));
                        view.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.ib_fr_add_comment_error));
                    } else {
                        TextInputLayoutHelper.setUpperHintColor(textInputLayout, SettingsManager.getInstance().getPrimaryColor());
                        view.setBackgroundColor(SettingsManager.getInstance().getPrimaryColor());
                    }
                } else {
                    TextInputLayoutHelper.setUpperHintColor(textInputLayout, SettingsManager.getInstance().getPrimaryColor());
                    view.setBackgroundColor(AttrResolver.getColor((Context)this.getContext(), (int)R.attr.ib_fr_add_comment_edit_text_underline_color));
                    view.getLayoutParams().height = ViewUtils.convertDpToPx((Context)this.getContext(), (float)1.0f);
                }
                AddCommentFragment addCommentFragment2 = this;
                view.requestLayout();
                addCommentFragment2.underLineComment = view;
                addCommentFragment2.commentInputLayout = textInputLayout;
                return;
            }
        });
        TextInputEditText textInputEditText2 = this.nameEditTextLayout;
        if (textInputEditText2 == null) {
            return;
        }
        textInputEditText2.setOnFocusChangeListener((view, bl) -> {
            AddCommentFragment addCommentFragment = this;
            view = addCommentFragment.underLineName;
            if (addCommentFragment.getContext() != null && view != null) {
                if (bl) {
                    view.getLayoutParams().height = ViewUtils.convertDpToPx((Context)this.getContext(), (float)2.0f);
                    view.setBackgroundColor(SettingsManager.getInstance().getPrimaryColor());
                } else {
                    view.setBackgroundColor(AttrResolver.getColor((Context)this.getContext(), (int)R.attr.ib_fr_add_comment_edit_text_underline_color));
                    view.getLayoutParams().height = ViewUtils.convertDpToPx((Context)this.getContext(), (float)1.0f);
                }
                view.requestLayout();
                this.underLineName = view;
                return;
            }
        });
        textInputEditText2 = this.emailEditTextLayout;
        if (textInputEditText2 == null) {
            return;
        }
        TextInputEditText textInputEditText3 = textInputEditText2;
        textInputEditText3.setOnFocusChangeListener((view, bl) -> {
            TextInputLayout textInputLayout;
            AddCommentFragment addCommentFragment = this;
            view = addCommentFragment.underLineEmail;
            if (addCommentFragment.getContext() != null && view != null && (textInputLayout = this.emailInputLayout) != null && this.nameInputLayout != null) {
                if (bl) {
                    view.getLayoutParams().height = ViewUtils.convertDpToPx((Context)this.getContext(), (float)2.0f);
                    if (this.emailInputLayout.isErrorEnabled()) {
                        AddCommentFragment addCommentFragment2 = this;
                        addCommentFragment2.nameInputLayout.setErrorEnabled(true);
                        TextInputLayoutHelper.setUpperHintColor(addCommentFragment2.emailInputLayout, ContextCompat.getColor((Context)this.getContext(), (int)R.color.ib_fr_add_comment_error));
                        view.setBackgroundColor(ContextCompat.getColor((Context)addCommentFragment2.getContext(), (int)R.color.ib_fr_add_comment_error));
                    } else {
                        AddCommentFragment addCommentFragment3 = this;
                        addCommentFragment3.nameInputLayout.setErrorEnabled(false);
                        TextInputLayoutHelper.setUpperHintColor(addCommentFragment3.emailInputLayout, SettingsManager.getInstance().getPrimaryColor());
                        view.setBackgroundColor(SettingsManager.getInstance().getPrimaryColor());
                    }
                } else {
                    TextInputLayoutHelper.setUpperHintColor(textInputLayout, SettingsManager.getInstance().getPrimaryColor());
                    view.setBackgroundColor(AttrResolver.getColor((Context)this.getContext(), (int)R.attr.ib_fr_add_comment_edit_text_underline_color));
                    view.getLayoutParams().height = ViewUtils.convertDpToPx((Context)this.getContext(), (float)1.0f);
                }
                view.requestLayout();
                this.underLineEmail = view;
                return;
            }
        });
        textInputEditText3.addTextChangedListener((TextWatcher)new SimpleTextWatcher(){

            public void afterTextChanged(Editable editable) {
                if (AddCommentFragment.this.presenter == null) {
                    return;
                }
                3 v0 = this;
                TextInputEditText textInputEditText = v0.AddCommentFragment.this.commentEditTextLayout;
                if (v0.AddCommentFragment.this.presenter.isCommenterEmailRequired() && !editable.toString().equals(AddCommentFragment.this.presenter.getEnteredEmail())) {
                    if (AddCommentFragment.this.validateEmail()) {
                        if (textInputEditText != null && textInputEditText.getText() != null && !textInputEditText.getText().toString().trim().isEmpty()) {
                            AddCommentFragment.this.setToolbarPostTextViewEnabled(Boolean.TRUE);
                        }
                    } else {
                        AddCommentFragment.this.setToolbarPostTextViewEnabled(Boolean.FALSE);
                    }
                }
                if (AddCommentFragment.this.emailDisclaimer == null) {
                    return;
                }
                if (!TextUtils.isEmpty((CharSequence)editable.toString())) {
                    AddCommentFragment.this.emailDisclaimer.setVisibility(8);
                } else {
                    AddCommentFragment.this.emailDisclaimer.setVisibility(0);
                }
            }
        });
        textInputEditText.addTextChangedListener((TextWatcher)new SimpleTextWatcher(){

            public void afterTextChanged(Editable editable) {
                4 v0 = this;
                super.afterTextChanged(editable);
                editable = v0.AddCommentFragment.this.underLineComment;
                4 v1 = this;
                TextInputEditText textInputEditText2 = v1.AddCommentFragment.this.emailEditTextLayout;
                TextInputLayout textInputLayout = v1.AddCommentFragment.this.commentInputLayout;
                if (editable == null) {
                    return;
                }
                if (textInputEditText.getText() != null && textInputEditText.getText().toString().trim().isEmpty()) {
                    4 v2 = this;
                    AddCommentFragment addCommentFragment = v2.AddCommentFragment.this;
                    String string2 = addCommentFragment.getLocalizedString(R.string.feature_request_str_add_comment_comment_empty);
                    addCommentFragment.setFieldError(true, textInputLayout, (View)editable, string2);
                    v2.AddCommentFragment.this.setToolbarPostTextViewEnabled(Boolean.FALSE);
                } else {
                    AddCommentFragment addCommentFragment = AddCommentFragment.this;
                    Object object = addCommentFragment.getLocalizedString(R.string.feature_request_str_add_comment_comment_empty);
                    addCommentFragment.setFieldError(false, textInputLayout, (View)editable, (String)object);
                    if (textInputEditText2 != null && AddCommentFragment.this.presenter.isCommenterEmailRequired()) {
                        editable = textInputEditText2.getText();
                        object = AddCommentFragment.this;
                        ((AddCommentFragment)object).setToolbarPostTextViewEnabled(editable != null && !editable.toString().trim().isEmpty() && Patterns.EMAIL_ADDRESS.matcher(editable.toString()).matches());
                    } else {
                        AddCommentFragment.this.setToolbarPostTextViewEnabled(Boolean.TRUE);
                    }
                }
                4 v5 = this;
                AddCommentFragment.access$602(v5.AddCommentFragment.this, textInputEditText2);
                AddCommentFragment.access$702(v5.AddCommentFragment.this, textInputLayout);
            }
        });
    }

    public static AddCommentFragment newInstance(@NonNull long l) {
        Bundle bundle;
        AddCommentFragment addCommentFragment = new AddCommentFragment();
        Bundle bundle2 = bundle;
        new Bundle().putLong("featureId", l);
        addCommentFragment.setArguments(bundle2);
        return addCommentFragment;
    }

    private boolean validateCommentBody() {
        TextInputEditText textInputEditText;
        AddCommentFragment addCommentFragment = this;
        View view = addCommentFragment.underLineComment;
        if (addCommentFragment.getContext() != null && (textInputEditText = this.commentEditTextLayout) != null && view != null) {
            if (textInputEditText.getText() != null && TextUtils.isEmpty((CharSequence)this.commentEditTextLayout.getText().toString())) {
                AddCommentFragment addCommentFragment2 = this;
                textInputEditText = addCommentFragment2.commentInputLayout;
                String string2 = addCommentFragment2.getLocalizedString(R.string.feature_request_str_add_comment_comment_empty);
                addCommentFragment2.setFieldError(true, (TextInputLayout)textInputEditText, view, string2);
                textInputEditText = addCommentFragment2.commentInputLayout;
                if (textInputEditText != null) {
                    textInputEditText.requestFocus();
                }
                view.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.ib_fr_add_comment_error));
                return false;
            }
            AddCommentFragment addCommentFragment3 = this;
            addCommentFragment3.setFieldError(false, addCommentFragment3.commentInputLayout, view, null);
            addCommentFragment3.underLineComment = view;
            return true;
        }
        return false;
    }

    private boolean validateEmail() {
        TextInputEditText textInputEditText;
        if (addCommentFragment.emailInputLayout != null && addCommentFragment.underLineEmail != null && (textInputEditText = addCommentFragment.emailEditTextLayout) != null && textInputEditText.getText() != null) {
            AddCommentFragment addCommentFragment;
            if (!TextUtils.isEmpty((CharSequence)addCommentFragment.emailEditTextLayout.getText().toString()) && Patterns.EMAIL_ADDRESS.matcher(addCommentFragment.emailEditTextLayout.getText().toString()).matches()) {
                AddCommentFragment addCommentFragment2 = addCommentFragment;
                addCommentFragment = addCommentFragment2.emailInputLayout;
                textInputEditText = addCommentFragment2.underLineEmail;
                addCommentFragment2.setFieldError(false, (TextInputLayout)addCommentFragment, (View)textInputEditText, null);
                return true;
            }
            AddCommentFragment addCommentFragment3 = addCommentFragment;
            addCommentFragment = addCommentFragment3.emailInputLayout;
            textInputEditText = addCommentFragment3.underLineEmail;
            String string2 = addCommentFragment3.getLocalizedString(R.string.feature_request_str_add_comment_valid_email);
            addCommentFragment3.setFieldError(true, (TextInputLayout)addCommentFragment, (View)textInputEditText, string2);
            addCommentFragment3.emailEditTextLayout.requestFocus();
            return false;
        }
        return false;
    }

    private void setFieldError(boolean bl, @Nullable TextInputLayout textInputLayout, View view, @Nullable String string2) {
        if (this.getContext() == null) {
            return;
        }
        if (textInputLayout != null) {
            if (bl) {
                textInputLayout.setErrorEnabled(true);
                textInputLayout.setError((CharSequence)string2);
                TextInputLayoutHelper.setUpperHintColor(textInputLayout, ContextCompat.getColor((Context)this.getContext(), (int)R.color.ib_fr_add_comment_error));
                view.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.ib_fr_add_comment_error));
            } else {
                TextInputLayout textInputLayout2 = textInputLayout;
                TextInputLayoutHelper.setUpperHintColor(textInputLayout2, SettingsManager.getInstance().getPrimaryColor());
                textInputLayout2.setError(null);
                if (textInputLayout2.getEditText() != null && textInputLayout.getEditText().isFocused()) {
                    view.setBackgroundColor(SettingsManager.getInstance().getPrimaryColor());
                } else {
                    view.setBackgroundColor(AttrResolver.getColor((Context)this.getContext(), (int)R.attr.ib_fr_add_comment_edit_text_underline_color));
                }
                textInputLayout.setErrorEnabled(false);
            }
        }
    }

    private void setToolbarPostTextViewEnabled(Boolean bl) {
        if (this.toolbarPostTextView != null) {
            if (bl.booleanValue()) {
                AddCommentFragment addCommentFragment = this;
                addCommentFragment.toolbarPostTextView.setEnabled(true);
                addCommentFragment.toolbarPostTextView.setTextColor(this.getResources().getColor(17170443));
            } else {
                AddCommentFragment addCommentFragment = this;
                addCommentFragment.toolbarPostTextView.setEnabled(false);
                addCommentFragment.toolbarPostTextView.setTextColor(this.getResources().getColor(0x1060000));
            }
        }
    }

    static /* synthetic */ TextInputEditText access$602(AddCommentFragment addCommentFragment, TextInputEditText textInputEditText) {
        addCommentFragment.emailEditTextLayout = textInputEditText;
        return textInputEditText;
    }

    static /* synthetic */ TextInputLayout access$702(AddCommentFragment addCommentFragment, TextInputLayout textInputLayout) {
        addCommentFragment.commentInputLayout = textInputLayout;
        return textInputLayout;
    }

    public void onCreate(@Nullable Bundle bundle) {
        AddCommentFragment addCommentFragment = this;
        super.onCreate(bundle);
        addCommentFragment.presenter = new AddCommentPresenter(this);
        if (addCommentFragment.getArguments() != null) {
            this.featureId = this.getArguments().getLong("featureId");
        }
    }

    @Override
    protected ToolbarActionButton getToolbarCloseActionButton() {
        ToolbarActionButton.OnToolbarButtonClick onToolbarButtonClick;
        int n = R.drawable.ibg_core_ic_close;
        ToolbarActionButton.OnToolbarButtonClick onToolbarButtonClick2 = onToolbarButtonClick;
        onToolbarButtonClick = new ToolbarActionButton.OnToolbarButtonClick(){

            @Override
            public void onClick() {
                AddCommentFragment.this.presenter.onCloseButtonClicked();
            }
        };
        Object object = ToolbarActionButton.ViewType.ICON;
        return new ToolbarActionButton(n, R.string.close, onToolbarButtonClick2, (ToolbarActionButton.ViewType)((Object)object));
    }

    @Override
    protected void addToolbarActionButtons() {
        ToolbarActionButton.OnToolbarButtonClick onToolbarButtonClick;
        ToolbarActionButton.OnToolbarButtonClick onToolbarButtonClick2 = onToolbarButtonClick;
        onToolbarButtonClick = new ToolbarActionButton.OnToolbarButtonClick(){

            @Override
            public void onClick() {
                AddCommentFragment.this.presenter.onAddCommentButtonClicked();
            }
        };
        Object object = ToolbarActionButton.ViewType.TEXT;
        object.toolbarActionButtons.add(new ToolbarActionButton(-1, R.string.feature_request_str_post_comment, onToolbarButtonClick2, (ToolbarActionButton.ViewType)((Object)object)));
    }

    @Override
    protected String getTitle() {
        return this.getLocalizedString(R.string.feature_request_comments);
    }

    @Override
    protected int getContentLayout() {
        return R.layout.ib_fr_add_comment_fragment;
    }

    @Override
    protected void initContentViews(View view, @Nullable Bundle bundle) {
        View view2 = view;
        this.commentInputLayout = (TextInputLayout)view2.findViewById(R.id.feature_request_comment_text_input_layout);
        this.nameInputLayout = (TextInputLayout)view2.findViewById(R.id.feature_request_name_text_input_layout);
        this.emailInputLayout = (TextInputLayout)view2.findViewById(R.id.feature_request_email_text_input_layout);
        this.commentEditTextLayout = (TextInputEditText)view2.findViewById(R.id.feature_request_comment_edittext_layout);
        bundle = this.commentInputLayout;
        if (bundle != null) {
            bundle.setHint((CharSequence)(this.getLocalizedString(R.string.add_feature) + "*"));
        }
        View view3 = view;
        this.nameEditTextLayout = (TextInputEditText)view3.findViewById(R.id.feature_request_name_edittext_layout);
        this.emailEditTextLayout = (TextInputEditText)view3.findViewById(R.id.feature_request_email_edittext_layout);
        this.underLineComment = view3.findViewById(R.id.feature_requests_comment_text_underline);
        this.underLineName = view3.findViewById(R.id.feature_requests_name_text_underline);
        this.underLineEmail = view3.findViewById(R.id.feature_requests_email_text_underline);
        this.emailDisclaimer = (TextView)view3.findViewById(R.id.feature_request_email_disclaimer);
        if (Build.VERSION.SDK_INT > 34 && (view = (RelativeLayout)this.findViewById(R.id.ib_fr_comment_fragment_main_layout)) != null) {
            ViewUtilsKt.addSystemWindowInsetToPadding(view, true, false, true, true);
        }
        TextInputLayoutHelper.setUpperHintColor(this.commentInputLayout, SettingsManager.getInstance().getPrimaryColor());
        TextInputLayoutHelper.setUpperHintColor(this.nameInputLayout, SettingsManager.getInstance().getPrimaryColor());
        TextInputLayoutHelper.setUpperHintColor(this.emailInputLayout, SettingsManager.getInstance().getPrimaryColor());
        this.handleEditTextFocusChange();
        if (FeaturesRequestSettings.getInstance().isUserIdentificationStateEnabled()) {
            this.presenter.fillEmailAndName();
        } else {
            this.hideEmail();
            this.hideUserName();
        }
        this.presenter.handelRequiredFieldsHints();
        this.toolbarPostTextView = (TextView)this.findTextViewByTitle(R.string.feature_request_str_post_comment);
        this.setToolbarPostTextViewEnabled(Boolean.FALSE);
    }

    public void onStop() {
        AddCommentFragment addCommentFragment = this;
        super.onStop();
        if (addCommentFragment.getActivity() != null) {
            KeyboardUtils.hide((Activity)this.getActivity());
        }
    }

    public void onClick(View view) {
    }

    @Override
    public void onCloseButtonClicked() {
        if (this.getActivity() == null) {
            return;
        }
        this.getActivity().onBackPressed();
    }

    @Override
    public void validate() {
        if (!((AddCommentFragment)((Object)string2)).validateCommentBody()) {
            return;
        }
        if (((AddCommentFragment)((Object)string2)).presenter.isCommenterEmailRequired() && !((AddCommentFragment)((Object)string2)).validateEmail()) {
            return;
        }
        Object object = ((AddCommentFragment)((Object)string2)).commentEditTextLayout;
        if (object != null && ((AddCommentFragment)((Object)string2)).nameEditTextLayout != null && ((AddCommentFragment)((Object)string2)).emailEditTextLayout != null) {
            if (object.getText() != null && ((AddCommentFragment)((Object)string2)).nameEditTextLayout.getText() != null && ((AddCommentFragment)((Object)string2)).emailEditTextLayout.getText() != null) {
                AddCommentFragment addCommentFragment = string2;
                String string2 = addCommentFragment.commentEditTextLayout.getText().toString();
                object = addCommentFragment.nameEditTextLayout.getText().toString();
                String string3 = addCommentFragment.emailEditTextLayout.getText().toString();
                ((AddCommentFragment)((Object)string2)).presenter.addComment(new NewComment(((AddCommentFragment)((Object)string2)).featureId, string2, (String)object, string3));
            }
            return;
        }
    }

    @Override
    public void setUserEmail(String string2) {
        AddCommentFragment addCommentFragment = addCommentFragment.emailEditTextLayout;
        if (addCommentFragment != null) {
            addCommentFragment.setText(string2);
        }
    }

    @Override
    public void setUserName(String string2) {
        AddCommentFragment addCommentFragment = addCommentFragment.nameEditTextLayout;
        if (addCommentFragment != null) {
            addCommentFragment.setText(string2);
        }
    }

    @Override
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public void showLoadingDialog() {
        IBGProgressDialog iBGProgressDialog = this.preparingProgressDialog;
        if (iBGProgressDialog != null) {
            if (!iBGProgressDialog.isShowing()) {
                iBGProgressDialog.show();
            }
        } else {
            if (this.getActivity() == null) {
                return;
            }
            this.preparingProgressDialog = new IBGProgressDialog.Builder().setProgressColor(SettingsManager.getInstance().getPrimaryColor()).setMessage(this.getLocalizedString(R.string.feature_request_str_adding_your_comment)).build((Context)this.getActivity());
            this.preparingProgressDialog.show();
        }
    }

    @Override
    public void dismissLoadingDialog() {
        IBGProgressDialog iBGProgressDialog = this.preparingProgressDialog;
        if (iBGProgressDialog != null && iBGProgressDialog.isShowing()) {
            this.preparingProgressDialog.dismiss();
        }
    }

    @Override
    public void showError() {
        if (this.getActivity() == null) {
            return;
        }
        Toast.makeText((Context)this.getActivity(), (int)R.string.feature_request_str_add_comment_error, (int)1).show();
    }

    @Override
    public String getUsername() {
        TextInputEditText textInputEditText = this.nameEditTextLayout;
        if (textInputEditText != null && textInputEditText.getText() != null) {
            return this.nameEditTextLayout.getText().toString();
        }
        return "";
    }

    @Override
    public String getEmail() {
        TextInputEditText textInputEditText = this.emailEditTextLayout;
        if (textInputEditText != null && textInputEditText.getText() != null) {
            return this.emailEditTextLayout.getText().toString();
        }
        return "";
    }

    @Override
    public void setEmailHintStringWithAsterisk(boolean bl) {
        TextInputLayout textInputLayout = this.emailInputLayout;
        if (textInputLayout == null) {
            return;
        }
        if (bl) {
            textInputLayout.setHint((CharSequence)(this.getLocalizedString(R.string.ib_email_label) + "*"));
        } else {
            textInputLayout.setHint((CharSequence)this.getLocalizedString(R.string.ib_email_label));
        }
    }

    @Override
    public void onCommentAddedSuccessfully() {
        if (this.getActivity() == null) {
            return;
        }
        if (this.getActivity() instanceof FeaturesRequestActivity) {
            AddCommentFragment addCommentFragment = this;
            ((FeaturesRequestActivity)addCommentFragment.getActivity()).notifyCommentsChanged();
            addCommentFragment.getActivity().onBackPressed();
        }
    }
}

