/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.featuresrequest.network.service;

import androidx.annotation.Nullable;
import com.instabug.featuresrequest.cache.FeatureRequestsDBHelper;
import com.instabug.featuresrequest.models.FeatureRequest;
import com.instabug.featuresrequest.network.service.FeaturesRequestService;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugNetworkJob;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.util.InstabugSDKLogger;
import org.json.JSONObject;

public class FeaturesRequestVoteJob
extends InstabugNetworkJob {
    @Nullable
    private static FeaturesRequestVoteJob INSTANCE;

    private FeaturesRequestVoteJob() {
    }

    public static synchronized FeaturesRequestVoteJob getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FeaturesRequestVoteJob();
        }
        return INSTANCE;
    }

    private static void submitVotes() {
        InstabugSDKLogger.d((String)"IBG-FR", (String)"submitVotes started");
        for (FeatureRequest featureRequest : FeatureRequestsDBHelper.retrieve()) {
            int n = 3.$SwitchMap$com$instabug$featuresrequest$models$FeatureRequest$UserVoteStatus[featureRequest.getUserVoteStatus().ordinal()];
            if (n != 1) {
                if (n != 2) continue;
                FeaturesRequestVoteJob.sendVoteRequestWithMethod(featureRequest, "DELETE");
                continue;
            }
            FeaturesRequestVoteJob.sendVoteRequestWithMethod(featureRequest, "POST");
        }
    }

    private static void sendVoteRequestWithMethod(final FeatureRequest featureRequest, String object) {
        Request.Callbacks<JSONObject, Throwable> callbacks;
        if (Instabug.getApplicationContext() == null) {
            return;
        }
        String string2 = object;
        object = callbacks;
        callbacks = new Request.Callbacks<JSONObject, Throwable>(){

            public void onSucceeded(@Nullable JSONObject jSONObject) {
                FeatureRequestsDBHelper.delete(featureRequest.getFeatureId() + "");
            }

            public void onFailed(Throwable throwable) {
                if (throwable.getMessage() != null) {
                    InstabugSDKLogger.e((String)"IBG-FR", (String)throwable.getMessage(), (Throwable)throwable);
                }
            }
        };
        FeaturesRequestService.getInstance().vote(featureRequest.getFeatureId(), string2, (Request.Callbacks<JSONObject, Throwable>)object);
    }

    public void start() {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    FeaturesRequestVoteJob.submitVotes();
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e((String)"IBG-FR", (String)("Error " + exception.getMessage() + "occurred while voting for feature"), (Throwable)exception);
                }
            }
        };
        this.enqueueJob("IBG-FR", runnable2);
    }
}

