package com.instabug.featuresrequest.ui.base;

import com.instabug.featuresrequest.models.FeatureRequest;

import java.util.List;

/**
 * @author hossam.
 */

public abstract class BaseFeaturesListDao {

    protected int page = 1;

    protected void incrementPageNumber() {
        page += 1;
    }

    protected abstract List<FeatureRequest> getFeatures();

    protected abstract int getCompletedFeaturesCount();

    protected abstract int getFeaturesCount();

    protected abstract FeatureRequest getFeatureByIndex(int index);

    protected abstract void addFeatures(List<FeatureRequest> featureRequests);

    protected abstract void addFeature(FeatureRequest feature);

    protected abstract void destroy();

}
