package com.instabug.featuresrequest.ui.featuresmain;

import com.instabug.featuresrequest.listeners.OnTapSelectedListener;

import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentPagerAdapter;

/**
 * @author hossam.
 */

public class FeaturesMainViewPagerAdapter extends FragmentPagerAdapter {

    OnTapSelectedListener onTapSelectedListener;

    public FeaturesMainViewPagerAdapter(FragmentManager fm, OnTapSelectedListener
            onTapSelectedListener) {
        super(fm);
        this.onTapSelectedListener = onTapSelectedListener;
    }

    @Override
    public Fragment getItem(int position) {
        switch (position) {
            default:
            case 0:
                return onTapSelectedListener.onTapSelected(position);
            case 1:
                return onTapSelectedListener.onTapSelected(position);
        }
    }

    @Override
    public int getCount() {
        return 2;
    }

    @Nullable
    @Override
    public CharSequence getPageTitle(int position) {
        switch (position) {
            case 0:
                return "Features";
            case 1:
                return "My features";
            default:
                return "";
        }
//        return super.getPageTitle(position);
    }
}
