package com.instabug.featuresrequest.ui.custom;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewStub;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.CallSuper;
import androidx.annotation.LayoutRes;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.core.content.ContextCompat;

import com.instabug.featuresrequest.R;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.ui.BaseContract;
import com.instabug.library.core.ui.InstabugBaseFragment;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.LocaleHelper;

import java.util.ArrayList;

/**
 * Created by mohamedzakaria on 9/25/17.
 */

public abstract class DynamicToolbarFragment<P extends BaseContract.Presenter> extends
        InstabugBaseFragment<P> implements View.OnClickListener {

    @Nullable
    protected RelativeLayout toolbar;
    protected ArrayList<ToolbarActionButton> toolbarActionButtons = new ArrayList<>();
    @Nullable
    private LinearLayout actionButtonsLayout;

    @CallSuper
    @Override
    protected void initViews(View rootView, @Nullable Bundle savedInstanceState) {

        initToolbarViews(savedInstanceState);

        ViewStub content = findViewById(R.id.instabug_content);

        if (content != null) {
            content.setLayoutResource(getContentLayout());

            content.inflate();
        }

        initContentViews(rootView, savedInstanceState);

        setTitle(getTitle());
    }

    @Override
    protected int getLayout() {
        return R.layout.ib_fr_toolbar_fragment;
    }

    protected abstract ToolbarActionButton getToolbarCloseActionButton();

    protected void initToolbarViews(@Nullable Bundle savedInstanceState) {
        if (getContext() == null) return;


        RelativeLayout toolbar = findViewById(R.id.ib_fr_toolbar_main);
        if (toolbar != null) {
            if (Instabug.getTheme() == InstabugColorTheme.InstabugColorThemeLight) {
                toolbar.setBackgroundColor(InstabugCore.getPrimaryColor());
            } else {
                toolbar.setBackgroundColor(ContextCompat.getColor(getContext(), R.color
                        .ib_fr_toolbar_dark_color));
            }

            actionButtonsLayout = toolbar.findViewById(R.id
                    .ib_toolbar_action_btns_layout);
        }
        this.toolbar = toolbar;

        // set close button
        ImageButton closeButton = findViewById(R.id.instabug_btn_toolbar_left);
        if (closeButton != null) {
            if (LocaleHelper.isRTL(getContext())) {
                closeButton.setRotation(180);
            }
            final ToolbarActionButton closeActionBtn = getToolbarCloseActionButton();
            closeButton.setImageResource(closeActionBtn.getIcon());
            closeButton.setOnClickListener(view -> closeActionBtn.getOnToolbarButtonClick().onClick());
        }

        toolbarActionButtons.clear();
        addToolbarActionButtons();

        for (final ToolbarActionButton button : toolbarActionButtons) {
            switch (button.getViewType()) {
                case ICON:
                    @SuppressLint("InflateParams")
                    ImageView actionIcon = (ImageView) LayoutInflater.from(getContext())
                            .inflate(R.layout.ib_fr_toolbar_action_icon_view, null);
                    actionIcon.setImageResource(button.getIcon());
                    actionIcon.setOnClickListener(v -> button.getOnToolbarButtonClick().onClick());
                    if (actionButtonsLayout != null) {
                        actionButtonsLayout.addView(actionIcon);
                    }
                    break;
                case TEXT:
                    @SuppressLint("InflateParams")
                    TextView actionText = (TextView) LayoutInflater.from(getContext())
                            .inflate(R.layout.ib_fr_toolbar_action_text_view, null);
                    actionText.setText(button.getTitle());
                    actionText.setContentDescription(
                            getContext().getResources().getText(button.getTitle()));
                    actionText.setOnClickListener(v -> button.getOnToolbarButtonClick().onClick());
                    if (actionButtonsLayout != null) {
                        actionButtonsLayout.addView(actionText);
                    }
                    break;
                case VOTE:
                    @SuppressLint("InflateParams")
                    LinearLayout voteLayout = (LinearLayout) LayoutInflater.from(getContext())
                            .inflate(R.layout.ib_fr_toolbar_action_vote_button, null);
                    TextView voteCount = voteLayout.findViewById(R.id.ib_toolbar_vote_count);
                    IbFrRippleView ibFrRippleView = voteLayout.findViewById(R.id
                            .ib_feature_request_toolbar_vote_action_layout);

                    if (voteCount != null) {
                        voteCount.setText(button.getTitle());
                    }

                    if (ibFrRippleView != null) {
                        ibFrRippleView.setOnClickListener(v -> button.getOnToolbarButtonClick().onClick());
                    }
                    if (actionButtonsLayout != null) {
                        actionButtonsLayout.addView(voteLayout);
                    }
                    break;
                default:
                    break;
            }
        }
    }

    protected abstract void addToolbarActionButtons();

    /**
     * get toolbar title to be set
     *
     * @return
     */
    @Nullable
    protected abstract String getTitle();

    /**
     * set fragment title
     *
     * @param title fragment title
     */

    protected void setTitle(@Nullable String title) {
        if (rootView == null)
            return;

        TextView titleTextView = findViewById(R.id.instabug_fragment_title);
        if (titleTextView != null && title != null) {
            titleTextView.setText(title);
        }
    }

    /**
     * get layout resource file to be inflated
     *
     * @return
     */
    protected abstract
    @LayoutRes
    int getContentLayout();

    /**
     * Init fragment content views
     *
     * @param rootView           fragment root view.
     * @param savedInstanceState saved instance state
     */
    protected abstract void initContentViews(View rootView, @Nullable Bundle savedInstanceState);

    @Nullable
    public View findTextViewByTitle(@StringRes int titleRes) {
        String text = "";
        if (getContext() != null) {
            text = getContext().getResources().getString(titleRes);
        }
        if (actionButtonsLayout != null) {
            return findViewWithContentDescription(actionButtonsLayout, text);
        } else {
            return null;
        }
    }

    @Nullable
    public View findViewWithContentDescription(View src, String contentDescription) {

        ArrayList<View> potentialViews = new ArrayList<>();
        src.findViewsWithText(potentialViews, contentDescription, View.FIND_VIEWS_WITH_CONTENT_DESCRIPTION);
        View res = null;
        if (potentialViews.size() > 0) {
            res = potentialViews.get(0);
        }
        return res;
    }
}
