package com.instabug.featuresrequest.ui.addcomment;

import androidx.fragment.app.Fragment;

import com.instabug.featuresrequest.models.NewComment;
import com.instabug.library.core.ui.BaseContract;

import io.reactivexport.annotations.Nullable;

/**
 * Created by mzelzoghbi on 3/8/18.
 */

public interface AddCommentContract {
    interface View extends BaseContract.View<Fragment> {

        void onCloseButtonClicked();

        void validate();

        void setUserName(String username);

        void setUserEmail(String userEmail);

        void showLoadingDialog();

        void dismissLoadingDialog();

        void onCommentAddedSuccessfully();

        void showError();

        String getUsername();

        String getEmail();

        void setEmailHintStringWithAsterisk(boolean withAsterisk);
    }

    interface Presenter {

        void onCloseButtonClicked();

        void onAddCommentButtonClicked();

        void fillEmailAndName();

        void addComment(NewComment newComment);

        boolean isCommenterEmailRequired();

        @Nullable
        String getEnteredEmail();

        @Nullable
        String getEnteredUsername();

        void handelRequiredFieldsHints();
    }
}
