/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.bug;

import android.text.TextUtils;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.instabug.bug.h.a;
import com.instabug.chat.ChatsDelegate;
import com.instabug.library.APIBuildChecker;
import com.instabug.library.Feature;
import com.instabug.library.OnSdkDismissCallback;
import com.instabug.library.OnSdkDismissedCallback;
import com.instabug.library.analytics.AnalyticsObserver;
import com.instabug.library.analytics.model.Api;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.extendedbugreport.ExtendedBugReport;
import com.instabug.library.invocation.InstabugInvocationEvent;
import com.instabug.library.invocation.InvocationManager;
import com.instabug.library.invocation.OnInvokeCallback;
import com.instabug.library.invocation.util.InstabugFloatingButtonEdge;
import com.instabug.library.invocation.util.InstabugVideoRecordingButtonPosition;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class BugReporting {
    private static final String TAG = "BugReporting";

    public static void setInvocationEvents(InstabugInvocationEvent ... invocationEvents) {
        InstabugInvocationEvent[] instabugInvocationEventArray;
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("instabugInvocationEvent").setType(InstabugInvocationEvent.class).setValue((Object)TextUtils.join((CharSequence)",", (Object[])instabugInvocationEventArray))});
        InvocationManager.getInstance().setInstabugInvocationEvent(instabugInvocationEventArray);
    }

    public static void setOptions(int ... options) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("options").setType(int[].class)});
        com.instabug.bug.a.a(options);
    }

    public static void setOnInvokeCallback(OnInvokeCallback onInvokeCallback) throws IllegalStateException {
        OnInvokeCallback onInvokeCallback2;
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("setOnInvokeCallback").setType(Runnable.class)});
        InstabugSDKLogger.i((Object)TAG, (String)"setInvokeCallback");
        SettingsManager.getInstance().setOnInvokeCallback(onInvokeCallback2);
    }

    public static void setOnDismissCallback(OnSdkDismissCallback onSdkDismissedCallback) throws IllegalStateException {
        OnSdkDismissCallback onSdkDismissCallback;
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("onSdkDismissedCallback").setType(OnSdkDismissedCallback.class)});
        InstabugSDKLogger.i((Object)TAG, (String)"setOnDismissCallback");
        ChatsDelegate.setOnSdkDismissCallback((OnSdkDismissCallback)onSdkDismissedCallback);
        com.instabug.bug.settings.a.r().a(onSdkDismissCallback);
    }

    public static void setShakingThreshold(int threshold) {
        int n2;
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("threshold").setType(Integer.TYPE).setValue((Object)Integer.toString(n2))});
        InstabugSDKLogger.i((Object)TAG, (String)("setShakingThreshold: " + n2));
        InvocationManager.getInstance().getCurrentInvocationSettings().setShakingThreshold(n2);
    }

    public static void setFloatingButtonEdge(@NonNull InstabugFloatingButtonEdge instabugFloatingButtonEdge) {
        InstabugFloatingButtonEdge instabugFloatingButtonEdge2;
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("instabugFloatingButtonEdge").setType(InstabugFloatingButtonEdge.class).setValue((Object)instabugFloatingButtonEdge2)});
        InstabugSDKLogger.i((Object)TAG, (String)("setFloatingButtonEdge: " + instabugFloatingButtonEdge2));
        InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonEdge(instabugFloatingButtonEdge2);
    }

    public static void setFloatingButtonOffset(@IntRange(from=0L) int floatingButtonOffsetFromTop) {
        int n2;
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("floatingButtonOffsetFromTop").setType(Integer.TYPE).setValue((Object)Integer.toString(n2))});
        InstabugSDKLogger.i((Object)TAG, (String)("setFloatingButtonOffset: " + n2));
        InvocationManager.getInstance().getCurrentInvocationSettings().setFloatingButtonOffsetFromTop(n2);
    }

    public static void setVideoRecordingFloatingButtonPosition(@NonNull InstabugVideoRecordingButtonPosition instabugViewRecordingButtonPosition) {
        InstabugVideoRecordingButtonPosition instabugVideoRecordingButtonPosition;
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("instabugViewRecordingButtonPosition").setType(InstabugVideoRecordingButtonPosition.class).setValue((Object)instabugVideoRecordingButtonPosition)});
        InstabugSDKLogger.i((Object)TAG, (String)("setVideoRecordingFloatingButtonPosition: " + instabugVideoRecordingButtonPosition));
        InvocationManager.getInstance().getCurrentInvocationSettings().setVideoRecordingButtonPosition(instabugVideoRecordingButtonPosition);
    }

    public static void setExtendedBugReportState(@NonNull ExtendedBugReport.State state) {
        ExtendedBugReport.State state2;
        APIBuildChecker.check();
        if (state == null) {
            InstabugSDKLogger.w((Object)TAG, (String)"state object passed to BugReporting.setExtendedBugReportState() is null");
            return;
        }
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        InstabugSDKLogger.i((Object)TAG, (String)("setExtendedBugReportState: " + state2));
        int n2 = a.a[state2.ordinal()];
        a.a a2 = n2 != 1 ? (n2 != 2 ? a.a.DISABLED : a.a.ENABLED_WITH_OPTIONAL_FIELDS) : a.a.ENABLED_WITH_REQUIRED_FIELDS;
        com.instabug.bug.settings.a.r().a(a2);
    }

    @RequiresApi(value=21)
    public static void setAutoScreenRecordingEnabled(boolean autoScreenRecordingEnabled) {
        boolean bl;
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("setAutoScreenRecordingEnabled").setType(Boolean.class).setValue((Object)String.valueOf(bl))});
        InstabugSDKLogger.i((Object)TAG, (String)("setAutoScreenRecordingEnabled: " + bl));
        com.instabug.bug.a.a(autoScreenRecordingEnabled);
    }

    public static void setReportTypes(int ... types) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("types").setType(int[].class)});
        com.instabug.bug.a.b(types);
    }

    public static void show(@ReportType int type) {
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("type").setType(Integer.TYPE)});
        com.instabug.bug.a.a(type);
    }

    /*
     * WARNING - void declaration
     */
    public static void show(@ReportType int type, int ... options) {
        void var1_1;
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("type").setType(Integer.TYPE)});
        com.instabug.bug.a.a(type, (int[])var1_1);
    }

    public static void setState(@NonNull Feature.State state) {
        Feature.State state2;
        APIBuildChecker.check();
        if (state == null) {
            InstabugSDKLogger.w((Object)TAG, (String)"state object passed to BugReporting.setState() is null");
            return;
        }
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("state").setType(Feature.State.class)});
        com.instabug.bug.a.b(state2);
    }

    public static void setViewHierarchyState(@NonNull Feature.State state) {
        Feature.State state2;
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("state").setType(Feature.State.class).setValue((Object)state2)});
        InstabugSDKLogger.i((Object)TAG, (String)("setViewHierarchyState: " + state2));
        InstabugCore.setFeatureState((Feature)Feature.VIEW_HIERARCHY_V2, (Feature.State)state2);
    }

    /*
     * WARNING - void declaration
     */
    public static void setAttachmentTypesEnabled(boolean initialScreenshot, boolean extraScreenshot, boolean imageFromGallery, boolean screenRecording) {
        void var3_3;
        void var2_2;
        void var1_1;
        boolean bl;
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("initialScreenshot").setType(Boolean.class).setValue((Object)Boolean.toString(bl)), new Api.Parameter().setName("extraScreenshot").setType(Boolean.class).setValue((Object)Boolean.toString((boolean)var1_1)), new Api.Parameter().setName("galleryImage").setType(Boolean.class).setValue((Object)Boolean.toString((boolean)var2_2)), new Api.Parameter().setName("screenRecording").setType(Boolean.class).setValue((Object)Boolean.toString((boolean)var3_3))});
        InstabugCore.setInitialScreenShotAllowed((boolean)bl);
        com.instabug.bug.a.a(initialScreenshot, (boolean)var1_1, (boolean)var2_2, (boolean)var3_3);
    }

    @RequiresApi(value=21)
    public static void setScreenshotByMediaProjectionEnabled(boolean enabled) {
        boolean bl;
        APIBuildChecker.check();
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[0]);
        InstabugSDKLogger.i((Object)TAG, (String)("setScreenshotByMediaProjectionEnabled: " + bl));
        SettingsManager.getInstance().setScreenshotByMediaProjectionEnabled(bl);
    }

    protected static void setScreenshotRequired(boolean screenshotRequired) {
        boolean bl;
        AnalyticsObserver.getInstance().catchApiUsage(new Api.Parameter[]{new Api.Parameter().setName("screenshotRequired").setType(Boolean.TYPE)});
        InstabugSDKLogger.i((Object)TAG, (String)("setScreenshotRequired: " + bl));
        com.instabug.bug.settings.a.r().e(bl);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ReportType {
        public static final int BUG = 0;
        public static final int FEEDBACK = 1;
        public static final int QUESTION = 2;
    }
}

